/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.widgets.client.assets.dropdown;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdown;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItemsProvider;
import org.uberfire.mvp.Command;

public abstract class AbstractKieAssetsDropdown
implements KieAssetsDropdown {
    protected final KieAssetsDropdown.View view;
    protected final KieAssetsDropdownItemsProvider dataProvider;
    protected final List<KieAssetsDropdownItem> kieAssets = new ArrayList<KieAssetsDropdownItem>();
    protected Command onValueChangeHandler = () -> {};

    public AbstractKieAssetsDropdown(KieAssetsDropdown.View view, KieAssetsDropdownItemsProvider dataProvider) {
        this.view = view;
        this.dataProvider = dataProvider;
    }

    @Override
    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    @Override
    public void registerOnChangeHandler(Command onChangeHandler) {
        this.onValueChangeHandler = onChangeHandler;
    }

    @Override
    public void loadAssets() {
        this.clear();
        this.initializeDropdown();
    }

    @Override
    public void initialize() {
        this.view.refreshSelectPicker();
    }

    @Override
    public void clear() {
        this.kieAssets.clear();
        this.view.clear();
    }

    @Override
    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public Optional<KieAssetsDropdownItem> getValue() {
        String currentValue = this.view.getValue();
        return this.kieAssets.stream().filter(kieAsset -> Objects.equals(currentValue, kieAsset.getValue())).findAny();
    }

    @Override
    public void onValueChanged() {
        this.onValueChangeHandler.execute();
    }

    @Override
    public void initializeDropdown() {
        this.dataProvider.getItems(this.getAssetListConsumer());
    }

    @Override
    public void addValue(KieAssetsDropdownItem kieAsset) {
        this.kieAssets.add(kieAsset);
        this.view.addValue(kieAsset);
    }

    protected Consumer<List<KieAssetsDropdownItem>> getAssetListConsumer() {
        return this::assetListConsumerMethod;
    }

    protected void assetListConsumerMethod(List<KieAssetsDropdownItem> assetList) {
        assetList.forEach(this::addValue);
        this.view.refreshSelectPicker();
        this.view.initialize();
    }
}

