/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.util;

import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.util.ScratchPad;
import com.ait.lienzo.client.widget.panel.Bounds;
import com.ait.lienzo.client.widget.panel.impl.BoundsProviderFactory;
import com.ait.lienzo.shared.core.types.DataURLType;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;

public class LienzoLayerUtils {
    private static final BoundsProviderFactory.WiresBoundsProvider WIRES_BOUNDS_PROVIDER = new BoundsProviderFactory.WiresBoundsProvider();

    public static String layerToDataURL(LienzoLayer lienzoLayer, DataURLType dataURLType, int x, int y, int width, int height, String bgColor) {
        Layer layer = lienzoLayer.getLienzoLayer();
        ScratchPad scratchPad = layer.getScratchPad();
        scratchPad.setPixelSize(width, height);
        if (null != bgColor) {
            scratchPad.getContext().setFillColor(bgColor);
            scratchPad.getContext().fillRect(0.0, 0.0, (double)width, (double)height);
        }
        layer.drawWithTransforms(scratchPad.getContext(), 1.0, new BoundingBox((double)x, (double)y, (double)width, (double)height));
        String data = scratchPad.toDataURL(dataURLType, 1.0);
        scratchPad.clear();
        return data;
    }

    public static Bounds computeBounds(LienzoLayer layer) {
        return WIRES_BOUNDS_PROVIDER.get(layer.getLienzoLayer());
    }

    public static String getUUID_At(LienzoLayer lienzoLayer, double x, double y) {
        int sx = (int)x;
        int sy = (int)y;
        Shape shape = lienzoLayer.getLienzoLayer().getLayer().findShapeAtPoint(sx, sy);
        String viewUUID = LienzoLayerUtils.getShapeUUID(shape);
        return viewUUID;
    }

    private static String getShapeUUID(Shape<?> lienzoShape) {
        if (null != lienzoShape) {
            Node parent;
            if (LienzoLayerUtils.hasUUID(lienzoShape)) {
                return LienzoLayerUtils.getNodeViewUUID(lienzoShape);
            }
            for (parent = lienzoShape.getParent(); null != parent && !LienzoLayerUtils.hasUUID(parent); parent = parent.getParent()) {
            }
            if (null != parent) {
                return LienzoLayerUtils.getNodeViewUUID(parent);
            }
        }
        return null;
    }

    private static boolean hasUUID(Node<?> node) {
        return WiresUtils.getShapeUUID(node) != null;
    }

    private static String getNodeViewUUID(Node<?> node) {
        return WiresUtils.getShapeUUID(node);
    }
}

