/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.views;

import com.google.gwt.event.shared.HandlerRegistration;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoPanel;

@Dependent
public class LienzoCanvasNotification {
    private final View view;
    Supplier<LienzoPanel> panel;
    HandlerRegistration outHandler;

    @Inject
    public LienzoCanvasNotification(View view) {
        this.view = view;
    }

    public void init(Supplier<LienzoPanel> panel) {
        this.panel = panel;
        this.outHandler = panel.get().getView().addMouseOutHandler(mouseOutEvent -> this.hide());
    }

    public void show(String text) {
        LienzoPanel p = this.panel.get();
        int absoluteLeft = p.getView().getAbsoluteLeft();
        int absoluteTop = p.getView().getAbsoluteTop();
        int width = p.getWidthPx();
        double x = absoluteLeft + width / 2 - 5 * text.length();
        double y = absoluteTop + 50;
        this.view.at(x, y);
        this.view.setText(text);
        this.view.show();
    }

    public void hide() {
        this.view.setText("");
        this.view.hide();
    }

    @PreDestroy
    public void destroy() {
        if (null != this.outHandler) {
            this.outHandler.removeHandler();
            this.outHandler = null;
        }
        this.panel = null;
    }

    public static interface View {
        public void setText(String var1);

        public void at(double var1, double var3);

        public void show();

        public void hide();
    }
}

