/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.mediators;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Composite;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.ZoomLevelSelector;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.ZoomLevelSelectorItem;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class ZoomLevelSelectorView
extends Composite
implements ZoomLevelSelector.View {
    static final String CSS_DROP_UP = "dropup";
    @Inject
    @DataField
    Button decreaseButton;
    @Inject
    @DataField
    Button increaseButton;
    @Inject
    @DataField
    Button resetButton;
    @Inject
    @DataField
    Div dropDownPanelGroup;
    @Inject
    @DataField
    Div dropDownPanel;
    @Inject
    @DataField
    Button dropDownButton;
    @Inject
    @DataField
    Span dropDownText;
    @Inject
    @DataField
    UnorderedList dropDownMenu;
    @Inject
    @Any
    ManagedInstance<ZoomLevelSelectorItem> items;
    @Inject
    ClientTranslationService translationService;
    private ZoomLevelSelector presenter;

    public void init(ZoomLevelSelector presenter) {
        this.presenter = presenter;
        ZoomLevelSelectorView.setTooltip(this.increaseButton, this.translationService.getNotNullValue("org.kie.workbench.common.stunner.core.increase"));
        ZoomLevelSelectorView.setTooltip(this.decreaseButton, this.translationService.getNotNullValue("org.kie.workbench.common.stunner.core.decrease"));
        ZoomLevelSelectorView.setTooltip(this.resetButton, this.translationService.getNotNullValue("org.kie.workbench.common.stunner.core.reset"));
    }

    @Override
    public void add(String text, Command onClick) {
        ZoomLevelSelectorItem item = (ZoomLevelSelectorItem)this.items.get();
        item.setText(text);
        item.setOnClick(onClick);
        this.dropDownMenu.appendChild((Node)item.getElement());
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.dropDownMenu);
    }

    public void setSelectedValue(String selectedItem) {
        this.dropDownText.setTextContent(selectedItem);
    }

    @Override
    public void setText(String text) {
        this.dropDownText.setTextContent(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dropDownButton.setDisabled(!enabled);
    }

    @Override
    public void dropUp() {
        this.dropDownPanelGroup.setClassName(this.dropDownPanelGroup.getClassName() + " " + CSS_DROP_UP);
    }

    @EventHandler(value={"increaseButton"})
    void onIncreaseLevel(ClickEvent event) {
        this.presenter.onIncreaseLevel();
    }

    @EventHandler(value={"decreaseButton"})
    void onDecreaseLevel(ClickEvent event) {
        this.presenter.onDecreaseLevel();
    }

    @EventHandler(value={"resetButton"})
    void onReset(ClickEvent event) {
        this.presenter.onReset();
    }

    @EventHandler(value={"dropDownButton"})
    void onDropDownKeyDown(KeyDownEvent event) {
        this.onDropDownKeyEvent((DomEvent)event);
    }

    @EventHandler(value={"dropDownButton"})
    void onDropDownKeyUp(KeyUpEvent event) {
        this.onDropDownKeyEvent((DomEvent)event);
    }

    @EventHandler(value={"dropDownButton"})
    void onDropDownKeyPress(KeyPressEvent event) {
        this.onDropDownKeyEvent((DomEvent)event);
    }

    private void onDropDownKeyEvent(DomEvent event) {
        event.preventDefault();
        event.stopPropagation();
    }

    @PreDestroy
    public void destroy() {
        this.clear();
        this.items.destroyAll();
        this.presenter = null;
    }

    private static void setTooltip(Button button, String text) {
        button.setAttribute("data-placement", "top");
        button.setTitle(text);
    }
}

