/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.components.mediators;

import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoPanel;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.LienzoCanvasMediators;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.ZoomLevelSelectorPresenter;
import org.kie.workbench.common.stunner.client.lienzo.components.views.LienzoPanelFocusHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;

@Dependent
public class LienzoPanelMediators {
    static final double MIN_SCALE = 0.25;
    static final double MAX_SCALE = 2.0;
    static final double ZOOM_FACTOR = 0.1;
    private final LienzoCanvasMediators mediators;
    private final ZoomLevelSelectorPresenter selector;
    LienzoPanelFocusHandler focusHandler;

    @Inject
    public LienzoPanelMediators(LienzoCanvasMediators mediators, ZoomLevelSelectorPresenter selector) {
        this.mediators = mediators;
        this.selector = selector;
    }

    public LienzoPanelMediators init(Supplier<LienzoCanvas> canvas) {
        CanvasPanel panel = canvas.get().getView().getPanel();
        if (panel instanceof LienzoPanel) {
            this.focusHandler = new LienzoPanelFocusHandler().listen((LienzoPanel)canvas.get().getView().getPanel(), this::enable, this::disable);
            this.mediators.init(canvas);
            this.selector.init(canvas);
            this.setZoomFactor(0.1);
            this.setMinScale(0.25);
            this.setMaxScale(2.0);
            this.enable();
        }
        return this;
    }

    public LienzoPanelMediators setMinScale(double minScale) {
        this.selector.setMinScale(minScale);
        this.mediators.setMinScale(minScale);
        return this;
    }

    public LienzoPanelMediators setMaxScale(double maxScale) {
        this.selector.setMaxScale(maxScale);
        this.mediators.setMaxScale(maxScale);
        return this;
    }

    public LienzoPanelMediators setZoomFactor(double factor) {
        this.selector.setZoomFactor(factor);
        this.mediators.setZoomFactor(factor);
        return this;
    }

    public void enable() {
        this.mediators.enable();
        this.selector.show();
    }

    public void disable() {
        this.mediators.disable();
        this.selector.scheduleHide();
    }

    @PreDestroy
    public void destroy() {
        if (null != this.focusHandler) {
            this.focusHandler.clear();
            this.focusHandler = null;
        }
    }
}

