/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.wires;

import com.ait.lienzo.client.core.shape.wires.IConnectionAcceptor;
import com.ait.lienzo.client.core.shape.wires.IContainmentAcceptor;
import com.ait.lienzo.client.core.shape.wires.IControlPointsAcceptor;
import com.ait.lienzo.client.core.shape.wires.IDockingAcceptor;
import com.ait.lienzo.client.core.shape.wires.ILocationAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvasView;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresLayer;
import org.kie.workbench.common.stunner.client.lienzo.wires.WiresManagerFactory;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasDrawnEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;

@Dependent
public class WiresCanvas
extends LienzoCanvas<WiresCanvasView> {
    public static final String WIRES_CANVAS_GROUP_ID = "stnner.wiresCanvas";
    private final WiresManagerFactory wiresManagerFactory;
    private WiresCanvasView view;
    private WiresManager wiresManager;

    @Inject
    public WiresCanvas(Event<CanvasClearEvent> canvasClearEvent, Event<CanvasShapeAddedEvent> canvasShapeAddedEvent, Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent, Event<CanvasDrawnEvent> canvasDrawnEvent, Event<CanvasFocusedEvent> canvasFocusedEvent, @Default WiresManagerFactory wiresManagerFactory, WiresCanvasView view) {
        super(canvasClearEvent, canvasShapeAddedEvent, canvasShapeRemovedEvent, canvasDrawnEvent, canvasFocusedEvent);
        this.view = view;
        this.wiresManagerFactory = wiresManagerFactory;
    }

    @Override
    public AbstractCanvas<WiresCanvasView> initialize(CanvasPanel panel, CanvasSettings settings) {
        super.initialize(panel, settings);
        WiresLayer layer = this.getView().getLayer();
        this.wiresManager = this.wiresManagerFactory.newWiresManager(layer.getLienzoLayer());
        this.wiresManager.setSpliceEnabled(false);
        this.wiresManager.setLocationAcceptor(ILocationAcceptor.NONE);
        this.wiresManager.setContainmentAcceptor(IContainmentAcceptor.NONE);
        this.wiresManager.setDockingAcceptor(IDockingAcceptor.NONE);
        this.wiresManager.setConnectionAcceptor(IConnectionAcceptor.NONE);
        this.wiresManager.setControlPointsAcceptor(IControlPointsAcceptor.NONE);
        this.view.use(this.wiresManager);
        return this;
    }

    protected void addChild(Shape shape) {
        this.getView().addRoot(shape.getShapeView());
    }

    protected void deleteChild(Shape shape) {
        this.getView().deleteRoot(shape.getShapeView());
    }

    public WiresCanvasView getView() {
        return this.view;
    }

    public WiresManager getWiresManager() {
        return this.wiresManager;
    }
}

