/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.export;

import com.ait.lienzo.client.core.Context2D;
import com.ait.lienzo.client.core.INativeContext2D;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.client.widget.panel.Bounds;
import com.ait.lienzo.shared.core.types.DataURLType;
import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.export.DelegateNativeContext2D;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.util.LienzoLayerUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.export.CanvasExport;
import org.kie.workbench.common.stunner.core.client.canvas.export.CanvasExportSettings;
import org.kie.workbench.common.stunner.core.client.canvas.export.CanvasURLExportSettings;
import org.uberfire.ext.editor.commons.client.file.exports.svg.Context2DFactory;
import org.uberfire.ext.editor.commons.client.file.exports.svg.IContext2D;
import org.uberfire.ext.editor.commons.client.file.exports.svg.SvgExportSettings;

@ApplicationScoped
public class LienzoCanvasExport
implements CanvasExport<AbstractCanvasHandler> {
    public static final String BG_COLOR = "#FFFFFF";
    public static final int PADDING = 25;
    private final BoundsProvider boundsProvider;

    public LienzoCanvasExport() {
        this(new WiresLayerBoundsProvider());
    }

    LienzoCanvasExport(BoundsProvider boundsProvider) {
        this.boundsProvider = boundsProvider;
    }

    public IContext2D toContext2D(AbstractCanvasHandler canvasHandler, CanvasExportSettings settings) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        Layer lienzoLayer = layer.getLienzoLayer();
        Viewport viewport = lienzoLayer.getViewport();
        int[] bounds = this.boundsProvider.compute(layer, settings);
        IContext2D svgContext2D = Context2DFactory.create((SvgExportSettings)new SvgExportSettings((double)bounds[2], (double)bounds[3], (Object)lienzoLayer.getContext()));
        Transform transform = viewport.getTransform();
        viewport.setTransform(new Transform());
        lienzoLayer.draw(new Context2D((INativeContext2D)new DelegateNativeContext2D(svgContext2D, canvasHandler)));
        viewport.setTransform(transform);
        lienzoLayer.draw();
        return svgContext2D;
    }

    public String toImageData(AbstractCanvasHandler canvasHandler, CanvasURLExportSettings settings) {
        LienzoLayer layer = LienzoCanvasExport.getLayer(canvasHandler);
        int[] bounds = this.boundsProvider.compute(layer, (CanvasExportSettings)settings);
        return LienzoLayerUtils.layerToDataURL(layer, LienzoCanvasExport.getDataType(settings.getUrlDataType()), bounds[0], bounds[1], bounds[2], bounds[3], BG_COLOR);
    }

    private static DataURLType getDataType(CanvasExport.URLDataType type) {
        switch (type) {
            case JPG: {
                return DataURLType.JPG;
            }
            case PNG: {
                return DataURLType.PNG;
            }
        }
        throw new UnsupportedOperationException("Export data type [" + type.name() + "] not supported ");
    }

    private static LienzoLayer getLayer(AbstractCanvasHandler canvasHandler) {
        return ((WiresCanvas)canvasHandler.getCanvas()).getView().getLayer();
    }

    public static class WiresLayerBoundsProvider
    implements BoundsProvider {
        @Override
        public int[] compute(LienzoLayer layer, CanvasExportSettings settings) {
            int[] result = new int[4];
            Bounds bounds = LienzoLayerUtils.computeBounds(layer);
            result[0] = (int)bounds.getX();
            result[1] = (int)bounds.getY();
            if (settings.hasSize()) {
                result[2] = settings.getWide();
                result[3] = settings.getHigh();
            } else {
                result[2] = Math.round((float)(bounds.getX() + bounds.getWidth()));
                result[3] = Math.round((float)(bounds.getY() + bounds.getHeight()));
            }
            return new int[]{result[0], result[1], result[2] + 25, result[3] + 25};
        }
    }

    public static interface BoundsProvider {
        public int[] compute(LienzoLayer var1, CanvasExportSettings var2);
    }
}

