/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.LienzoLayer;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvasView;
import org.kie.workbench.common.stunner.client.lienzo.components.mediators.LienzoPanelMediators;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.MediatorsControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasLostFocusEvent;

@Dependent
@Default
public class LienzoMediatorsControl<C extends AbstractCanvas>
extends AbstractCanvasControl<C>
implements MediatorsControl<C> {
    private final LienzoPanelMediators mediators;

    @Inject
    public LienzoMediatorsControl(LienzoPanelMediators mediators) {
        this.mediators = mediators;
    }

    protected void doInit() {
        this.mediators.init(this::getCanvas);
    }

    public MediatorsControl<C> setMinScale(double minScale) {
        this.mediators.setMinScale(minScale);
        return this;
    }

    public MediatorsControl<C> setMaxScale(double maxScale) {
        this.mediators.setMaxScale(maxScale);
        return this;
    }

    public MediatorsControl<C> setZoomFactor(double factor) {
        this.mediators.setZoomFactor(factor);
        return this;
    }

    public MediatorsControl<C> scale(double factor) {
        this.getLayer().scale(factor);
        return this;
    }

    public MediatorsControl<C> scale(double sx, double sy) {
        this.getLayer().scale(sx, sy);
        return this;
    }

    public MediatorsControl<C> translate(double tx, double ty) {
        this.getLayer().translate(tx, ty);
        return this;
    }

    void onCanvasFocusedEvent(@Observes CanvasFocusedEvent focusedEvent) {
        if (null != this.canvas && this.canvas.equals((Object)focusedEvent.getCanvas())) {
            this.mediators.enable();
        }
    }

    void onCanvasLostFocusEvent(@Observes CanvasLostFocusEvent lostFocusEvent) {
        if (null != this.canvas && this.canvas.equals((Object)lostFocusEvent.getCanvas())) {
            this.mediators.disable();
        }
    }

    private WiresCanvas getCanvas() {
        return (WiresCanvas)this.canvas;
    }

    private LienzoLayer getLayer() {
        WiresCanvas wiresCanvas = this.getCanvas();
        WiresCanvasView view = wiresCanvas.getView();
        return view.getLayer();
    }
}

