/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IDockingAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresContainer;
import com.ait.lienzo.client.core.shape.wires.WiresShape;
import java.util.function.Function;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.controls.AbstractAcceptorControl;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Node;

@Dependent
@Default
public class DockingAcceptorControlImpl
extends AbstractAcceptorControl
implements DockingAcceptorControl<AbstractCanvasHandler> {
    private static final int HOTSPOT = 10;
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final IDockingAcceptor DOCKING_ACCEPTOR = new IDockingAcceptor(){

        public boolean dockingAllowed(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!DockingAcceptorControlImpl.this.isWiresViewAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return DockingAcceptorControlImpl.this.allow(parentNode, childNode);
        }

        public boolean acceptDocking(WiresContainer wiresContainer, WiresShape wiresShape) {
            if (!DockingAcceptorControlImpl.this.isWiresViewAccept(wiresContainer, wiresShape)) {
                return false;
            }
            Node childNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), (WiresContainer)wiresShape);
            Node parentNode = WiresUtils.getNode(DockingAcceptorControlImpl.this.getCanvasHandler(), wiresContainer);
            return DockingAcceptorControlImpl.this.accept(parentNode, childNode);
        }

        public int getHotspotSize() {
            return 10;
        }
    };

    @Inject
    public DockingAcceptorControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory) {
        this.canvasCommandFactory = canvasCommandFactory;
    }

    @Override
    protected void onInit(WiresCanvas canvas) {
        canvas.getWiresManager().setDockingAcceptor(this.DOCKING_ACCEPTOR);
    }

    @Override
    protected void onDestroy(WiresCanvas canvas) {
        canvas.getWiresManager().setDockingAcceptor(IDockingAcceptor.NONE);
    }

    public boolean allow(Node parent, Node child) {
        return this.evaluate(parent, child, command -> this.getCommandManager().allow((Object)this.getCanvasHandler(), command));
    }

    public boolean accept(Node parent, Node child) {
        return this.evaluate(parent, child, command -> this.getCommandManager().execute((Object)this.getCanvasHandler(), command));
    }

    private boolean evaluate(Node parent, Node child, Function<Command<AbstractCanvasHandler, CanvasViolation>, CommandResult<CanvasViolation>> executor) {
        return null != parent && this.isCommandSuccess(executor.apply((Command<AbstractCanvasHandler, CanvasViolation>)this.canvasCommandFactory.updateDockNode(parent, child)));
    }
}

