/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.client.lienzo.canvas.controls;

import com.ait.lienzo.client.core.shape.wires.IControlPointsAcceptor;
import com.ait.lienzo.client.core.shape.wires.WiresConnector;
import com.ait.lienzo.client.core.shape.wires.WiresManager;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.client.lienzo.canvas.wires.WiresCanvas;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresConnectorView;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ControlPointControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;

@Dependent
@Default
public class ControlPointControlImpl
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ControlPointControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(ControlPointControlImpl.class.getName());
    private final CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;
    private final StunnerControlPointsAcceptor cpAcceptor;
    private final Event<CanvasSelectionEvent> selectionEvent;
    private RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> commandManagerProvider;

    @Inject
    public ControlPointControlImpl(CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, Event<CanvasSelectionEvent> selectionEvent) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.cpAcceptor = new StunnerControlPointsAcceptor(this, this::getEdge);
        this.selectionEvent = selectionEvent;
    }

    protected void doInit() {
        super.doInit();
        this.getWiresManager().setControlPointsAcceptor((IControlPointsAcceptor)this.cpAcceptor);
    }

    protected void doDestroy() {
        super.doDestroy();
        this.getWiresManager().setControlPointsAcceptor(IControlPointsAcceptor.ALL);
        this.commandManagerProvider = null;
    }

    public void register(Element element) {
    }

    public void addControlPoint(Edge candidate, ControlPoint controlPoint, int index) {
        this.selectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)this.canvasHandler, candidate.getUUID()));
        this.execute((CanvasCommand<AbstractCanvasHandler>)this.canvasCommandFactory.addControlPoint(candidate, controlPoint, index));
    }

    public void updateControlPoints(Edge candidate, ControlPoint[] controlPoints) {
        this.execute((CanvasCommand<AbstractCanvasHandler>)this.canvasCommandFactory.updateControlPointPosition(candidate, controlPoints));
    }

    public void deleteControlPoint(Edge candidate, int index) {
        this.execute((CanvasCommand<AbstractCanvasHandler>)this.canvasCommandFactory.deleteControlPoint(candidate, index));
    }

    public void setCommandManagerProvider(RequiresCommandManager.CommandManagerProvider<AbstractCanvasHandler> provider) {
        this.commandManagerProvider = provider;
    }

    private CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.commandManagerProvider.getCommandManager();
    }

    private void execute(CanvasCommand<AbstractCanvasHandler> command) {
        CommandResult result = this.getCommandManager().execute((Object)this.canvasHandler, command);
        if (CommandUtils.isError((CommandResult)result)) {
            LOGGER.log(Level.SEVERE, "Cannot execute command [command= " + command + ", result=" + result + "]");
        }
    }

    private Edge getEdge(String uuid) {
        return this.canvasHandler.getGraphIndex().getEdge(uuid);
    }

    private WiresManager getWiresManager() {
        return ((WiresCanvas)this.canvasHandler.getCanvas()).getWiresManager();
    }

    public static class StunnerControlPointsAcceptor
    implements IControlPointsAcceptor {
        private final ControlPointControl control;
        private final Function<String, Edge> connectorSupplier;
        private HandlerRegistration handlerRegistration;
        private WiresConnector connector;
        private int index;
        private com.ait.lienzo.client.core.types.Point2D location;

        public StunnerControlPointsAcceptor(ControlPointControl control, Function<String, Edge> connectorSupplier) {
            this.control = control;
            this.connectorSupplier = connectorSupplier;
        }

        public boolean add(WiresConnector connector, int index, com.ait.lienzo.client.core.types.Point2D location) {
            this.resetAddingOp();
            this.proposeAdd(connector, index, location);
            return true;
        }

        public boolean move(WiresConnector connector, Point2DArray pointsLocation) {
            this.completeAddOrMove(connector, pointsLocation);
            this.resetAddingOp();
            return true;
        }

        public boolean delete(WiresConnector connector, int index) {
            this.deleteAtIndex(connector, index);
            this.resetAddingOp();
            return true;
        }

        private void proposeAdd(WiresConnector connector, int index, com.ait.lienzo.client.core.types.Point2D location) {
            this.connector = connector;
            this.index = index;
            this.location = location.copy();
            this.handlerRegistration = connector.getGroup().getLayer().addNodeMouseUpHandler(event -> this.performAdd());
            connector.addControlPoint(location.getX(), location.getY(), index);
        }

        private void completeAddOrMove(WiresConnector connector, Point2DArray pointsLocation) {
            if (null != this.connector && this.connector.equals((Object)connector)) {
                this.location = pointsLocation.get(this.index).copy();
                this.performAdd();
            } else {
                int size = pointsLocation.size() - 2;
                Edge edge = this.getEdge(connector);
                ControlPoint[] controlPoints = new ControlPoint[size];
                for (int i = 1; i <= size; ++i) {
                    com.ait.lienzo.client.core.types.Point2D point = pointsLocation.get(i);
                    controlPoints[i - 1] = ControlPoint.build((Point2D)Point2D.create((double)point.getX(), (double)point.getY()));
                }
                this.control.updateControlPoints(edge, controlPoints);
            }
        }

        private void performAdd() {
            if (null != this.connector) {
                this.connector.destroyControlPoints(new int[]{this.index});
                Edge edge = this.getEdge(this.connector);
                this.control.addControlPoint(edge, ControlPoint.build((double)this.location.getX(), (double)this.location.getY()), this.index - 1);
                this.resetAddingOp();
            }
        }

        private void deleteAtIndex(WiresConnector connector, int index) {
            Edge edge = this.getEdge(connector);
            this.control.deleteControlPoint(edge, index - 1);
        }

        private void resetAddingOp() {
            this.connector = null;
            this.index = -1;
            this.location = null;
            if (null != this.handlerRegistration) {
                this.handlerRegistration.removeHandler();
            }
        }

        private Edge getEdge(WiresConnector connector) {
            return this.getEdge(StunnerControlPointsAcceptor.getUUID(connector));
        }

        private Edge getEdge(String uuid) {
            return this.connectorSupplier.apply(uuid);
        }

        private static String getUUID(WiresConnector connector) {
            return connector instanceof WiresConnectorView ? ((WiresConnectorView)connector).getUUID() : connector.uuid();
        }
    }
}

