/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.kmodule.converters;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.drools.core.util.AbstractXStreamConverter;
import org.kie.workbench.common.services.shared.kmodule.FileLogger;

public class FileLoggerConverter
extends AbstractXStreamConverter {
    public FileLoggerConverter() {
        super(FileLogger.class);
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        FileLogger logger = (FileLogger)value;
        writer.addAttribute("name", logger.getName());
        writer.addAttribute("file", logger.getFile());
        writer.addAttribute("threaded", Boolean.toString(logger.isThreaded()));
        writer.addAttribute("interval", Integer.toString(logger.getInterval()));
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        FileLogger logger = new FileLogger();
        logger.setName(reader.getAttribute("name"));
        logger.setFile(reader.getAttribute("file"));
        logger.setThreaded(Boolean.parseBoolean(reader.getAttribute("threaded")));
        logger.setInterval(Integer.parseInt(reader.getAttribute("interval")));
        return logger;
    }
}

