/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOModuleCacheEvent;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.backend.allowlist.PackageNameAllowListServiceImpl;
import org.kie.workbench.common.services.backend.builder.JavaSourceFilter;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUModuleDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.core.LRUPomModelCache;
import org.kie.workbench.common.services.backend.builder.core.NoBuilderFoundException;
import org.kie.workbench.common.services.shared.allowlist.PackageNameAllowListService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.io.IOService;

@ApplicationScoped
public class LRUBuilderCache
extends LRUCache<Module, Builder> {
    private static final Logger logger = LoggerFactory.getLogger(LRUBuilderCache.class);
    protected static final String BUILDER_CACHE_SIZE = "org.kie.builder.cache.size";
    protected static final String DEFAULT_BUILDER_CACHE_SIZE = "20";
    protected static final int MAX_ENTRIES = Integer.parseInt(LRUBuilderCache.validateCacheSize(System.getProperty("org.kie.builder.cache.size", "20")));
    private final List<BuildValidationHelper> buildValidationHelpers = new ArrayList<BuildValidationHelper>();
    private final List<Predicate<String>> classFilters = new ArrayList<Predicate<String>>();
    private IOService ioService;
    private KieModuleService moduleService;
    private ProjectImportsService importsService;
    private Instance<BuildValidationHelper> buildValidationHelperBeans;
    private LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache;
    private LRUPomModelCache pomModelCache;
    private PackageNameAllowListServiceImpl packageNameAllowListService;
    private Instance<Predicate<String>> classFilterBeans;

    public LRUBuilderCache() {
    }

    @Inject
    public LRUBuilderCache(@Named(value="ioStrategy") IOService ioService, KieModuleService moduleService, ProjectImportsService importsService, @Any Instance<BuildValidationHelper> buildValidationHelperBeans, @Named(value="LRUModuleDependenciesClassLoaderCache") LRUModuleDependenciesClassLoaderCache dependenciesClassLoaderCache, @Named(value="LRUPomModelCache") LRUPomModelCache pomModelCache, PackageNameAllowListService packageNameAllowListService, @JavaSourceFilter Instance<Predicate<String>> classFilterBeans) {
        super(MAX_ENTRIES);
        this.ioService = ioService;
        this.moduleService = moduleService;
        this.importsService = importsService;
        this.buildValidationHelperBeans = buildValidationHelperBeans;
        this.dependenciesClassLoaderCache = dependenciesClassLoaderCache;
        this.pomModelCache = pomModelCache;
        this.packageNameAllowListService = (PackageNameAllowListServiceImpl)packageNameAllowListService;
        this.classFilterBeans = classFilterBeans;
    }

    @PostConstruct
    public void loadInstances() {
        StreamSupport.stream(this.buildValidationHelperBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.buildValidationHelpers));
        StreamSupport.stream(this.classFilterBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.classFilters));
    }

    @PreDestroy
    public void destroyInstances() {
        this.buildValidationHelpers.forEach(helper -> this.buildValidationHelperBeans.destroy(helper));
        this.classFilters.forEach(filter -> this.classFilterBeans.destroy(filter));
    }

    protected static String validateCacheSize(String value) {
        if (value == null || value.length() == 0 || !value.matches("^[0-9]*$")) {
            logger.error("Illeagal Argument : Property {} should be a positive integer", (Object)BUILDER_CACHE_SIZE);
            return DEFAULT_BUILDER_CACHE_SIZE;
        }
        return value;
    }

    public void invalidateProjectCache(@Observes InvalidateDMOModuleCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Module project = event.getModule();
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public Builder assertBuilder(POM pom) throws NoBuilderFoundException {
        for (Module project : this.getKeys()) {
            if (!project.getPom().getGav().equals((Object)pom.getGav())) continue;
            return this.makeBuilder(project);
        }
        throw new NoBuilderFoundException();
    }

    public Builder assertBuilder(Module module) {
        return this.makeBuilder(module);
    }

    public Builder getBuilder(Module module) {
        return (Builder)this.getEntry(module);
    }

    private Builder makeBuilder(Module module) {
        Builder builder = (Builder)this.getEntry(module);
        if (builder == null) {
            builder = new Builder(module, this.ioService, this.moduleService, this.importsService, this.buildValidationHelpers, this.dependenciesClassLoaderCache, this.pomModelCache, this.packageNameAllowListService, this.createSingleClassFilterPredicate());
            this.setEntry(module, builder);
        }
        return builder;
    }

    private Predicate<String> createSingleClassFilterPredicate() {
        return this.classFilters.stream().reduce(o -> true, (p1, p2) -> p1.and(p2));
    }
}

