"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOrderByObject = exports.buildTaskInboxWhereArgument = void 0;
var lodash_1 = __importDefault(require("lodash"));
var createSearchTextArray = function (taskNames) {
    var formattedTextArray = [];
    taskNames.forEach(function (word) {
        formattedTextArray.push({
            referenceName: {
                like: "*".concat(word, "*")
            }
        });
    });
    return {
        or: formattedTextArray
    };
};
var createUserAssignmentClause = function (currentUser) {
    return {
        or: [
            { actualOwner: { equal: currentUser.id } },
            {
                and: [
                    { actualOwner: { isNull: true } },
                    {
                        not: { excludedUsers: { contains: currentUser.id } }
                    },
                    {
                        or: [
                            { potentialUsers: { contains: currentUser.id } },
                            { potentialGroups: { containsAny: currentUser.groups } }
                        ]
                    }
                ]
            }
        ]
    };
};
var buildTaskInboxWhereArgument = function (currentUser, activeFilters) {
    if (activeFilters) {
        var filtersClause = [];
        if (activeFilters.taskStates.length > 0) {
            filtersClause.push({
                state: { in: activeFilters.taskStates }
            });
        }
        if (activeFilters.taskNames.length > 0) {
            filtersClause.push(createSearchTextArray(activeFilters.taskNames));
        }
        if (filtersClause.length > 0) {
            return {
                and: [
                    createUserAssignmentClause(currentUser),
                    {
                        and: filtersClause
                    }
                ]
            };
        }
    }
    return createUserAssignmentClause(currentUser);
};
exports.buildTaskInboxWhereArgument = buildTaskInboxWhereArgument;
var getOrderByObject = function (sortBy) {
    if (!lodash_1.default.isEmpty(sortBy)) {
        return lodash_1.default.set({}, sortBy.property, sortBy.direction.toUpperCase());
    }
    return {
        lastUpdate: 'DESC'
    };
};
exports.getOrderByObject = getOrderByObject;
//# sourceMappingURL=QueryUtils.js.map