"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var Bullseye_1 = require("@patternfly/react-core/dist/js/layouts/Bullseye");
var ServerErrors_1 = require("@kogito-apps/components-common/dist/components/ServerErrors");
var KogitoSpinner_1 = require("@kogito-apps/components-common/dist/components/KogitoSpinner");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var PageSectionHeader_1 = require("@kogito-apps/consoles-common/dist/components/layout/PageSectionHeader");
var ProcessDetailsContainer_1 = __importDefault(require("../../containers/ProcessDetailsContainer/ProcessDetailsContainer"));
var ProcessDetails_1 = require("../../../channel/ProcessDetails");
var react_router_1 = require("react-router");
require("../../styles.css");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var ProcessDetailsPage = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe, props = __rest(_a, ["ouiaId", "ouiaSafe"]);
    (0, react_1.useEffect)(function () {
        return (0, OuiaUtils_1.ouiaPageTypeAndObjectId)('process-details');
    });
    var gatewayApi = (0, ProcessDetails_1.useProcessDetailsGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var history = (0, react_router_1.useHistory)();
    var processId = props.match.params.instanceID;
    var _b = __read((0, react_1.useState)({}), 2), processInstance = _b[0], setProcessInstance = _b[1];
    var _c = __read((0, react_1.useState)(false), 2), isLoading = _c[0], setIsLoading = _c[1];
    var _d = __read((0, react_1.useState)(''), 2), fetchError = _d[0], setFetchError = _d[1];
    var currentPage = JSON.parse(window.localStorage.getItem('state'));
    (0, react_1.useEffect)(function () {
        window.onpopstate = function () {
            props.history.push({ state: Object.assign({}, props.location.state) });
        };
    });
    function fetchDetails() {
        return __awaiter(this, void 0, void 0, function () {
            var response, responseError, error_1, prevPath, tempPath;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        response = {};
                        responseError = '';
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, 4, 5]);
                        setIsLoading(true);
                        return [4, gatewayApi.processDetailsQuery(processId)];
                    case 2:
                        response = _a.sent();
                        setProcessInstance(response);
                        return [3, 5];
                    case 3:
                        error_1 = _a.sent();
                        responseError = error_1;
                        setFetchError(error_1);
                        return [3, 5];
                    case 4:
                        setIsLoading(false);
                        if (responseError.length === 0 &&
                            fetchError.length === 0 &&
                            Object.keys(response).length === 0) {
                            prevPath = void 0;
                            if (currentPage) {
                                currentPage = Object.assign({}, currentPage, props.location.state);
                                tempPath = currentPage.prev.split('/');
                                prevPath = tempPath.filter(function (item) { return item; });
                            }
                            history.push({
                                pathname: '/NoData',
                                state: {
                                    prev: currentPage ? currentPage.prev : '/ProcessInstances',
                                    title: 'Process not found',
                                    description: "Process instance with the id ".concat(processId, " not found"),
                                    buttonText: currentPage
                                        ? "Go to ".concat(prevPath[0]
                                            .replace(/([A-Z])/g, ' $1')
                                            .trim()
                                            .toLowerCase())
                                        : 'Go to process instances',
                                    rememberedData: Object.assign({}, props.location.state)
                                }
                            });
                        }
                        return [7];
                    case 5: return [2];
                }
            });
        });
    }
    (0, react_1.useEffect)(function () {
        if (processId) {
            fetchDetails();
        }
    }, [processId]);
    var renderItems = function () {
        if (!isLoading) {
            return ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: processInstance &&
                    Object.keys(processInstance).length > 0 &&
                    !fetchError ? ((0, jsx_runtime_1.jsx)(ProcessDetailsContainer_1.default, { processInstance: processInstance })) : ((0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, { children: fetchError.length > 0 && ((0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: "kogito-management-console__card-size" }, { children: (0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, { children: (0, jsx_runtime_1.jsx)(ServerErrors_1.ServerErrors, { error: fetchError, variant: "large" }) }) }))) })) }));
        }
        else {
            return ((0, jsx_runtime_1.jsx)(Card_1.Card, { children: (0, jsx_runtime_1.jsx)(KogitoSpinner_1.KogitoSpinner, { spinnerText: "Loading process details..." }) }));
        }
    };
    return ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(PageSectionHeader_1.PageSectionHeader, { titleText: "".concat(appContext.customLabels.singularProcessLabel, " Details"), ouiaId: ouiaId }), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'process-details-page-section', ouiaSafe), { children: renderItems() }))] }));
};
exports.default = ProcessDetailsPage;
//# sourceMappingURL=ProcessDetailsPage.js.map