"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var react_router_dom_1 = require("react-router-dom");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var task_inbox_1 = require("@kogito-apps/task-inbox");
var TaskInboxContext_1 = require("../../../channel/TaskInbox/TaskInboxContext");
var Utils_1 = require("../../../utils/Utils");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var TaskInboxContainer = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, TaskInboxContext_1.useTaskInboxGatewayApi)();
    var taskInboxApiRef = react_1.default.useRef();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    (0, react_1.useEffect)(function () {
        var unsubscriber = gatewayApi.onOpenTaskListen({
            onOpen: function (task) {
                history.push("/TaskDetails/".concat(task.id));
            }
        });
        var unsubscribeUserChange = appContext.onUserChange({
            onUserChange: function (user) {
                taskInboxApiRef.current.taskInbox__notify(user.id);
            }
        });
        return function () {
            unsubscriber.unSubscribe();
            unsubscribeUserChange.unSubscribe();
        };
    }, []);
    return ((0, jsx_runtime_1.jsx)(task_inbox_1.EmbeddedTaskInbox, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'task-inbox-container', ouiaSafe), { initialState: gatewayApi.taskInboxState, driver: gatewayApi, allTaskStates: (0, Utils_1.getAllTaskStates)(), activeTaskStates: (0, Utils_1.getActiveTaskStates)(), targetOrigin: appContext.getDevUIUrl(), ref: taskInboxApiRef })));
};
exports.default = TaskInboxContainer;
//# sourceMappingURL=TaskInboxContainer.js.map