"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var task_form_1 = require("@kogito-apps/task-form");
var TaskFormContext_1 = require("../../../channel/TaskForms/TaskFormContext");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var TaskFormContainer = function (_a) {
    var userTask = _a.userTask, onSubmitSuccess = _a.onSubmitSuccess, onSubmitError = _a.onSubmitError, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, TaskFormContext_1.useTaskFormGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    return ((0, jsx_runtime_1.jsx)(task_form_1.EmbeddedTaskForm, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'task-form-container', ouiaSafe), { userTask: userTask, user: appContext.getCurrentUser(), driver: {
            doSubmit: function (phase, payload) {
                return new Promise(function (resolve, reject) {
                    gatewayApi
                        .doSubmit(userTask, phase, payload)
                        .then(function (response) {
                        onSubmitSuccess(phase);
                        resolve(response);
                    })
                        .catch(function (error) {
                        var message = error.response
                            ? error.response.data
                            : error.message;
                        onSubmitError(phase, message);
                        reject(error);
                    });
                });
            },
            getTaskFormSchema: function () {
                return gatewayApi.getTaskFormSchema(userTask);
            },
            getCustomForm: function () {
                return gatewayApi.getCustomForm(userTask);
            }
        }, targetOrigin: appContext.getDevUIUrl() })));
};
exports.default = TaskFormContainer;
//# sourceMappingURL=TaskFormContainer.js.map