"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = require("react");
var react_router_dom_1 = require("react-router-dom");
var pages_1 = require("../../pages");
var NoData_1 = require("@kogito-apps/consoles-common/dist/components/pages/NoData");
var PageNotFound_1 = require("@kogito-apps/consoles-common/dist/components/pages/PageNotFound");
var ProcessDetailsPage_1 = __importDefault(require("../../pages/ProcessDetailsPage/ProcessDetailsPage"));
var TaskInboxPage_1 = __importDefault(require("../../pages/TaskInboxPage/TaskInboxPage"));
var TaskDetailsPage_1 = __importDefault(require("../../pages/TaskDetailsPage/TaskDetailsPage"));
var FormsListPage_1 = __importDefault(require("../../pages/FormsListPage/FormsListPage"));
var FormDetailsPage_1 = __importDefault(require("../../pages/FormDetailsPage/FormDetailsPage"));
var trusty_1 = require("@kogito-apps/trusty");
var ProcessFormPage_1 = __importDefault(require("../../pages/ProcessFormPage/ProcessFormPage"));
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var MonitoringPage_1 = __importDefault(require("../../pages/MonitoringPage/MonitoringPage"));
var WorkflowFormPage_1 = __importDefault(require("../../pages/WorkflowFormPage/WorkflowFormPage"));
var CustomDashboardListPage_1 = __importDefault(require("../../pages/CustomDashboardListPage/CustomDashboardListPage"));
var CustomDashboardViewPage_1 = __importDefault(require("../../pages/CustomDashboardViewPage/CustomDashboardViewPage"));
var CloudEventFormPage_1 = __importDefault(require("../../pages/CloudEventFormPage/CloudEventFormPage"));
var DevUIRoutes = function (_a) {
    var trustyServiceUrl = _a.trustyServiceUrl, dataIndexUrl = _a.dataIndexUrl, navigate = _a.navigate;
    var context = (0, DevUIAppContext_1.useDevUIAppContext)();
    var defaultPath = (0, react_1.useMemo)(function () {
        if (context.isProcessEnabled) {
            return '/JobsManagement';
        }
        if (context.isTracingEnabled) {
            return '/Audit';
        }
    }, [context.isProcessEnabled, context.isTracingEnabled]);
    var defaultButton = (0, react_1.useMemo)(function () {
        if (context.isProcessEnabled) {
            return 'Go to jobs management';
        }
        if (context.isTracingEnabled) {
            return 'Go to audit';
        }
    }, [context.isProcessEnabled, context.isTracingEnabled]);
    var routes = (0, react_1.useMemo)(function () { return [
        {
            enabled: function () { return true; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/", render: function () { return (0, jsx_runtime_1.jsx)(react_router_dom_1.Redirect, { to: "/".concat(navigate) }); } }, "0"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/Processes", component: pages_1.ProcessesPage }, "1"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/Process/:instanceID", component: ProcessDetailsPage_1.default }, "2"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/JobsManagement", component: pages_1.JobsManagementPage }, "3"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/TaskInbox", component: TaskInboxPage_1.default }, "4"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: (0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/Forms", component: FormsListPage_1.default }, "5")
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/Forms/:formName", component: FormDetailsPage_1.default }, "6"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/ProcessDefinition/Form/:processName", component: ProcessFormPage_1.default }, "7"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/WorkflowDefinition/Form/:workflowName", component: WorkflowFormPage_1.default }, "8"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/CustomDashboard", component: CustomDashboardListPage_1.default }, "9"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/CustomDashboard/:customDashboardName", component: CustomDashboardViewPage_1.default }, "10"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/TaskDetails/:taskId", render: function (routeProps) { return (0, jsx_runtime_1.jsx)(TaskDetailsPage_1.default, __assign({}, routeProps)); } }, "11"))
        },
        {
            enabled: function () { return context.isTracingEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, __assign({ path: "/Audit" }, { children: (0, jsx_runtime_1.jsx)(trusty_1.TrustyApp, { counterfactualEnabled: false, explanationEnabled: false, containerConfiguration: {
                        pageWrapper: false,
                        serverRoot: trustyServiceUrl,
                        basePath: '/Audit',
                        excludeReactRouter: true,
                        useHrefLinks: false
                    } }) }), "12"))
        },
        {
            enabled: function () { return context.isProcessEnabled; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, __assign({ path: "/Monitoring" }, { children: (0, jsx_runtime_1.jsx)(MonitoringPage_1.default, { dataIndexUrl: dataIndexUrl }) }), "13"))
        },
        {
            enabled: function () { return true; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { path: "/NoData", render: function (_props) { return ((0, jsx_runtime_1.jsx)(NoData_1.NoData, __assign({}, _props, { defaultPath: defaultPath, defaultButton: defaultButton }))); } }, "14"))
        },
        {
            enabled: function () { return context.isWorkflow(); },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/Processes/CloudEvent/:instanceId?", component: CloudEventFormPage_1.default }, "16"))
        },
        {
            enabled: function () { return context.isWorkflow(); },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { exact: true, path: "/WorkflowDefinitions/CloudEvent", component: CloudEventFormPage_1.default }, "17"))
        },
        {
            enabled: function () { return true; },
            node: ((0, jsx_runtime_1.jsx)(react_router_dom_1.Route, { path: "*", render: function (_props) { return ((0, jsx_runtime_1.jsx)(PageNotFound_1.PageNotFound, __assign({}, _props, { defaultPath: defaultPath, defaultButton: defaultButton }))); } }, "18"))
        }
    ]; }, [context.isProcessEnabled, context.isTracingEnabled, context.isWorkflow()]);
    return ((0, jsx_runtime_1.jsx)(react_router_dom_1.Switch, { children: routes.filter(function (r) { return r.enabled(); }).map(function (r) { return r.node; }) }));
};
exports.default = DevUIRoutes;
//# sourceMappingURL=DevUIRoutes.js.map