"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCustomWorkflowSchema = exports.getCustomDashboardContent = exports.getCustomDashboard = exports.startWorkflowRest = exports.triggerCloudEvent = exports.triggerStartCloudEvent = exports.startProcessInstance = exports.getProcessSchema = exports.getProcessDefinitionList = exports.saveFormContent = exports.getFormContent = exports.getForms = exports.handleNodeInstanceRetrigger = exports.handleNodeInstanceCancel = exports.handleProcessVariableUpdate = exports.handleNodeTrigger = exports.getTriggerableNodes = exports.handleProcessMultipleAction = exports.handleProcessAbort = exports.handleProcessRetry = exports.handleProcessSkip = exports.getSvg = exports.handleJobReschedule = exports.jobCancel = exports.performMultipleCancel = void 0;
var BulkList_1 = require("@kogito-apps/management-console-shared/dist/components/BulkList");
var axios_1 = __importDefault(require("axios"));
var uuid_1 = __importDefault(require("uuid"));
var swagger_parser_1 = __importDefault(require("@apidevtools/swagger-parser"));
var Utils_1 = require("../../utils/Utils");
var dist_1 = require("@kogito-apps/cloud-event-form/dist");
var performMultipleCancel = function (jobsToBeActioned) { return __awaiter(void 0, void 0, void 0, function () {
    var successJobs, failedJobs, jobsToBeActioned_1, jobsToBeActioned_1_1, job, error_1, e_1_1;
    var e_1, _a;
    return __generator(this, function (_b) {
        switch (_b.label) {
            case 0:
                successJobs = [];
                failedJobs = [];
                _b.label = 1;
            case 1:
                _b.trys.push([1, 8, 9, 10]);
                jobsToBeActioned_1 = __values(jobsToBeActioned), jobsToBeActioned_1_1 = jobsToBeActioned_1.next();
                _b.label = 2;
            case 2:
                if (!!jobsToBeActioned_1_1.done) return [3, 7];
                job = jobsToBeActioned_1_1.value;
                _b.label = 3;
            case 3:
                _b.trys.push([3, 5, , 6]);
                return [4, axios_1.default.delete("".concat(job.endpoint, "/").concat(job.id))];
            case 4:
                _b.sent();
                successJobs.push(job);
                return [3, 6];
            case 5:
                error_1 = _b.sent();
                job.errorMessage = JSON.stringify(error_1.message);
                failedJobs.push(job);
                return [3, 6];
            case 6:
                jobsToBeActioned_1_1 = jobsToBeActioned_1.next();
                return [3, 2];
            case 7: return [3, 10];
            case 8:
                e_1_1 = _b.sent();
                e_1 = { error: e_1_1 };
                return [3, 10];
            case 9:
                try {
                    if (jobsToBeActioned_1_1 && !jobsToBeActioned_1_1.done && (_a = jobsToBeActioned_1.return)) _a.call(jobsToBeActioned_1);
                }
                finally { if (e_1) throw e_1.error; }
                return [7];
            case 10: return [2, { successJobs: successJobs, failedJobs: failedJobs }];
        }
    });
}); };
exports.performMultipleCancel = performMultipleCancel;
var jobCancel = function (job) { return __awaiter(void 0, void 0, void 0, function () {
    var modalTitle, modalContent, error_2;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                _a.trys.push([0, 2, , 3]);
                return [4, axios_1.default.delete("".concat(job.endpoint, "/").concat(job.id))];
            case 1:
                _a.sent();
                modalTitle = 'success';
                modalContent = "The job: ".concat(job.id, " is canceled successfully");
                return [2, { modalTitle: modalTitle, modalContent: modalContent }];
            case 2:
                error_2 = _a.sent();
                modalTitle = 'failure';
                modalContent = "The job: ".concat(job.id, " failed to cancel. Error message: ").concat(error_2.message);
                return [2, { modalTitle: modalTitle, modalContent: modalContent }];
            case 3: return [2];
        }
    });
}); };
exports.jobCancel = jobCancel;
var handleJobReschedule = function (job, repeatInterval, repeatLimit, scheduleDate) { return __awaiter(void 0, void 0, void 0, function () {
    var modalTitle, modalContent, parameter, error_3;
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0:
                parameter = {};
                if (repeatInterval === null && repeatLimit === null) {
                    parameter = {
                        expirationTime: new Date(scheduleDate)
                    };
                }
                else {
                    parameter = {
                        expirationTime: new Date(scheduleDate),
                        repeatInterval: repeatInterval,
                        repeatLimit: repeatLimit
                    };
                }
                _a.label = 1;
            case 1:
                _a.trys.push([1, 3, , 4]);
                return [4, axios_1.default.patch("".concat(job.endpoint, "/").concat(job.id), parameter)];
            case 2:
                _a.sent();
                modalTitle = 'success';
                modalContent = "Reschedule of job: ".concat(job.id, " is successful");
                return [2, { modalTitle: modalTitle, modalContent: modalContent }];
            case 3:
                error_3 = _a.sent();
                modalTitle = 'failure';
                modalContent = "Reschedule of job ".concat(job.id, " failed. Message: ").concat(error_3.message);
                return [2, { modalTitle: modalTitle, modalContent: modalContent }];
            case 4: return [2];
        }
    });
}); };
exports.handleJobReschedule = handleJobReschedule;
var getSvg = function (data) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, axios_1.default
                .get("/svg/processes/".concat(data.processId, "/instances/").concat(data.id))
                .then(function (res) {
                return { svg: res.data };
            })
                .catch(function (error) { return __awaiter(void 0, void 0, void 0, function () {
                return __generator(this, function (_a) {
                    if (data.serviceUrl) {
                        return [2, axios_1.default
                                .get("".concat(data.serviceUrl, "/svg/processes/").concat(data.processId, "/instances/").concat(data.id))
                                .then(function (res) {
                                return { svg: res.data };
                            })
                                .catch(function (err) {
                                if (err.response && err.response.status !== 404) {
                                    return { error: err.message };
                                }
                            })];
                    }
                    return [2];
                });
            }); })];
    });
}); };
exports.getSvg = getSvg;
var handleProcessSkip = function (processInstance) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) {
                axios_1.default
                    .post("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id, "/skip"))
                    .then(function () {
                    resolve();
                })
                    .catch(function (error) { return reject(error); });
            })];
    });
}); };
exports.handleProcessSkip = handleProcessSkip;
var handleProcessRetry = function (processInstance) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) {
                axios_1.default
                    .post("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id, "/retrigger"))
                    .then(function () {
                    resolve();
                })
                    .catch(function (error) {
                    reject(error);
                });
            })];
    });
}); };
exports.handleProcessRetry = handleProcessRetry;
var handleProcessAbort = function (processInstance) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .delete("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id))
            .then(function () {
            resolve();
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.handleProcessAbort = handleProcessAbort;
var handleProcessMultipleAction = function (processInstances, operationType) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) { return __awaiter(void 0, void 0, void 0, function () {
                var operation, successProcessInstances, failedProcessInstances, _loop_1, processInstances_1, processInstances_1_1, processInstance, e_2_1;
                var e_2, _a;
                return __generator(this, function (_b) {
                    switch (_b.label) {
                        case 0:
                            successProcessInstances = [];
                            failedProcessInstances = [];
                            switch (operationType) {
                                case BulkList_1.OperationType.ABORT:
                                    operation = exports.handleProcessAbort;
                                    break;
                                case BulkList_1.OperationType.SKIP:
                                    operation = exports.handleProcessSkip;
                                    break;
                                case BulkList_1.OperationType.RETRY:
                                    operation = exports.handleProcessRetry;
                                    break;
                            }
                            _loop_1 = function (processInstance) {
                                return __generator(this, function (_c) {
                                    switch (_c.label) {
                                        case 0: return [4, operation(processInstance)
                                                .then(function () {
                                                successProcessInstances.push(processInstance);
                                            })
                                                .catch(function (error) {
                                                processInstance.errorMessage = error.message;
                                                failedProcessInstances.push(processInstance);
                                            })];
                                        case 1:
                                            _c.sent();
                                            return [2];
                                    }
                                });
                            };
                            _b.label = 1;
                        case 1:
                            _b.trys.push([1, 6, 7, 8]);
                            processInstances_1 = __values(processInstances), processInstances_1_1 = processInstances_1.next();
                            _b.label = 2;
                        case 2:
                            if (!!processInstances_1_1.done) return [3, 5];
                            processInstance = processInstances_1_1.value;
                            return [5, _loop_1(processInstance)];
                        case 3:
                            _b.sent();
                            _b.label = 4;
                        case 4:
                            processInstances_1_1 = processInstances_1.next();
                            return [3, 2];
                        case 5: return [3, 8];
                        case 6:
                            e_2_1 = _b.sent();
                            e_2 = { error: e_2_1 };
                            return [3, 8];
                        case 7:
                            try {
                                if (processInstances_1_1 && !processInstances_1_1.done && (_a = processInstances_1.return)) _a.call(processInstances_1);
                            }
                            finally { if (e_2) throw e_2.error; }
                            return [7];
                        case 8:
                            resolve({ successProcessInstances: successProcessInstances, failedProcessInstances: failedProcessInstances });
                            return [2];
                    }
                });
            }); })];
    });
}); };
exports.handleProcessMultipleAction = handleProcessMultipleAction;
var getTriggerableNodes = function (processInstance) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) {
                axios_1.default
                    .get("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/nodes"))
                    .then(function (result) {
                    resolve(result.data);
                })
                    .catch(function (error) {
                    reject(error);
                });
            })];
    });
}); };
exports.getTriggerableNodes = getTriggerableNodes;
var handleNodeTrigger = function (processInstance, node) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) {
                axios_1.default
                    .post("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id, "/nodes/").concat(node.nodeDefinitionId))
                    .then(function () {
                    resolve();
                })
                    .catch(function (error) {
                    reject(error);
                });
            })];
    });
}); };
exports.handleNodeTrigger = handleNodeTrigger;
var handleProcessVariableUpdate = function (processInstance, updatedJson) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .put("".concat(processInstance.endpoint, "/").concat(processInstance.id), updatedJson)
            .then(function (response) {
            resolve(response.data);
        })
            .catch(function (error) {
            reject(error.message);
        });
    });
};
exports.handleProcessVariableUpdate = handleProcessVariableUpdate;
var handleNodeInstanceCancel = function (processInstance, node) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve, reject) {
                axios_1.default
                    .delete("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id, "/nodeInstances/").concat(node.id))
                    .then(function () {
                    resolve();
                })
                    .catch(function (error) {
                    reject(error);
                });
            })];
    });
}); };
exports.handleNodeInstanceCancel = handleNodeInstanceCancel;
var handleNodeInstanceRetrigger = function (processInstance, node) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .post("".concat(processInstance.serviceUrl, "/management/processes/").concat(processInstance.processId, "/instances/").concat(processInstance.id, "/nodeInstances/").concat(node.id))
            .then(function () {
            resolve();
        })
            .catch(function (error) {
            reject(JSON.stringify(error.message));
        });
    });
};
exports.handleNodeInstanceRetrigger = handleNodeInstanceRetrigger;
var getForms = function (formFilter) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .get('/forms/list', {
            params: {
                names: formFilter.join(';')
            }
        })
            .then(function (result) {
            resolve(result.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getForms = getForms;
var getFormContent = function (formName) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .get("/forms/".concat(formName))
            .then(function (result) {
            resolve(result.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getFormContent = getFormContent;
var saveFormContent = function (formName, content) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .post("/forms/".concat(formName), content)
            .then(function (result) {
            resolve();
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.saveFormContent = saveFormContent;
var getProcessDefinitionList = function (devUIUrl, openApiPath) {
    return new Promise(function (resolve, reject) {
        swagger_parser_1.default.parse("".concat(devUIUrl, "/").concat(openApiPath))
            .then(function (response) {
            var processDefinitionObjs = [];
            var paths = response.paths;
            var regexPattern = /^\/[^\n/]+\/schema/;
            Object.getOwnPropertyNames(paths)
                .filter(function (path) { return regexPattern.test(path.toString()); })
                .forEach(function (url) {
                var _a;
                var processArray = url.split('/');
                processArray = processArray.filter(function (name) { return name.length !== 0; });
                if (Object.prototype.hasOwnProperty.call(paths["/".concat(processArray[0])], 'post')) {
                    processDefinitionObjs.push((_a = {}, _a[url] = paths[url], _a));
                }
            });
            resolve((0, Utils_1.createProcessDefinitionList)(processDefinitionObjs, devUIUrl));
        })
            .catch(function (err) { return reject(err); });
    });
};
exports.getProcessDefinitionList = getProcessDefinitionList;
var getProcessSchema = function (processDefinitionData) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .get("".concat(processDefinitionData.endpoint, "/schema"))
            .then(function (response) {
            if (response.status === 200) {
                resolve(response.data);
            }
        })
            .catch(function (error) {
            reject(error);
        });
    });
};
exports.getProcessSchema = getProcessSchema;
var startProcessInstance = function (formData, businessKey, processDefinitionData) {
    return new Promise(function (resolve, reject) {
        var requestURL = "".concat(processDefinitionData.endpoint).concat(businessKey.length > 0 ? "?businessKey=".concat(businessKey) : '');
        axios_1.default
            .post(requestURL, formData, {
            headers: {
                'Content-Type': 'application/json'
            }
        })
            .then(function (response) {
            resolve(response.data.id);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.startProcessInstance = startProcessInstance;
var triggerStartCloudEvent = function (event, devUIUrl) {
    if (!event.headers.extensions[dist_1.KOGITO_BUSINESS_KEY]) {
        event.headers.extensions[dist_1.KOGITO_BUSINESS_KEY] = String(Math.floor(Math.random() * 100000));
    }
    return new Promise(function (resolve, reject) {
        doTriggerCloudEvent(event, devUIUrl)
            .then(function (response) {
            return resolve(event.headers.extensions[dist_1.KOGITO_BUSINESS_KEY]);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.triggerStartCloudEvent = triggerStartCloudEvent;
var triggerCloudEvent = function (event, devUIUrl) {
    return doTriggerCloudEvent(event, devUIUrl);
};
exports.triggerCloudEvent = triggerCloudEvent;
var doTriggerCloudEvent = function (event, devUIUrl) {
    var _a;
    var cloudEvent = __assign(__assign({}, event.headers.extensions), { specversion: '1.0', id: (0, uuid_1.default)(), source: (_a = event.headers.source) !== null && _a !== void 0 ? _a : '', type: event.headers.type, data: event.data ? JSON.parse(event.data) : {} });
    if (devUIUrl.endsWith('/')) {
        devUIUrl = devUIUrl.slice(0, devUIUrl.length - 1);
    }
    var url = "".concat(devUIUrl).concat(event.endpoint.startsWith('/') ? '' : '/').concat(event.endpoint);
    return axios_1.default.request({
        url: url,
        method: event.method,
        data: cloudEvent
    });
};
var startWorkflowRest = function (data, endpoint, businessKey) {
    var requestURL = "".concat(endpoint).concat(businessKey.length > 0 ? "?businessKey=".concat(businessKey) : '');
    return new Promise(function (resolve, reject) {
        axios_1.default
            .post(requestURL, { workflowdata: data })
            .then(function (response) {
            resolve(response.data.id);
        })
            .catch(function (err) { return reject(err); });
    });
};
exports.startWorkflowRest = startWorkflowRest;
var getCustomDashboard = function (customDashboardFilter) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .get('/customDashboard/list', {
            params: {
                names: customDashboardFilter.join(';')
            }
        })
            .then(function (result) {
            resolve(result.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getCustomDashboard = getCustomDashboard;
var getCustomDashboardContent = function (name) {
    return new Promise(function (resolve, reject) {
        axios_1.default
            .get("/customDashboard/".concat(name))
            .then(function (result) {
            resolve(result.data);
        })
            .catch(function (error) { return reject(error); });
    });
};
exports.getCustomDashboardContent = getCustomDashboardContent;
var getCustomWorkflowSchema = function (devUIUrl, openApiPath, workflowName) {
    return new Promise(function (resolve, reject) {
        swagger_parser_1.default.parse("".concat(devUIUrl, "/").concat(openApiPath))
            .then(function (response) {
            var schema = {};
            try {
                var schemaFromRequestBody = response.paths['/' + workflowName].post.requestBody.content['application/json'].schema;
                if (schemaFromRequestBody.type) {
                    schema = {
                        type: schemaFromRequestBody.type,
                        properties: schemaFromRequestBody.properties
                    };
                }
                else {
                    schema = response.components.schemas[workflowName + '_input'];
                }
            }
            catch (e) {
                console.log(e);
                schema = response.components.schemas[workflowName + '_input'];
            }
            if (schema) {
                resolve(schema);
            }
            else {
                resolve(null);
            }
        })
            .catch(function (err) { return reject(err); });
    });
};
exports.getCustomWorkflowSchema = getCustomWorkflowSchema;
//# sourceMappingURL=apis.js.map