/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.runtime.tools.quarkus.extension.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleRecorder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoDataIndexServiceAvailableBuildItem;
import org.kie.kogito.quarkus.extensions.spi.deployment.TrustyServiceAvailableBuildItem;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.config.DevConsoleRuntimeConfig;
import org.kie.kogito.runtime.tools.quarkus.extension.runtime.user.UserInfoSupplier;

public class DevConsoleProcessor {
    private static final String STATIC_RESOURCES_PATH = "dev-static/";
    private static final String DATA_INDEX_CAPABILITY = "org.kie.kogito.data-index";

    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectUsersInfo(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplateInfoBuildItemBuildProducer, DevConsoleRuntimeConfig devConsoleRuntimeConfig) {
        devConsoleTemplateInfoBuildItemBuildProducer.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("userInfo", (Object)new UserInfoSupplier(devConsoleRuntimeConfig.userConfigByUser).get()));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void deployStaticResources(DevConsoleRecorder recorder, CurateOutcomeBuildItem curateOutcomeBuildItem, LiveReloadBuildItem liveReloadBuildItem, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routeBuildItemBuildProducer) throws IOException {
        ResolvedDependency devConsoleResourcesArtifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)"org.kie.kogito", (String)"runtime-tools-quarkus-extension-deployment");
        Path devConsoleStaticResourcesDeploymentPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (ResolvedDependency)devConsoleResourcesArtifact, (String)STATIC_RESOURCES_PATH, (boolean)true);
        routeBuildItemBuildProducer.produce((BuildItem)new RouteBuildItem.Builder().route("/q/dev/org.kie.kogito.runtime-tools-quarkus-extension/resources/*").handler(recorder.devConsoleHandler(devConsoleStaticResourcesDeploymentPath.toString(), (ShutdownContext)shutdownContext)).build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void isProcessEnabled(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplateInfoBuildItemBuildProducer, Optional<KogitoDataIndexServiceAvailableBuildItem> dataIndexServiceAvailableBuildItem, Capabilities capabilities) {
        devConsoleTemplateInfoBuildItemBuildProducer.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("isProcessEnabled", (Object)(dataIndexServiceAvailableBuildItem.isPresent() || capabilities.isPresent(DATA_INDEX_CAPABILITY) ? 1 : 0)));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void isTracingEnabled(BuildProducer<DevConsoleTemplateInfoBuildItem> devConsoleTemplateInfoBuildItemBuildProducer, Optional<TrustyServiceAvailableBuildItem> trustyServiceAvailableBuildItem) {
        devConsoleTemplateInfoBuildItemBuildProducer.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("isTracingEnabled", (Object)trustyServiceAvailableBuildItem.isPresent()));
    }
}

