/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import io.quarkus.arc.properties.IfBuildProperty;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.storage.MongoModelService;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;

@ApplicationScoped
@IfBuildProperty(name="kogito.apps.persistence.type", stringValue="mongodb")
public class MongoStorageManager
implements StorageService {
    @Inject
    MongoClientManager mongoClientManager;
    @Inject
    MongoModelService mongoModelService;

    public Storage<String, String> getCache(String name) {
        return new MongoStorage(this.mongoClientManager.getCollection(name, this.mongoModelService.getEntityMapper(name).getEntityClass()), String.class.getName(), this.mongoModelService.getEntityMapper(name));
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new MongoStorage(this.mongoClientManager.getCollection(name, this.mongoModelService.getEntityMapper(name).getEntityClass()), type.getName(), this.mongoModelService.getEntityMapper(name));
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        return new MongoStorage(this.mongoClientManager.getCollection(name, this.mongoModelService.getEntityMapper(name).getEntityClass()), rootType, this.mongoModelService.getEntityMapper(name));
    }
}

