/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.model.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.model.KiePMMLExtension;
import org.kie.pmml.commons.model.ProcessingDTO;
import org.kie.pmml.commons.model.abstracts.AbstractKiePMMLComponent;
import org.kie.pmml.commons.model.expressions.ExpressionsUtils;
import org.kie.pmml.commons.model.expressions.KiePMMLDiscretizeBin;
import org.kie.pmml.commons.model.expressions.KiePMMLExpression;

public class KiePMMLDiscretize
extends AbstractKiePMMLComponent
implements KiePMMLExpression {
    private static final long serialVersionUID = -7935602676734880795L;
    private final List<KiePMMLDiscretizeBin> discretizeBins;
    private final String mapMissingTo;
    private final String defaultValue;
    private final DATA_TYPE dataType;

    public KiePMMLDiscretize(String name, List<KiePMMLExtension> extensions, List<KiePMMLDiscretizeBin> discretizeBins, String mapMissingTo, String defaultValue, DATA_TYPE dataType) {
        super(name, extensions);
        this.discretizeBins = discretizeBins;
        this.mapMissingTo = mapMissingTo;
        this.defaultValue = defaultValue;
        this.dataType = dataType;
    }

    public List<KiePMMLDiscretizeBin> getDiscretizeBins() {
        return Collections.unmodifiableList(this.discretizeBins);
    }

    public String getMapMissingTo() {
        return this.mapMissingTo;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public DATA_TYPE getDataType() {
        return this.dataType;
    }

    @Override
    public Object evaluate(ProcessingDTO processingDTO) {
        Number input = ExpressionsUtils.getFromPossibleSources(this.name, processingDTO).orElse(null);
        if (input == null) {
            return this.mapMissingTo;
        }
        return this.getFromDiscretizeBins(input).orElse(this.defaultValue);
    }

    Optional<String> getFromDiscretizeBins(Number toEvaluate) {
        return this.discretizeBins.stream().map(kiePMMLNameValue -> kiePMMLNameValue.evaluate(toEvaluate)).filter(Optional::isPresent).findFirst().map(Optional::get);
    }
}

