/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.util;

import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.builder.InternalKieBuilder;

public class KieHelper {
    public static KieContainer getKieContainer(ReleaseId releaseId, Resource ... resources) {
        KieServices ks = KieServices.Factory.get();
        KieHelper.createAndDeployJar(ks, releaseId, resources);
        return ks.newKieContainer(releaseId);
    }

    public static KieModule createAndDeployJar(KieServices ks, ReleaseId releaseId, Resource ... resources) {
        byte[] jar = KieHelper.createJar(ks, releaseId, resources);
        KieModule km = KieHelper.deployJarIntoRepository(ks, jar);
        return km;
    }

    public static byte[] createJar(KieServices ks, ReleaseId releaseId, Resource ... resources) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML(releaseId);
        for (int i = 0; i < resources.length; ++i) {
            if (resources[i] == null) continue;
            kfs.write(resources[i]);
        }
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        ((InternalKieBuilder)kieBuilder).buildAll(o -> true);
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException(results.getMessages(new Message.Level[]{Message.Level.ERROR}).toString());
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId);
        byte[] jar = kieModule.getBytes();
        return jar;
    }

    private static KieModule deployJarIntoRepository(KieServices ks, byte[] jar) {
        Resource jarRes = ks.getResources().newByteArrayResource(jar);
        KieModule km = ks.getRepository().addKieModule(jarRes, new Resource[0]);
        return km;
    }
}

