/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.osgi;

import java.util.Hashtable;
import org.kie.dmn.core.assembler.DMNAssemblerService;
import org.kie.dmn.core.runtime.DMNRuntimeService;
import org.kie.dmn.core.weaver.DMNWeaverService;
import org.kie.internal.assembler.KieAssemblerService;
import org.kie.internal.runtime.KieRuntimeService;
import org.kie.internal.weaver.KieWeaverService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    protected static final transient Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceRegistration assemblerService;
    private ServiceRegistration weaverService;
    private ServiceRegistration runtimeService;

    public void start(BundleContext bc) throws Exception {
        logger.info("registering Kie DMN services");
        this.assemblerService = bc.registerService(new String[]{DMNAssemblerService.class.getName(), KieAssemblerService.class.getName()}, (Object)new DMNAssemblerService(), new Hashtable());
        this.weaverService = bc.registerService(new String[]{DMNWeaverService.class.getName(), KieWeaverService.class.getName()}, (Object)new DMNWeaverService(), new Hashtable());
        this.runtimeService = bc.registerService(new String[]{DMNRuntimeService.class.getName(), KieRuntimeService.class.getName()}, (Object)new DMNRuntimeService(), new Hashtable());
        logger.info("Kie DMN services registered");
    }

    public void stop(BundleContext bc) throws Exception {
        this.assemblerService.unregister();
        this.weaverService.unregister();
        this.runtimeService.unregister();
    }
}

