/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieRuntime;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNPackage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNDecisionResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeImpl
implements DMNRuntime {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeImpl.class);
    private KieRuntime runtime;
    private DMNRuntimeEventManagerImpl eventManager;

    public DMNRuntimeImpl(KieRuntime runtime) {
        this.runtime = runtime;
        this.eventManager = new DMNRuntimeEventManagerImpl();
    }

    public List<DMNModel> getModels() {
        ArrayList<DMNModel> models = new ArrayList<DMNModel>();
        this.runtime.getKieBase().getKiePackages().forEach(kpkg -> {
            DMNPackage dmnPkg = (DMNPackage)((InternalKnowledgePackage)kpkg).getResourceTypePackages().get(ResourceType.DMN);
            if (dmnPkg != null) {
                dmnPkg.getAllModels().values().forEach(model -> models.add((DMNModel)model));
            }
        });
        return models;
    }

    public DMNModel getModel(String namespace, String modelName) {
        InternalKnowledgePackage kpkg = (InternalKnowledgePackage)this.runtime.getKieBase().getKiePackage(namespace);
        if (kpkg == null) {
            return null;
        }
        Map map = kpkg.getResourceTypePackages();
        DMNPackage dmnpkg = (DMNPackage)map.get(ResourceType.DMN);
        return dmnpkg != null ? dmnpkg.getModel(modelName) : null;
    }

    public DMNResult evaluateAll(DMNModel model, DMNContext context) {
        DMNResultImpl result = this.createResult(model, context);
        for (DecisionNode decision : model.getDecisions()) {
            this.evaluateDecision(context, result, decision);
        }
        return result;
    }

    public DMNResult evaluateDecisionByName(DMNModel model, String decisionName, DMNContext context) {
        DMNResultImpl result = this.createResult(model, context);
        DecisionNode decision = model.getDecisionByName(decisionName);
        if (decision != null) {
            this.evaluateDecision(context, result, decision);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_NAME, decisionName);
        }
        return result;
    }

    public DMNResult evaluateDecisionById(DMNModel model, String decisionId, DMNContext context) {
        DMNResultImpl result = this.createResult(model, context);
        DecisionNode decision = model.getDecisionById(decisionId);
        if (decision != null) {
            this.evaluateDecision(context, result, decision);
        } else {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, null, result, null, null, Msg.DECISION_NOT_FOUND_FOR_ID, decisionId);
        }
        return result;
    }

    public void addListener(DMNRuntimeEventListener listener) {
        this.eventManager.addListener(listener);
    }

    public void removeListener(DMNRuntimeEventListener listener) {
        this.eventManager.removeListener(listener);
    }

    public Set<DMNRuntimeEventListener> getListeners() {
        return this.eventManager.getListeners();
    }

    private DMNResultImpl createResult(DMNModel model, DMNContext context) {
        DMNResultImpl result = new DMNResultImpl();
        result.setContext(context.clone());
        for (DecisionNode decision : model.getDecisions()) {
            result.setDecisionResult(decision.getId(), new DMNDecisionResultImpl(decision.getId(), decision.getName()));
        }
        return result;
    }

    private void evaluateAllBKM(DMNModel model, DMNContext context, DMNResultImpl result) {
        for (BusinessKnowledgeModelNode bkm : model.getBusinessKnowledgeModels()) {
            this.evaluateBKM(context, result, bkm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBKM(DMNContext context, DMNResultImpl result, BusinessKnowledgeModelNode b) {
        BusinessKnowledgeModelNodeImpl bkm = (BusinessKnowledgeModelNodeImpl)b;
        if (result.getContext().isDefined(bkm.getName())) {
            return;
        }
        if (bkm.getEvaluator() == null) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_BKM, this.getIdentifier(bkm));
            return;
        }
        try {
            this.eventManager.fireBeforeEvaluateBKM(bkm, result);
            for (DMNNode dep : bkm.getDependencies().values()) {
                if (!this.checkDependencyValueIsValid((DMNNode)b, dep, result.getContext())) {
                    DMNMessage message = MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, this.getIdentifier(bkm), this.getIdentifier(dep), result.getContext().get(dep.getName()));
                    return;
                }
                if (result.getContext().isDefined(dep.getName())) continue;
                if (dep instanceof BusinessKnowledgeModelNode) {
                    this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, this.getIdentifier(dep), this.getIdentifier(bkm));
                return;
            }
            EvaluatorResult er = bkm.getEvaluator().evaluate(this.eventManager, result);
            if (er.getResultType() == EvaluatorResult.ResultType.SUCCESS) {
                FEELFunction resultFn = (FEELFunction)er.getResult();
                result.getContext().set(bkm.getBusinessKnowledModel().getVariable().getName(), (Object)resultFn);
            }
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)bkm.getSource(), result, t, null, Msg.ERROR_EVAL_BKM_NODE, this.getIdentifier(bkm), t.getMessage());
        }
        finally {
            this.eventManager.fireAfterEvaluateBKM(bkm, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean evaluateDecision(DMNContext context, DMNResultImpl result, DecisionNode d) {
        block17: {
            block16: {
                block15: {
                    decision = (DecisionNodeImpl)d;
                    if (result.getContext().isDefined(decision.getName())) {
                        return true;
                    }
                    dr = result.getDecisionResultById(decision.getId());
                    if (dr.getEvaluationStatus() == DMNDecisionResult.DecisionEvaluationStatus.FAILED || dr.getEvaluationStatus() == DMNDecisionResult.DecisionEvaluationStatus.SKIPPED) {
                        return false;
                    }
                    this.eventManager.fireBeforeEvaluateDecision(decision, result);
                    missingInput = false;
                    dr = (DMNDecisionResultImpl)result.getDecisionResultById(decision.getId());
                    for (DMNNode dep : decision.getDependencies().values()) {
                        if (!this.checkDependencyValueIsValid((DMNNode)d, dep, result.getContext())) {
                            missingInput = true;
                            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)dep).getSource(), result, null, null, Msg.ERROR_EVAL_NODE_DEP_WRONG_TYPE, this.getIdentifier(decision), this.getIdentifier(dep), result.getContext().get(dep.getName()));
                            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                        }
                        if (result.getContext().isDefined(dep.getName())) continue;
                        if (dep instanceof DecisionNode) {
                            if (this.evaluateDecision(context, result, (DecisionNode)dep)) continue;
                            missingInput = true;
                            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.UNABLE_TO_EVALUATE_DECISION_REQ_DEP, this.getIdentifier(decision), this.getIdentifier(dep));
                            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                            continue;
                        }
                        if (dep instanceof BusinessKnowledgeModelNode) {
                            this.evaluateBKM(context, result, (BusinessKnowledgeModelNode)dep);
                            continue;
                        }
                        missingInput = true;
                        message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.REQ_DEP_NOT_FOUND_FOR_NODE, this.getIdentifier(dep), this.getIdentifier(decision));
                        this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                    }
                    if (!missingInput) break block15;
                    var7_9 = false;
                    this.eventManager.fireAfterEvaluateDecision(decision, result);
                    return var7_9;
                }
                if (decision.getEvaluator() != null) break block16;
                message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.MISSING_EXPRESSION_FOR_DECISION, this.getIdentifier(decision));
                this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.SKIPPED);
                dep = false;
                this.eventManager.fireAfterEvaluateDecision(decision, result);
                return dep;
            }
            er = decision.getEvaluator().evaluate(this.eventManager, result);
            if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) ** GOTO lbl65
            value = er.getResult();
            if (!decision.getResultType().isCollection() && value instanceof Collection && ((Collection)value).size() == 1) {
                value = ((Collection)value).toArray()[0];
            }
            if (d.getResultType().isInstanceOf(value)) break block17;
            message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, null, null, Msg.ERROR_EVAL_NODE_RESULT_WRONG_TYPE, this.getIdentifier(decision), decision.getResultType(), value);
            this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
            var10_15 = false;
            this.eventManager.fireAfterEvaluateDecision(decision, result);
            return var10_15;
        }
        try {
            block18: {
                try {
                    result.getContext().set(decision.getDecision().getVariable().getName(), value);
                    dr.setResult(value);
                    dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
                    break block18;
lbl65:
                    // 1 sources

                    dr.setEvaluationStatus(DMNDecisionResult.DecisionEvaluationStatus.FAILED);
                }
                catch (Throwable t) {
                    message = MsgUtil.reportMessage(DMNRuntimeImpl.logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)decision.getSource(), result, t, null, Msg.ERROR_EVAL_DECISION_NODE, this.getIdentifier(decision), t.getMessage());
                    this.reportFailure(dr, message, DMNDecisionResult.DecisionEvaluationStatus.FAILED);
                }
            }
            var7_11 = true;
            return var7_11;
        }
        finally {
            this.eventManager.fireAfterEvaluateDecision(decision, result);
        }
    }

    private boolean checkDependencyValueIsValid(DMNNode currentNode, DMNNode dep, DMNContext context) {
        InputDataNode inputDataNode;
        BaseDMNTypeImpl dmnType;
        if (dep instanceof InputDataNode && (dmnType = (BaseDMNTypeImpl)(inputDataNode = (InputDataNode)dep).getType()).getAllowedValues() != null && !dmnType.getAllowedValues().isEmpty()) {
            List<UnaryTest> allowedValues = dmnType.getAllowedValues();
            return DMNFEELHelper.valueMatchesInUnaryTests(allowedValues, context.get(dep.getName()), context);
        }
        return true;
    }

    private String getIdentifier(DMNNode node) {
        return node.getName() != null ? node.getName() : node.getId();
    }

    private void reportFailure(DMNDecisionResultImpl dr, DMNMessage message, DMNDecisionResult.DecisionEvaluationStatus status) {
        dr.getMessages().add(message);
        dr.setEvaluationStatus(status);
    }

    public DMNContext newContext() {
        return DMNFactory.newContext();
    }
}

