/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.impl.AfterEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.AfterEvaluateDecisionTableEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateBKMEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionEventImpl;
import org.kie.dmn.core.impl.BeforeEvaluateDecisionTableEventImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNRuntimeEventManagerImpl
implements DMNRuntimeEventManager {
    private static final Logger logger = LoggerFactory.getLogger(DMNRuntimeEventManagerImpl.class);
    private Set<DMNRuntimeEventListener> listeners = new HashSet<DMNRuntimeEventListener>();

    public void addListener(DMNRuntimeEventListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(DMNRuntimeEventListener listener) {
        this.listeners.remove(listener);
    }

    public Set<DMNRuntimeEventListener> getListeners() {
        return this.listeners;
    }

    public void fireBeforeEvaluateDecision(DecisionNode decision, DMNResult result) {
        BeforeEvaluateDecisionEventImpl event = new BeforeEvaluateDecisionEventImpl(decision, result);
        this.notifyListeners(l -> l.beforeEvaluateDecision(event));
    }

    public void fireAfterEvaluateDecision(DecisionNode decision, DMNResult result) {
        AfterEvaluateDecisionEventImpl event = new AfterEvaluateDecisionEventImpl(decision, result);
        this.notifyListeners(l -> l.afterEvaluateDecision(event));
    }

    public void fireBeforeEvaluateBKM(BusinessKnowledgeModelNode bkm, DMNResult result) {
        BeforeEvaluateBKMEventImpl event = new BeforeEvaluateBKMEventImpl(bkm, result);
        this.notifyListeners(l -> l.beforeEvaluateBKM(event));
    }

    public void fireAfterEvaluateBKM(BusinessKnowledgeModelNode bkm, DMNResult result) {
        AfterEvaluateBKMEventImpl event = new AfterEvaluateBKMEventImpl(bkm, result);
        this.notifyListeners(l -> l.afterEvaluateBKM(event));
    }

    public void fireBeforeEvaluateDecisionTable(String nodeName, String dtName, DMNResult result) {
        BeforeEvaluateDecisionTableEventImpl event = new BeforeEvaluateDecisionTableEventImpl(nodeName, dtName, result);
        this.notifyListeners(l -> l.beforeEvaluateDecisionTable(event));
    }

    public void fireAfterEvaluateDecisionTable(String nodeName, String dtName, DMNResult result, List<Integer> matches, List<Integer> fired) {
        AfterEvaluateDecisionTableEventImpl event = new AfterEvaluateDecisionTableEventImpl(nodeName, dtName, result, matches, fired);
        this.notifyListeners(l -> l.afterEvaluateDecisionTable(event));
    }

    private void notifyListeners(Consumer<DMNRuntimeEventListener> consumer) {
        for (DMNRuntimeEventListener listener : this.listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable t) {
                logger.error("Error notifying listener '" + listener + "'", t);
            }
        }
    }
}

