/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Comparator;
import javax.xml.namespace.QName;
import org.kie.dmn.model.v1_1.ItemDefinition;

public class ItemDefinitionDependenciesComparator
implements Comparator<ItemDefinition> {
    private final String modelNamespace;

    public ItemDefinitionDependenciesComparator(String modelNamespace) {
        this.modelNamespace = modelNamespace;
    }

    @Override
    public int compare(ItemDefinition o1, ItemDefinition o2) {
        QName qname1 = new QName(this.modelNamespace, o1.getName());
        QName qname2 = new QName(this.modelNamespace, o2.getName());
        if (this.recurseFind(o1, qname2)) {
            return 1;
        }
        if (this.recurseFind(o2, qname1)) {
            return -1;
        }
        return 0;
    }

    private boolean recurseFind(ItemDefinition o1, QName qname2) {
        if (o1.getTypeRef() != null && o1.getTypeRef().equals(qname2)) {
            return true;
        }
        for (ItemDefinition ic : o1.getItemComponent()) {
            if (!this.recurseFind(ic, qname2)) continue;
            return true;
        }
        return false;
    }
}

