/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.antlr.v4.runtime.CommonToken;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.CompiledExpression;
import org.kie.dmn.feel.lang.CompilerContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.feel.runtime.events.SyntaxErrorEvent;
import org.kie.dmn.feel.runtime.events.UnknownVariableErrorEvent;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNFEELHelper
implements FEELEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DMNFEELHelper.class);
    private final FEEL feel;
    private final Queue<FEELEvent> feelEvents = new LinkedList<FEELEvent>();

    public DMNFEELHelper() {
        this.feel = this.createFEELInstance();
    }

    private FEEL createFEELInstance() {
        FEEL feel = FEEL.newInstance();
        feel.addListener((FEELEventListener)this);
        return feel;
    }

    public void onEvent(FEELEvent event) {
        this.feelEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean valueMatchesInUnaryTests(List<UnaryTest> unaryTests, Object value, DMNContext dmnContext) {
        EvaluationContextImpl ctx = new EvaluationContextImpl(null);
        try {
            ctx.enterFrame();
            for (Map.Entry entry : dmnContext.getAll().entrySet()) {
                ctx.setValue((String)entry.getKey(), entry.getValue());
            }
            for (UnaryTest t : unaryTests) {
                block9: {
                    Boolean applyT;
                    block8: {
                        applyT = (Boolean)t.apply((Object)ctx, value);
                        if (applyT != null) break block8;
                        boolean bl = false;
                        {
                            catch (Throwable e) {
                                logger.warn("A non-critical error happened while evaluating a unary test. Execution will continue.", e);
                                continue;
                            }
                        }
                        ctx.exitFrame();
                        return bl;
                    }
                    if (!applyT.booleanValue()) break block9;
                    boolean bl = true;
                    ctx.exitFrame();
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            ctx.exitFrame();
            throw throwable;
        }
        ctx.exitFrame();
        return false;
    }

    public CompiledExpression compileFeelExpression(DMNCompilerContext ctx, String expression, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        CompilerContext feelctx = this.feel.newCompilerContext();
        for (Map.Entry<String, DMNType> entry : ctx.getVariables().entrySet()) {
            feelctx.addInputVariableType(entry.getKey(), ((BaseDMNTypeImpl)entry.getValue()).getFeelType());
        }
        CompiledExpression ce = this.feel.compile(expression, feelctx);
        this.processEvents(model, element, errorMsg, msgParams);
        return ce;
    }

    public List<UnaryTest> evaluateUnaryTests(DMNCompilerContext ctx, String unaryTests, DMNModelImpl model, DMNElement element, Msg.Message errorMsg, Object ... msgParams) {
        List result = Collections.emptyList();
        try {
            HashMap<String, BuiltInType> variableTypes = new HashMap<String, BuiltInType>();
            for (Map.Entry<String, DMNType> entry : ctx.getVariables().entrySet()) {
                variableTypes.put(entry.getKey(), BuiltInType.UNKNOWN);
            }
            result = this.feel.evaluateUnaryTests(unaryTests, variableTypes);
        }
        catch (Throwable t) {
            logger.error("Error evaluating unary tests. Error will be reported in the model.", t);
        }
        this.processEvents(model, element, errorMsg, msgParams);
        return result;
    }

    public void processEvents(DMNModelImpl model, DMNElement element, Msg.Message msg, Object ... msgParams) {
        while (!this.feelEvents.isEmpty()) {
            FEELEvent event = this.feelEvents.remove();
            if (this.isDuplicateEvent(model, msg, element) || !(event instanceof SyntaxErrorEvent) && event.getSeverity() != FEELEvent.Severity.ERROR) continue;
            if (msg instanceof Msg.Message2) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message2)msg, msgParams[0], msgParams[1]);
                continue;
            }
            if (msg instanceof Msg.Message3) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message3)msg, msgParams[0], msgParams[1], msgParams[2]);
                continue;
            }
            if (!(msg instanceof Msg.Message4)) continue;
            String message = null;
            message = event.getOffendingSymbol() == null ? "" : (event instanceof UnknownVariableErrorEvent ? event.getMessage() : (event.getOffendingSymbol() instanceof CommonToken ? "syntax error near '" + ((CommonToken)event.getOffendingSymbol()).getText() + "'" : "syntax error near '" + event.getOffendingSymbol() + "'"));
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, event, (Msg.Message4)msg, msgParams[0], msgParams[1], msgParams[2], message);
        }
    }

    private boolean isDuplicateEvent(DMNModelImpl model, Msg.Message error, DMNElement element) {
        return model.getMessages().stream().anyMatch(msg -> msg.getMessageType() == error.getType() && (msg.getSourceId() == element.getId() || msg.getSourceId() != null && element.getId() != null && msg.getSourceId().equals(element.getId())));
    }
}

