/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNCompiler;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.BusinessKnowledgeModelNode;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.backend.marshalling.v1_1.DMNMarshallerFactory;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.ast.BusinessKnowledgeModelNodeImpl;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.DecisionNodeImpl;
import org.kie.dmn.core.ast.InputDataNodeImpl;
import org.kie.dmn.core.ast.ItemDefNodeImpl;
import org.kie.dmn.core.compiler.DMNCompilerContext;
import org.kie.dmn.core.compiler.DMNCompilerHelper;
import org.kie.dmn.core.compiler.DMNEvaluatorCompiler;
import org.kie.dmn.core.compiler.DMNFEELHelper;
import org.kie.dmn.core.compiler.DMNTypeRegistry;
import org.kie.dmn.core.compiler.ItemDefinitionDependenciesComparator;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.dmn.feel.runtime.UnaryTest;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNElementReference;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.DRGElement;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.DecisionTable;
import org.kie.dmn.model.v1_1.Definitions;
import org.kie.dmn.model.v1_1.Expression;
import org.kie.dmn.model.v1_1.FunctionDefinition;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.InputData;
import org.kie.dmn.model.v1_1.ItemDefinition;
import org.kie.dmn.model.v1_1.KnowledgeRequirement;
import org.kie.dmn.model.v1_1.KnowledgeSource;
import org.kie.dmn.model.v1_1.NamedElement;
import org.kie.dmn.model.v1_1.OutputClause;
import org.kie.dmn.model.v1_1.UnaryTests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNCompilerImpl
implements DMNCompiler {
    private static final Logger logger = LoggerFactory.getLogger(DMNCompilerImpl.class);
    private final DMNEvaluatorCompiler evaluatorCompiler;
    private final DMNFEELHelper feel = new DMNFEELHelper();
    private DMNCompilerConfiguration dmnCompilerConfig;

    public DMNCompilerImpl() {
        this.evaluatorCompiler = new DMNEvaluatorCompiler(this, this.feel);
    }

    public DMNCompilerImpl(DMNCompilerConfiguration dmnCompilerConfig) {
        this.evaluatorCompiler = new DMNEvaluatorCompiler(this, this.feel);
        this.dmnCompilerConfig = dmnCompilerConfig;
    }

    public DMNModel compile(Resource resource) {
        try {
            return this.compile(resource.getReader());
        }
        catch (IOException e) {
            logger.error("Error retrieving reader for resource: " + resource.getSourcePath(), (Throwable)e);
            return null;
        }
    }

    public DMNModel compile(Reader source) {
        try {
            Definitions dmndefs = null;
            dmndefs = this.dmnCompilerConfig != null && !this.dmnCompilerConfig.getRegisteredExtensions().isEmpty() ? DMNMarshallerFactory.newMarshallerWithExtensions((List)this.getDmnCompilerConfig().getRegisteredExtensions()).unmarshal(source) : DMNMarshallerFactory.newDefaultMarshaller().unmarshal(source);
            DMNModel model = this.compile(dmndefs);
            return model;
        }
        catch (Exception e) {
            logger.error("Error compiling model from source.", (Throwable)e);
            return null;
        }
    }

    public DMNModel compile(Definitions dmndefs) {
        DMNModelImpl model = null;
        if (dmndefs != null) {
            model = new DMNModelImpl(dmndefs);
            DMNCompilerContext ctx = new DMNCompilerContext();
            this.processItemDefinitions(ctx, this.feel, model, dmndefs);
            this.processDrgElements(ctx, this.feel, model, dmndefs);
            return model;
        }
        return model;
    }

    private void processItemDefinitions(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl model, Definitions dmndefs) {
        dmndefs.getItemDefinition().stream().forEach(x -> this.processItemDefQNameURIs((ItemDefinition)x));
        ArrayList<ItemDefinition> ordered = new ArrayList<ItemDefinition>(dmndefs.getItemDefinition());
        ordered.sort(new ItemDefinitionDependenciesComparator(model.getNamespace()));
        for (ItemDefinition id : ordered) {
            ItemDefNodeImpl idn = new ItemDefNodeImpl(id);
            DMNType type = this.buildTypeDef(ctx, feel, model, idn, id, true);
            idn.setType(type);
            model.addItemDefinition(idn);
        }
    }

    private void processItemDefQNameURIs(ItemDefinition id) {
        QName typeRef = id.getTypeRef();
        if (typeRef != null && "".equals(typeRef.getNamespaceURI())) {
            String actualNS = id.getNamespaceURI(typeRef.getPrefix());
            id.setTypeRef(new QName(actualNS, typeRef.getLocalPart(), typeRef.getPrefix()));
        }
        for (ItemDefinition ic : id.getItemComponent()) {
            this.processItemDefQNameURIs(ic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDrgElements(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl model, Definitions dmndefs) {
        for (DRGElement e : dmndefs.getDrgElement()) {
            DMNType type;
            if (e instanceof InputData) {
                InputData input = (InputData)e;
                InputDataNodeImpl idn = new InputDataNodeImpl(input);
                if (input.getVariable() != null) {
                    DMNCompilerHelper.checkVariableName(model, (NamedElement)input, input.getName());
                    type = this.resolveTypeRef(model, idn, (NamedElement)e, (DMNModelInstrumentedBase)input.getVariable(), input.getVariable().getTypeRef());
                    idn.setType(type);
                } else {
                    idn.setType(DMNTypeRegistry.UNKNOWN);
                    this.reportMissingVariable(model, e, (DMNModelInstrumentedBase)input, Msg.MISSING_VARIABLE_FOR_INPUT);
                }
                model.addInput(idn);
                continue;
            }
            if (e instanceof Decision) {
                Decision decision = (Decision)e;
                DecisionNodeImpl dn = new DecisionNodeImpl(decision);
                type = null;
                if (decision.getVariable() == null) {
                    this.reportMissingVariable(model, e, (DMNModelInstrumentedBase)decision, Msg.MISSING_VARIABLE_FOR_DECISION);
                    continue;
                }
                DMNCompilerHelper.checkVariableName(model, (NamedElement)decision, decision.getName());
                type = decision.getVariable() != null && decision.getVariable().getTypeRef() != null ? this.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision.getVariable(), decision.getVariable().getTypeRef()) : this.resolveTypeRef(model, dn, (NamedElement)decision, (DMNModelInstrumentedBase)decision, null);
                dn.setResultType(type);
                model.addDecision(dn);
                continue;
            }
            if (e instanceof BusinessKnowledgeModel) {
                BusinessKnowledgeModel bkm = (BusinessKnowledgeModel)e;
                BusinessKnowledgeModelNodeImpl bkmn = new BusinessKnowledgeModelNodeImpl(bkm);
                type = null;
                if (bkm.getVariable() == null) {
                    this.reportMissingVariable(model, e, (DMNModelInstrumentedBase)bkm, Msg.MISSING_VARIABLE_FOR_BKM);
                    continue;
                }
                DMNCompilerHelper.checkVariableName(model, (NamedElement)bkm, bkm.getName());
                type = bkm.getVariable() != null && bkm.getVariable().getTypeRef() != null ? this.resolveTypeRef(model, bkmn, (NamedElement)bkm, (DMNModelInstrumentedBase)bkm.getVariable(), bkm.getVariable().getTypeRef()) : this.resolveTypeRef(model, bkmn, (NamedElement)bkm, (DMNModelInstrumentedBase)bkm, null);
                bkmn.setResultType(type);
                model.addBusinessKnowledgeModel(bkmn);
                continue;
            }
            if (e instanceof KnowledgeSource) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)e, model, null, null, Msg.UNSUPPORTED_ELEMENT, e.getClass().getSimpleName(), e.getId());
        }
        for (BusinessKnowledgeModelNode bkm : model.getBusinessKnowledgeModels()) {
            BusinessKnowledgeModelNodeImpl bkmi = (BusinessKnowledgeModelNodeImpl)bkm;
            this.linkRequirements(model, bkmi);
            ctx.enterFrame();
            try {
                for (DMNNode dep : bkmi.getDependencies().values()) {
                    if (!(dep instanceof BusinessKnowledgeModelNode)) continue;
                    ctx.setVariable(dep.getName(), ((BusinessKnowledgeModelNode)dep).getResultType());
                }
                ctx.setVariable(bkm.getName(), bkm.getResultType());
                FunctionDefinition funcDef = bkm.getBusinessKnowledModel().getEncapsulatedLogic();
                DMNExpressionEvaluator exprEvaluator = this.evaluatorCompiler.compileExpression(ctx, model, bkmi, bkm.getName(), (Expression)funcDef);
                bkmi.setEvaluator(exprEvaluator);
            }
            finally {
                ctx.exitFrame();
            }
        }
        for (DecisionNode d : model.getDecisions()) {
            DecisionNodeImpl di = (DecisionNodeImpl)d;
            this.linkRequirements(model, di);
            ctx.enterFrame();
            try {
                for (DMNNode dep : di.getDependencies().values()) {
                    if (dep instanceof DecisionNode) {
                        ctx.setVariable(dep.getName(), ((DecisionNode)dep).getResultType());
                        continue;
                    }
                    if (dep instanceof InputDataNode) {
                        ctx.setVariable(dep.getName(), ((InputDataNode)dep).getType());
                        continue;
                    }
                    if (!(dep instanceof BusinessKnowledgeModelNode)) continue;
                    ctx.setVariable(dep.getName(), ((BusinessKnowledgeModelNode)dep).getResultType());
                }
                DMNExpressionEvaluator evaluator = this.evaluatorCompiler.compileExpression(ctx, model, di, d.getName(), d.getDecision().getExpression());
                di.setEvaluator(evaluator);
            }
            finally {
                ctx.exitFrame();
            }
        }
    }

    private void reportMissingVariable(DMNModelImpl model, DRGElement node, DMNModelInstrumentedBase source, Msg.Message1 message) {
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, source, model, null, null, message, node.getIdentifierString());
    }

    private void linkRequirements(DMNModelImpl model, DMNBaseNode node) {
        String id;
        for (InformationRequirement ir : node.getInformationRequirement()) {
            if (ir.getRequiredInput() != null) {
                id = this.getId(ir.getRequiredInput());
                InputDataNode input = model.getInputById(id);
                if (input != null) {
                    node.addDependency(input.getName(), (DMNNode)input);
                    continue;
                }
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredInput(), model, null, null, Msg.REQ_INPUT_NOT_FOUND_FOR_NODE, id, node.getName());
                continue;
            }
            if (ir.getRequiredDecision() == null) continue;
            id = this.getId(ir.getRequiredDecision());
            DecisionNode dn = model.getDecisionById(id);
            if (dn != null) {
                node.addDependency(dn.getName(), (DMNNode)dn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)ir.getRequiredDecision(), model, null, null, Msg.REQ_DECISION_NOT_FOUND_FOR_NODE, id, node.getName());
        }
        for (KnowledgeRequirement kr : node.getKnowledgeRequirement()) {
            if (kr.getRequiredKnowledge() == null) continue;
            id = this.getId(kr.getRequiredKnowledge());
            BusinessKnowledgeModelNode bkmn = model.getBusinessKnowledgeModelById(id);
            if (bkmn != null) {
                node.addDependency(bkmn.getName(), (DMNNode)bkmn);
                continue;
            }
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)kr.getRequiredKnowledge(), model, null, null, Msg.REQ_BKM_NOT_FOUND_FOR_NODE, id, node.getName());
        }
    }

    private String getId(DMNElementReference er) {
        String href = er.getHref();
        return href.contains("#") ? href.substring(href.indexOf(35) + 1) : href;
    }

    private DMNType buildTypeDef(DMNCompilerContext ctx, DMNFEELHelper feel, DMNModelImpl dmnModel, DMNNode node, ItemDefinition itemDef, boolean topLevel) {
        BaseDMNTypeImpl type = null;
        if (itemDef.getTypeRef() != null) {
            type = (BaseDMNTypeImpl)this.resolveTypeRef(dmnModel, node, (NamedElement)itemDef, (DMNModelInstrumentedBase)itemDef, itemDef.getTypeRef());
            if (type != null) {
                DMNType registered;
                UnaryTests allowedValuesStr = itemDef.getAllowedValues();
                if (topLevel || allowedValuesStr != null || itemDef.isIsCollection() != type.isCollection()) {
                    type = type.clone();
                    type.setNamespace(dmnModel.getNamespace());
                    type.setName(itemDef.getName());
                    if (allowedValuesStr != null) {
                        List<UnaryTest> av = feel.evaluateUnaryTests(ctx, allowedValuesStr.getText(), dmnModel, (DMNElement)itemDef, Msg.ERR_COMPILING_ALLOWED_VALUES_LIST_ON_ITEM_DEF, allowedValuesStr.getText(), node.getName());
                        type.setAllowedValues(av);
                    }
                    if (itemDef.isIsCollection()) {
                        type.setCollection(itemDef.isIsCollection());
                    }
                }
                if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
                }
            }
        } else {
            DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)itemDef, itemDef.getName());
            CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), itemDef.getName(), itemDef.getId(), itemDef.isIsCollection());
            DMNType registered = itemDef.getItemComponent().iterator();
            while (registered.hasNext()) {
                ItemDefinition fieldDef = (ItemDefinition)registered.next();
                DMNCompilerHelper.checkVariableName(dmnModel, (NamedElement)fieldDef, fieldDef.getName());
                DMNType fieldType = this.buildTypeDef(ctx, feel, dmnModel, node, fieldDef, false);
                fieldType = fieldType != null ? fieldType : DMNTypeRegistry.UNKNOWN;
                compType.addField(fieldDef.getName(), fieldType);
            }
            type = compType;
            if (topLevel && (registered = dmnModel.getTypeRegistry().registerType(type)) != type) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)itemDef, dmnModel, null, null, Msg.DUPLICATED_ITEM_DEFINITION, itemDef.getName());
            }
        }
        return type;
    }

    public DMNType resolveTypeRef(DMNModelImpl dmnModel, DMNNode node, NamedElement model, DMNModelInstrumentedBase localElement, QName typeRef) {
        if (typeRef != null) {
            String namespace = this.getNamespace(localElement, typeRef);
            DMNType type = dmnModel.getTypeRegistry().resolveType(namespace, typeRef.getLocalPart());
            if (type == null && "http://www.omg.org/spec/FEEL/20140401".equals(namespace)) {
                if (model instanceof Decision && ((Decision)model).getExpression() instanceof DecisionTable) {
                    DecisionTable dt = (DecisionTable)((Decision)model).getExpression();
                    if (dt.getOutput().size() > 1) {
                        CompositeTypeImpl compType = new CompositeTypeImpl(dmnModel.getNamespace(), model.getName() + "_Type", model.getId(), dt.getHitPolicy().isMultiHit());
                        for (OutputClause oc : dt.getOutput()) {
                            DMNType fieldType = this.resolveTypeRef(dmnModel, node, model, (DMNModelInstrumentedBase)oc, oc.getTypeRef());
                            compType.addField(oc.getName(), fieldType);
                        }
                        dmnModel.getTypeRegistry().registerType(compType);
                        return compType;
                    }
                    if (dt.getOutput().size() == 1) {
                        return this.resolveTypeRef(dmnModel, node, model, (DMNModelInstrumentedBase)dt.getOutput().get(0), ((OutputClause)dt.getOutput().get(0)).getTypeRef());
                    }
                }
            } else if (type == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, localElement, dmnModel, null, null, Msg.UNKNOWN_TYPE_REF_ON_NODE, typeRef.toString(), localElement.getParentDRDElement().getIdentifierString());
            }
            return type;
        }
        return dmnModel.getTypeRegistry().resolveType("http://www.omg.org/spec/FEEL/20140401", BuiltInType.UNKNOWN.getName());
    }

    private String getNamespace(DMNModelInstrumentedBase localElement, QName typeRef) {
        String prefix = typeRef.getPrefix();
        return localElement.getNamespaceURI(prefix);
    }

    private DMNCompilerConfiguration getDmnCompilerConfig() {
        return this.dmnCompilerConfig;
    }
}

