/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNListEvaluator
implements DMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(DMNListEvaluator.class);
    private final String name;
    private final DMNElement node;
    private final org.kie.dmn.model.v1_1.List listDef;
    private final List<DMNExpressionEvaluator> elements = new ArrayList<DMNExpressionEvaluator>();

    public DMNListEvaluator(String name, DMNElement node, org.kie.dmn.model.v1_1.List listDef) {
        this.name = name;
        this.node = node;
        this.listDef = listDef;
    }

    public void addElement(DMNExpressionEvaluator evaluator) {
        this.elements.add(evaluator);
    }

    public List<DMNExpressionEvaluator> getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        ArrayList<Object> results = new ArrayList<Object>();
        DMNContext previousContext = result.getContext();
        DMNContextImpl dmnContext = (DMNContextImpl)previousContext.clone();
        result.setContext(dmnContext);
        try {
            int index = 0;
            for (DMNExpressionEvaluator ee : this.elements) {
                try {
                    EvaluatorResult er = ee.evaluate(eventManager, result);
                    if (er.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.ERR_EVAL_LIST_ELEMENT_ON_POSITION_ON_LIST, index + 1, this.name);
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                        ++index;
                        return evaluatorResultImpl;
                    }
                    results.add(er.getResult());
                    ++index;
                }
                catch (Exception e) {
                    try {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, e, null, Msg.ERR_EVAL_LIST_ELEMENT_ON_POSITION_ON_LIST, index + 1, this.name);
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(results, EvaluatorResult.ResultType.FAILURE);
                        ++index;
                        return evaluatorResultImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            ++index;
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                            return new EvaluatorResultImpl(results, EvaluatorResult.ResultType.SUCCESS);
                        }
                    }
                }
            }
        }
        finally {
            result.setContext(previousContext);
        }
    }
}

