/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.List;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNContextImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.lang.impl.NamedParameter;
import org.kie.dmn.feel.runtime.FEELFunction;
import org.kie.dmn.model.v1_1.DMNElement;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.kie.dmn.model.v1_1.Invocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNInvocationEvaluator
implements DMNExpressionEvaluator,
FEELEventListener {
    private static final Logger logger = LoggerFactory.getLogger(DMNInvocationEvaluator.class);
    private final Invocation invocation;
    private final String nodeName;
    private final DMNElement node;
    private final String functionName;
    private final List<ActualParameter> parameters = new ArrayList<ActualParameter>();
    private final FEELImpl feel;
    private final List<FEELEvent> events = new ArrayList<FEELEvent>();

    public DMNInvocationEvaluator(String nodeName, DMNElement node, String functionName, Invocation invocation) {
        this.nodeName = nodeName;
        this.node = node;
        this.functionName = functionName;
        this.invocation = invocation;
        this.feel = (FEELImpl)FEEL.newInstance();
        this.feel.addListener((FEELEventListener)this);
    }

    public void addParameter(String name, DMNType type, DMNExpressionEvaluator evaluator) {
        this.parameters.add(new ActualParameter(name, type, evaluator));
    }

    public List<ActualParameter> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager eventManager, DMNResult dmnr) {
        DMNResultImpl result = (DMNResultImpl)dmnr;
        DMNContext previousContext = result.getContext();
        DMNContextImpl dmnContext = (DMNContextImpl)previousContext.clone();
        result.setContext(dmnContext);
        Object invocationResult = null;
        try {
            FEELFunction function = (FEELFunction)previousContext.get(this.functionName);
            if (function == null) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.FUNCTION_NOT_FOUND, this.functionName, this.nodeName);
                EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                return evaluatorResultImpl;
            }
            Object[] namedParams = new Object[this.parameters.size()];
            int index = 0;
            for (ActualParameter param : this.parameters) {
                try {
                    EvaluatorResult value = param.expression.evaluate(eventManager, result);
                    if (value.getResultType() != EvaluatorResult.ResultType.SUCCESS) {
                        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, null, null, Msg.ERR_EVAL_PARAM_FOR_INVOCATION_ON_NODE, param.name, this.functionName, this.nodeName);
                        EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                        return evaluatorResultImpl;
                    }
                    namedParams[index++] = new NamedParameter(param.name, value.getResult());
                }
                catch (Exception e) {
                    MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, e, null, Msg.ERR_INVOKING_PARAM_EXPR_FOR_PARAM_ON_NODE, param.name, this.nodeName);
                    EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
                    return evaluatorResultImpl;
                }
            }
            EvaluationContextImpl ctx = new EvaluationContextImpl(this.feel.getEventsManager());
            invocationResult = function.invokeReflectively((EvaluationContext)ctx, namedParams);
            boolean hasErrors = this.hasErrors(this.events, eventManager, result);
            EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(invocationResult, hasErrors ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
            return evaluatorResultImpl;
        }
        catch (Throwable t) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.node, result, t, null, Msg.ERR_INVOKING_FUNCTION_ON_NODE, this.functionName, this.nodeName);
            EvaluatorResultImpl evaluatorResultImpl = new EvaluatorResultImpl(null, EvaluatorResult.ResultType.FAILURE);
            return evaluatorResultImpl;
        }
        finally {
            result.setContext(previousContext);
        }
    }

    public void onEvent(FEELEvent event) {
        this.events.add(event);
    }

    private boolean hasErrors(List<FEELEvent> events, DMNRuntimeEventManager eventManager, DMNResultImpl result) {
        boolean hasErrors = false;
        for (FEELEvent e : events) {
            if (e.getSeverity() != FEELEvent.Severity.ERROR) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)this.invocation, result, null, e, Msg.FEEL_ERROR, e.getMessage());
            hasErrors = true;
        }
        events.clear();
        return hasErrors;
    }

    private static class ActualParameter {
        final String name;
        final DMNType type;
        final DMNExpressionEvaluator expression;

        public ActualParameter(String name, DMNType type, DMNExpressionEvaluator evaluator) {
            this.name = name;
            this.type = type;
            this.expression = evaluator;
        }
    }
}

