/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.event.DMNRuntimeEventManager;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.api.feel.runtime.events.FEELEventListener;
import org.kie.dmn.core.api.DMNExpressionEvaluator;
import org.kie.dmn.core.api.EvaluatorResult;
import org.kie.dmn.core.ast.DMNBaseNode;
import org.kie.dmn.core.ast.EvaluatorResultImpl;
import org.kie.dmn.core.impl.DMNResultImpl;
import org.kie.dmn.core.impl.DMNRuntimeEventManagerImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELImpl;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesMatchedEvent;
import org.kie.dmn.feel.runtime.events.DecisionTableRulesSelectedEvent;
import org.kie.dmn.feel.runtime.functions.DTInvokerFunction;
import org.kie.dmn.model.v1_1.DMNModelInstrumentedBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNDTExpressionEvaluator
implements DMNExpressionEvaluator,
FEELEventListener {
    private static Logger logger = LoggerFactory.getLogger(DMNDTExpressionEvaluator.class);
    private final DMNNode node;
    private DTInvokerFunction dt;
    private FEELImpl feel;
    private List<FEELEvent> events = new ArrayList<FEELEvent>();

    public DMNDTExpressionEvaluator(DMNNode node, DTInvokerFunction dt) {
        this.node = node;
        this.dt = dt;
        this.feel = (FEELImpl)FEEL.newInstance();
        this.feel.addListener((FEELEventListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluatorResult evaluate(DMNRuntimeEventManager dmrem, DMNResult dmnr) {
        EvaluatorResultImpl evaluatorResultImpl;
        DMNRuntimeEventManagerImpl eventManager = (DMNRuntimeEventManagerImpl)dmrem;
        DMNResultImpl result = (DMNResultImpl)dmnr;
        EventResults r = null;
        try {
            eventManager.fireBeforeEvaluateDecisionTable(this.node.getName(), this.dt.getName(), result);
            List paramNames = (List)this.dt.getParameterNames().get(0);
            Object[] params = new Object[paramNames.size()];
            EvaluationContextImpl ctx = new EvaluationContextImpl(this.feel.getEventsManager());
            ctx.enterFrame();
            for (Map.Entry entry : result.getContext().getAll().entrySet()) {
                ctx.setValue((String)entry.getKey(), entry.getValue());
            }
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.feel.evaluate((String)paramNames.get(i), result.getContext().getAll());
                ctx.setValue((String)paramNames.get(i), params[i]);
            }
            Object dtr = this.dt.invoke((EvaluationContext)ctx, params).cata(e -> {
                this.events.add((FEELEvent)e);
                return null;
            }, Function.identity());
            ctx.exitFrame();
            r = this.processEvents(this.events, eventManager, result);
            evaluatorResultImpl = new EvaluatorResultImpl(dtr, r.hasErrors ? EvaluatorResult.ResultType.FAILURE : EvaluatorResult.ResultType.SUCCESS);
        }
        catch (Throwable throwable) {
            eventManager.fireAfterEvaluateDecisionTable(this.node.getName(), this.dt.getName(), result, r != null ? r.matchedRules : null, r != null ? r.fired : null);
            throw throwable;
        }
        eventManager.fireAfterEvaluateDecisionTable(this.node.getName(), this.dt.getName(), result, r != null ? r.matchedRules : null, r != null ? r.fired : null);
        return evaluatorResultImpl;
    }

    private EventResults processEvents(List<FEELEvent> events, DMNRuntimeEventManager eventManager, DMNResultImpl result) {
        EventResults r = new EventResults();
        for (FEELEvent e : events) {
            if (e instanceof DecisionTableRulesMatchedEvent) {
                r.matchedRules = ((DecisionTableRulesMatchedEvent)e).getMatches();
                continue;
            }
            if (e instanceof DecisionTableRulesSelectedEvent) {
                r.fired = ((DecisionTableRulesSelectedEvent)e).getFired();
                continue;
            }
            if (e.getSeverity() == FEELEvent.Severity.ERROR) {
                MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)((DMNBaseNode)this.node).getSource(), result, null, e, Msg.FEEL_ERROR, e.getMessage());
                r.hasErrors = true;
                continue;
            }
            if (e.getSeverity() != FEELEvent.Severity.WARN) continue;
            MsgUtil.reportMessage(logger, DMNMessage.Severity.WARN, (DMNModelInstrumentedBase)((DMNBaseNode)this.node).getSource(), result, null, e, Msg.FEEL_WARN, e.getMessage());
        }
        events.clear();
        return r;
    }

    public void onEvent(FEELEvent event) {
        this.events.add(event);
    }

    private static class EventResults {
        public boolean hasErrors = false;
        public List<Integer> matchedRules;
        public List<Integer> fired;

        private EventResults() {
        }
    }
}

