/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.ast;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.model.v1_1.BusinessKnowledgeModel;
import org.kie.dmn.model.v1_1.Decision;
import org.kie.dmn.model.v1_1.InformationRequirement;
import org.kie.dmn.model.v1_1.KnowledgeRequirement;
import org.kie.dmn.model.v1_1.NamedElement;

public abstract class DMNBaseNode
implements DMNNode {
    private NamedElement source;
    private Map<String, DMNNode> dependencies = new LinkedHashMap<String, DMNNode>();

    public DMNBaseNode() {
    }

    public DMNBaseNode(NamedElement source) {
        this.source = source;
    }

    public String getId() {
        return this.source != null ? this.source.getId() : null;
    }

    public String getName() {
        return this.source != null ? this.source.getName() : null;
    }

    public String getIdentifierString() {
        String identifier = "[unnamed]";
        if (this.source != null) {
            identifier = this.source.getName() != null ? this.source.getName() : this.source.getId();
        }
        return identifier;
    }

    public NamedElement getSource() {
        return this.source;
    }

    public Map<String, DMNNode> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Map<String, DMNNode> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(String name, DMNNode dependency) {
        this.dependencies.put(name, dependency);
    }

    public List<InformationRequirement> getInformationRequirement() {
        if (this.source instanceof Decision) {
            return ((Decision)this.source).getInformationRequirement();
        }
        return Collections.emptyList();
    }

    public List<KnowledgeRequirement> getKnowledgeRequirement() {
        if (this.source instanceof Decision) {
            return ((Decision)this.source).getKnowledgeRequirement();
        }
        if (this.source instanceof BusinessKnowledgeModel) {
            return ((BusinessKnowledgeModel)this.source).getKnowledgeRequirement();
        }
        return Collections.emptyList();
    }
}

