/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.assembler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.builder.impl.KnowledgeBuilderImpl;
import org.drools.compiler.compiler.PackageRegistry;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.dmn.api.core.DMNCompiler;
import org.kie.dmn.api.core.DMNCompilerConfiguration;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.marshalling.v1_1.DMNExtensionRegister;
import org.kie.dmn.core.api.DMNFactory;
import org.kie.dmn.core.impl.DMNKnowledgeBuilderError;
import org.kie.dmn.core.impl.DMNPackageImpl;
import org.kie.internal.assembler.KieAssemblerService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMNAssemblerService
implements KieAssemblerService {
    private static final Logger logger = LoggerFactory.getLogger(DMNAssemblerService.class);
    public static final String DMN_EXTENSION_REGISTER_PREFIX = "org.kie.dmn.marshaller.extension.";

    public ResourceType getResourceType() {
        return ResourceType.DMN;
    }

    public void addResource(KnowledgeBuilder kbuilder, Resource resource, ResourceType type, ResourceConfiguration configuration) throws Exception {
        DMNCompiler dmnCompiler = this.getCompiler(kbuilder);
        DMNModel model = dmnCompiler.compile(resource);
        if (model != null) {
            InternalKnowledgePackage kpkgs;
            Map rpkg;
            DMNPackageImpl dmnpkg;
            KnowledgeBuilderImpl kbuilderImpl = (KnowledgeBuilderImpl)kbuilder;
            String namespace = model.getNamespace();
            PackageRegistry pkgReg = kbuilderImpl.getPackageRegistry(namespace);
            if (pkgReg == null) {
                pkgReg = kbuilderImpl.newPackage(new PackageDescr(namespace));
            }
            if ((dmnpkg = (DMNPackageImpl)(rpkg = (kpkgs = pkgReg.getPackage()).getResourceTypePackages()).get(ResourceType.DMN)) == null) {
                dmnpkg = new DMNPackageImpl(namespace);
                rpkg.put(ResourceType.DMN, dmnpkg);
            } else if (dmnpkg.getModel(model.getName()) != null) {
                ((KnowledgeBuilderImpl)kbuilder).addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.ERROR, resource, namespace, "Duplicate model name " + model.getName() + " in namespace " + namespace));
                logger.error("Duplicate model name {} in namespace {}", (Object)model.getName(), (Object)namespace);
            }
            dmnpkg.addModel(model.getName(), model);
        } else {
            ((KnowledgeBuilderImpl)kbuilder).addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.ERROR, resource, "Unable to compile DMN model for the resource"));
            logger.error("Unable to compile DMN model for resource {}", (Object)resource.getSourcePath());
        }
    }

    private DMNCompiler getCompiler(KnowledgeBuilder kbuilder) {
        DMNCompiler dmnCompiler;
        HashMap extensionProperties = new HashMap();
        ((KnowledgeBuilderImpl)kbuilder).getBuilderConfiguration().getChainedProperties().mapStartsWith(extensionProperties, DMN_EXTENSION_REGISTER_PREFIX, false);
        if (!extensionProperties.isEmpty()) {
            ArrayList<DMNExtensionRegister> extensionRegisters = new ArrayList<DMNExtensionRegister>();
            try {
                for (Map.Entry extensionProperty : extensionProperties.entrySet()) {
                    String extRegClassName = (String)extensionProperty.getValue();
                    DMNExtensionRegister extRegister = (DMNExtensionRegister)((KnowledgeBuilderImpl)kbuilder).getRootClassLoader().loadClass(extRegClassName).newInstance();
                    extensionRegisters.add(extRegister);
                }
                DMNCompilerConfiguration compilerConfig = DMNFactory.newCompilerConfiguration();
                compilerConfig.addExtensions(extensionRegisters);
                dmnCompiler = DMNFactory.newCompiler(compilerConfig);
            }
            catch (Exception e) {
                ((KnowledgeBuilderImpl)kbuilder).addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.WARNING, "Trying to load a non-existing extension element register " + e.getLocalizedMessage()));
                logger.error("Trying to load a non-existing extension element register {}", (Object)e.getLocalizedMessage(), (Object)e);
                ((KnowledgeBuilderImpl)kbuilder).addBuilderResult((KnowledgeBuilderResult)new DMNKnowledgeBuilderError(ResultSeverity.WARNING, "DMN Compiler configuration contained errors, fall-back using empty-configuration compiler."));
                logger.warn("DMN Compiler configuration contained errors, fall-back using empty-configuration compiler.");
                dmnCompiler = DMNFactory.newCompiler();
            }
        } else {
            dmnCompiler = DMNFactory.newCompiler();
        }
        return dmnCompiler;
    }

    public Class getServiceInterface() {
        return KieAssemblerService.class;
    }
}

