/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.adapters.undertow.UndertowHttpFacade;

public class ServletHttpFacade
extends UndertowHttpFacade {
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    public ServletHttpFacade(HttpServerExchange exchange) {
        super(exchange);
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        this.request = (HttpServletRequest)servletRequestContext.getServletRequest();
        this.response = (HttpServletResponse)servletRequestContext.getServletResponse();
    }

    @Override
    public HttpFacade.Response getResponse() {
        return new ResponseFacade();
    }

    @Override
    public HttpFacade.Request getRequest() {
        return new RequestFacade();
    }

    protected class ResponseFacade
    extends UndertowHttpFacade.ResponseFacade {
        protected ResponseFacade() {
        }
    }

    protected class RequestFacade
    extends UndertowHttpFacade.RequestFacade {
        protected RequestFacade() {
        }

        @Override
        public String getFirstParam(String param) {
            return ServletHttpFacade.this.request.getParameter(param);
        }

        @Override
        public void setError(AuthenticationError error) {
            ServletHttpFacade.this.request.setAttribute(AuthenticationError.class.getName(), (Object)error);
        }

        @Override
        public void setError(LogoutError error) {
            ServletHttpFacade.this.request.setAttribute(LogoutError.class.getName(), (Object)error);
        }
    }
}

