/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.tomcat;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AdapterTokenStore;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.tomcat.AbstractAuthenticatedActionsValve;
import org.keycloak.adapters.tomcat.AbstractKeycloakAuthenticatorValve;
import org.keycloak.adapters.tomcat.AuthenticatedActionsValve;
import org.keycloak.adapters.tomcat.CatalinaHttpFacade;
import org.keycloak.adapters.tomcat.CatalinaRequestAuthenticator;
import org.keycloak.adapters.tomcat.GenericPrincipalFactory;
import org.keycloak.adapters.tomcat.TomcatRequestAuthenticator;

public class KeycloakAuthenticatorValve
extends AbstractKeycloakAuthenticatorValve {
    public boolean authenticate(Request request, HttpServletResponse response) throws IOException {
        return this.authenticateInternal(request, response, request.getContext().getLoginConfig());
    }

    protected boolean doAuthenticate(Request request, HttpServletResponse response) throws IOException {
        return this.authenticate(request, response);
    }

    @Override
    protected boolean forwardToErrorPageInternal(Request request, HttpServletResponse response, Object loginConfig) throws IOException {
        if (loginConfig == null) {
            return false;
        }
        LoginConfig config = (LoginConfig)loginConfig;
        if (config.getErrorPage() == null) {
            return false;
        }
        try {
            Method method = null;
            method = FormAuthenticator.class.getDeclaredMethod("forwardToErrorPage", Request.class, HttpServletResponse.class, LoginConfig.class);
            method.setAccessible(true);
            method.invoke((Object)this, request, response, config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    protected void initInternal() {
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
    }

    public void logout(Request request) {
        this.logoutInternal(request);
    }

    @Override
    protected GenericPrincipalFactory createPrincipalFactory() {
        return new GenericPrincipalFactory(){

            @Override
            protected GenericPrincipal createPrincipal(Principal userPrincipal, List<String> roles) {
                return new GenericPrincipal(userPrincipal.getName(), null, roles, userPrincipal, null);
            }
        };
    }

    @Override
    protected AdapterTokenStore getTokenStore(Request request, HttpFacade facade, KeycloakDeployment resolvedDeployment) {
        return super.getTokenStore(request, facade, resolvedDeployment);
    }

    @Override
    protected AbstractAuthenticatedActionsValve createAuthenticatedActionsValve(AdapterDeploymentContext deploymentContext, Valve next, Container container) {
        return new AuthenticatedActionsValve(deploymentContext, next, container);
    }

    @Override
    protected CatalinaRequestAuthenticator createRequestAuthenticator(Request request, CatalinaHttpFacade facade, KeycloakDeployment deployment, AdapterTokenStore tokenStore) {
        return new TomcatRequestAuthenticator(deployment, tokenStore, facade, request, this.createPrincipalFactory());
    }
}

