/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.IOException;
import java.security.KeyPair;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.SAML2NameIDPolicyBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;

public abstract class AbstractInitiateLogin
implements AuthChallenge {
    protected static Logger log = Logger.getLogger(AbstractInitiateLogin.class);
    protected SamlDeployment deployment;
    protected SamlSessionStore sessionStore;

    public AbstractInitiateLogin(SamlDeployment deployment, SamlSessionStore sessionStore) {
        this.deployment = deployment;
        this.sessionStore = sessionStore;
    }

    public int getResponseCode() {
        return 0;
    }

    public boolean challenge(HttpFacade httpFacade) {
        try {
            SAML2AuthnRequestBuilder authnRequestBuilder = AbstractInitiateLogin.buildSaml2AuthnRequestBuilder(this.deployment);
            BaseSAML2BindingBuilder binding = AbstractInitiateLogin.createSaml2Binding(this.deployment);
            this.sessionStore.saveRequest();
            this.sendAuthnRequest(httpFacade, authnRequestBuilder, binding);
            this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.LOGGING_IN);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create authentication request.", e);
        }
        return true;
    }

    public static BaseSAML2BindingBuilder createSaml2Binding(SamlDeployment deployment) {
        BaseSAML2BindingBuilder binding = new BaseSAML2BindingBuilder();
        if (deployment.getIDP().getSingleSignOnService().signRequest()) {
            binding.signatureAlgorithm(deployment.getSignatureAlgorithm());
            KeyPair keypair = deployment.getSigningKeyPair();
            if (keypair == null) {
                throw new RuntimeException("Signing keys not configured");
            }
            if (deployment.getSignatureCanonicalizationMethod() != null) {
                binding.canonicalizationMethod(deployment.getSignatureCanonicalizationMethod());
            }
            binding.signWith(null, keypair);
            binding.signDocument();
        }
        return binding;
    }

    public static SAML2AuthnRequestBuilder buildSaml2AuthnRequestBuilder(SamlDeployment deployment) {
        String issuerURL = deployment.getEntityID();
        String nameIDPolicyFormat = deployment.getNameIDPolicyFormat();
        if (nameIDPolicyFormat == null) {
            nameIDPolicyFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
        }
        SamlDeployment.IDP.SingleSignOnService sso = deployment.getIDP().getSingleSignOnService();
        SAML2AuthnRequestBuilder authnRequestBuilder = new SAML2AuthnRequestBuilder().destination(sso.getRequestBindingUrl()).issuer(issuerURL).forceAuthn(deployment.isForceAuthentication()).isPassive(deployment.isIsPassive()).nameIdPolicy(SAML2NameIDPolicyBuilder.format((String)nameIDPolicyFormat));
        if (sso.getResponseBinding() != null) {
            String protocolBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
            if (sso.getResponseBinding() == SamlDeployment.Binding.POST) {
                protocolBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
            }
            authnRequestBuilder.protocolBinding(protocolBinding);
        }
        if (sso.getAssertionConsumerServiceUrl() != null) {
            authnRequestBuilder.assertionConsumerUrl(sso.getAssertionConsumerServiceUrl());
        }
        return authnRequestBuilder;
    }

    protected abstract void sendAuthnRequest(HttpFacade var1, SAML2AuthnRequestBuilder var2, BaseSAML2BindingBuilder var3) throws ProcessingException, ConfigurationException, IOException;
}

