/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.plugin.commons_lang;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.xml.sax.ErrorHandler;

public class XjcCommonsLangPlugin
extends Plugin {
    private static final String TOSTRING_STYLE_PARAM = "-Xcommons-lang:ToStringStyle=";
    private String toStringStyle = "MULTI_LINE_STYLE";
    private Class<?> customToStringStyle;

    public String getOptionName() {
        return "Xcommons-lang";
    }

    public String getUsage() {
        return "  -Xcommons-lang        :  generate toString(), hashCode() and equals() for generated code using Jakarta's common-lang\n [-Xcommons-lang:ToStringStyle=MULTI_LINE_STYLE\n\t| DEFAULT_STYLE\n\t| NO_FIELD_NAMES_STYLE\n\t| SHORT_PREFIX_STYLE\n\t| SIMPLE_STYLE\n\t| <Fully qualified class name of a ToStringStyle subtype>]\n";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass implClass = classOutline.implClass;
            this.createToStringMethod(implClass);
            this.createEqualsMethod(implClass);
            this.createHashCodeMethod(implClass);
        }
        return true;
    }

    private void createToStringMethod(JDefinedClass implClass) {
        JCodeModel codeModel = implClass.owner();
        JMethod toStringMethod = implClass.method(1, (JType)codeModel.ref(String.class), "toString");
        toStringMethod.annotate(Override.class);
        JInvocation toStringStyleExpr = this.customToStringStyle == null ? codeModel.ref(ToStringStyle.class).staticRef(this.toStringStyle) : JExpr._new((JClass)codeModel.ref(this.customToStringStyle));
        toStringMethod.body()._return((JExpression)codeModel.ref(ToStringBuilder.class).staticInvoke("reflectionToString").arg(JExpr._this()).arg((JExpression)toStringStyleExpr));
    }

    private void createEqualsMethod(JDefinedClass implClass) {
        JCodeModel codeModel = implClass.owner();
        JMethod toStringMethod = implClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        JVar that = toStringMethod.param(Object.class, "that");
        toStringMethod.annotate(Override.class);
        toStringMethod.body()._return((JExpression)codeModel.ref(EqualsBuilder.class).staticInvoke("reflectionEquals").arg(JExpr._this()).arg((JExpression)that));
    }

    private void createHashCodeMethod(JDefinedClass implClass) {
        JCodeModel codeModel = implClass.owner();
        JMethod toStringMethod = implClass.method(1, (JType)codeModel.INT, "hashCode");
        toStringMethod.annotate(Override.class);
        toStringMethod.body()._return((JExpression)codeModel.ref(HashCodeBuilder.class).staticInvoke("reflectionHashCode").arg(JExpr._this()));
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException {
        String arg = args[i].trim();
        if (arg.startsWith(TOSTRING_STYLE_PARAM)) {
            this.toStringStyle = arg.substring(TOSTRING_STYLE_PARAM.length());
            try {
                ToStringStyle.class.getField(this.toStringStyle);
                return 1;
            }
            catch (SecurityException e) {
                throw new BadCommandLineException(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                try {
                    this.customToStringStyle = Class.forName(this.toStringStyle);
                }
                catch (ClassNotFoundException e2) {
                    throw new BadCommandLineException(e2.getMessage());
                }
                return 1;
            }
        }
        return 0;
    }
}

