/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.surefire.provider;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.surefire.providerapi.AbstractProvider;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.surefire.provider.RunListenerAdapter;
import org.junit.platform.surefire.provider.TestPlanScannerFilter;

@API(value=API.Usage.Experimental)
public class JUnitPlatformProvider
extends AbstractProvider {
    static final String EXCLUDE_GROUPS = "excludedGroups";
    static final String EXCLUDE_TAGS = "excludeTags";
    static final String INCLUDE_GROUPS = "groups";
    static final String INCLUDE_TAGS = "includeTags";
    static final String CONFIGURATION_PARAMETERS = "configurationParameters";
    static final String EXCEPTION_MESSAGE_BOTH_NOT_ALLOWED = "The groups and includeTags parameters (or the excludedGroups and excludeTags parameters) are synonyms - only one of each is allowed (though neither is required).";
    private final ProviderParameters parameters;
    private final Launcher launcher;
    final Filter<?>[] includeAndExcludeFilters;
    final Map<String, String> configurationParameters;

    public JUnitPlatformProvider(ProviderParameters parameters) {
        this(parameters, LauncherFactory.create());
    }

    JUnitPlatformProvider(ProviderParameters parameters, Launcher launcher) {
        this.parameters = parameters;
        this.launcher = launcher;
        this.includeAndExcludeFilters = this.getIncludeAndExcludeFilters();
        this.configurationParameters = this.getConfigurationParameters();
        Logger.getLogger("org.junit").setLevel(Level.WARNING);
    }

    public Iterable<Class<?>> getSuites() {
        return this.scanClasspath();
    }

    public RunResult invoke(Object forkTestSet) throws TestSetFailedException, ReporterException, InvocationTargetException {
        if (forkTestSet instanceof TestsToRun) {
            return this.invokeAllTests((TestsToRun)forkTestSet);
        }
        if (forkTestSet instanceof Class) {
            return this.invokeAllTests(TestsToRun.fromClass((Class)((Class)forkTestSet)));
        }
        if (forkTestSet == null) {
            return this.invokeAllTests(this.scanClasspath());
        }
        throw new IllegalArgumentException("Unexpected value of forkTestSet: " + forkTestSet);
    }

    private TestsToRun scanClasspath() {
        TestsToRun scannedClasses = this.parameters.getScanResult().applyFilter((ScannerFilter)new TestPlanScannerFilter(this.launcher, this.includeAndExcludeFilters), this.parameters.getTestClassLoader());
        return this.parameters.getRunOrderCalculator().orderTestClasses(scannedClasses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunResult invokeAllTests(TestsToRun testsToRun) {
        RunResult runResult;
        ReporterFactory reporterFactory = this.parameters.getReporterFactory();
        try {
            RunListener runListener = reporterFactory.createReporter();
            this.launcher.registerTestExecutionListeners(new TestExecutionListener[]{new RunListenerAdapter(runListener)});
            for (Class testClass : testsToRun) {
                this.invokeSingleClass(testClass, runListener);
            }
        }
        finally {
            runResult = reporterFactory.close();
        }
        return runResult;
    }

    private void invokeSingleClass(Class<?> testClass, RunListener runListener) {
        SimpleReportEntry classEntry = new SimpleReportEntry(((Object)((Object)this)).getClass().getName(), testClass.getName());
        runListener.testSetStarting((ReportEntry)classEntry);
        LauncherDiscoveryRequest discoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(testClass)}).filters(this.includeAndExcludeFilters).configurationParameters(this.configurationParameters).build();
        this.launcher.execute(discoveryRequest, new TestExecutionListener[0]);
        runListener.testSetCompleted((ReportEntry)classEntry);
    }

    private Filter<?>[] getIncludeAndExcludeFilters() {
        ArrayList filters = new ArrayList();
        Optional<List<String>> includes = this.getGroupsOrTags(this.getPropertiesList(INCLUDE_GROUPS), this.getPropertiesList(INCLUDE_TAGS));
        includes.map(TagFilter::includeTags).ifPresent(filters::add);
        Optional<List<String>> excludes = this.getGroupsOrTags(this.getPropertiesList(EXCLUDE_GROUPS), this.getPropertiesList(EXCLUDE_TAGS));
        excludes.map(TagFilter::excludeTags).ifPresent(filters::add);
        return filters.toArray(new Filter[filters.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> getConfigurationParameters() {
        String content = (String)this.parameters.getProviderProperties().get(CONFIGURATION_PARAMETERS);
        if (content == null) {
            return Collections.emptyMap();
        }
        try (StringReader reader = new StringReader(content);){
            HashMap<String, String> result = new HashMap<String, String>();
            Properties props = new Properties();
            props.load(reader);
            props.stringPropertyNames().forEach(key -> result.put((String)key, props.getProperty((String)key)));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Error reading configurationParameters", ex);
        }
    }

    private Optional<List<String>> getPropertiesList(String key) {
        List<String> compoundProperties = null;
        String property = (String)this.parameters.getProviderProperties().get(key);
        if (property != null) {
            compoundProperties = Arrays.asList(property.split("[, ]+"));
        }
        return Optional.ofNullable(compoundProperties);
    }

    private Optional<List<String>> getGroupsOrTags(Optional<List<String>> groups, Optional<List<String>> tags) {
        Optional<List<String>> elements = Optional.empty();
        Preconditions.condition((!groups.isPresent() || !tags.isPresent() ? 1 : 0) != 0, (String)EXCEPTION_MESSAGE_BOTH_NOT_ALLOWED);
        if (groups.isPresent()) {
            elements = groups;
        } else if (tags.isPresent()) {
            elements = tags;
        }
        return elements;
    }
}

