/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="5.7")
public class ClassNamePatternFilterUtils {
    public static final String DEACTIVATE_ALL_PATTERN = "*";

    private ClassNamePatternFilterUtils() {
    }

    public static <T> Predicate<T> excludeMatchingClasses(String patterns) {
        return Optional.ofNullable(patterns).filter(StringUtils::isNotBlank).map(String::trim).map(ClassNamePatternFilterUtils::createPredicateFromPatterns).orElse(object -> true);
    }

    private static <T> Predicate<T> createPredicateFromPatterns(String patterns) {
        if (DEACTIVATE_ALL_PATTERN.equals(patterns)) {
            return object -> false;
        }
        List<Pattern> patternList = ClassNamePatternFilterUtils.convertToRegularExpressions(patterns);
        return object -> patternList.stream().noneMatch(it -> it.matcher(object.getClass().getName()).matches());
    }

    private static List<Pattern> convertToRegularExpressions(String patterns) {
        return Arrays.stream(patterns.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(ClassNamePatternFilterUtils::replaceRegExElements).map(Pattern::compile).collect(Collectors.toList());
    }

    private static String replaceRegExElements(String pattern) {
        return Matcher.quoteReplacement(pattern).replace(".", "[.$]").replace(DEACTIVATE_ALL_PATTERN, ".+");
    }
}

