/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.gen5.api.Executable;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.ExceptionUtils;
import org.junit.gen5.commons.util.Preconditions;

@API(value=API.Usage.Internal)
public class ThrowableCollector {
    private final List<Throwable> throwables = new ArrayList<Throwable>();

    public void execute(Executable executable) {
        try {
            executable.execute();
        }
        catch (Throwable t) {
            this.add(t);
        }
    }

    void add(Throwable t) {
        Preconditions.notNull((Object)t, (String)"Throwable must not be null");
        this.throwables.add(t);
    }

    List<Throwable> getThrowables() {
        return Collections.unmodifiableList(this.throwables);
    }

    public void assertEmpty() {
        if (!this.throwables.isEmpty()) {
            Throwable t = this.throwables.get(0);
            this.throwables.stream().skip(1L).forEach(t::addSuppressed);
            ExceptionUtils.throwAsUncheckedException((Throwable)t);
        }
    }
}

