/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5.execution;

import java.util.logging.Logger;
import org.junit.gen5.api.extension.ConditionEvaluationResult;
import org.junit.gen5.api.extension.ContainerExecutionCondition;
import org.junit.gen5.api.extension.ContainerExtensionContext;
import org.junit.gen5.api.extension.TestExecutionCondition;
import org.junit.gen5.api.extension.TestExtensionContext;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.junit5.execution.ConditionEvaluationException;
import org.junit.gen5.engine.junit5.extension.ExtensionRegistry;

@API(value=API.Usage.Internal)
public class ConditionEvaluator {
    private static final Logger LOG = Logger.getLogger(ConditionEvaluator.class.getName());
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"No 'disabled' conditions encountered");

    public ConditionEvaluationResult evaluateForContainer(ExtensionRegistry extensionRegistry, ContainerExtensionContext context) {
        return extensionRegistry.stream(ContainerExecutionCondition.class, ExtensionRegistry.ApplicationOrder.FORWARD).map(extensionPoint -> (ContainerExecutionCondition)extensionPoint.getExtensionPoint()).map(condition -> this.evaluate((ContainerExecutionCondition)condition, context)).filter(ConditionEvaluationResult::isDisabled).findFirst().orElse(ENABLED);
    }

    public ConditionEvaluationResult evaluateForTest(ExtensionRegistry extensionRegistry, TestExtensionContext context) {
        return extensionRegistry.stream(TestExecutionCondition.class, ExtensionRegistry.ApplicationOrder.FORWARD).map(extensionPoint -> (TestExecutionCondition)extensionPoint.getExtensionPoint()).map(condition -> this.evaluate((TestExecutionCondition)condition, context)).filter(ConditionEvaluationResult::isDisabled).findFirst().orElse(ENABLED);
    }

    private ConditionEvaluationResult evaluate(ContainerExecutionCondition condition, ContainerExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluate(context);
            this.logResult(condition.getClass(), result);
            return result;
        }
        catch (Exception ex) {
            throw new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]", condition.getClass().getName()), ex);
        }
    }

    private ConditionEvaluationResult evaluate(TestExecutionCondition condition, TestExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluate(context);
            this.logResult(condition.getClass(), result);
            return result;
        }
        catch (Exception ex) {
            throw new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]", condition.getClass().getName()), ex);
        }
    }

    private void logResult(Class<?> conditionType, ConditionEvaluationResult result) {
        LOG.finer(() -> String.format("Evaluation of condition [%s] resulted in: %s", conditionType.getName(), result));
    }
}

