/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit5;

import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.Preconditions;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.ExecutionRequest;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.junit5.DiscoveryFilterApplier;
import org.junit.gen5.engine.junit5.discovery.DiscoverySelectorResolver;
import org.junit.gen5.engine.junit5.discovery.JUnit5EngineDescriptor;
import org.junit.gen5.engine.junit5.execution.JUnit5EngineExecutionContext;
import org.junit.gen5.engine.support.hierarchical.HierarchicalTestEngine;

@API(value=API.Usage.Experimental)
public class JUnit5TestEngine
extends HierarchicalTestEngine<JUnit5EngineExecutionContext> {
    public static final String ENGINE_ID = "junit5";

    public String getId() {
        return ENGINE_ID;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest) {
        Preconditions.notNull((Object)discoveryRequest, (String)"discovery request must not be null");
        JUnit5EngineDescriptor engineDescriptor = new JUnit5EngineDescriptor(ENGINE_ID);
        this.resolveDiscoveryRequest(discoveryRequest, engineDescriptor);
        return engineDescriptor;
    }

    private void resolveDiscoveryRequest(EngineDiscoveryRequest discoveryRequest, JUnit5EngineDescriptor engineDescriptor) {
        DiscoverySelectorResolver resolver = new DiscoverySelectorResolver(engineDescriptor);
        resolver.resolveSelectors(discoveryRequest);
        this.applyDiscoveryFilters(discoveryRequest, engineDescriptor);
    }

    private void applyDiscoveryFilters(EngineDiscoveryRequest discoveryRequest, JUnit5EngineDescriptor engineDescriptor) {
        new DiscoveryFilterApplier().applyAllFilters(discoveryRequest, (TestDescriptor)engineDescriptor);
    }

    protected JUnit5EngineExecutionContext createExecutionContext(ExecutionRequest request) {
        return new JUnit5EngineExecutionContext(request.getEngineExecutionListener());
    }
}

