/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.iconv;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Iconv"})
public class RubyIconv
extends RubyObject {
    private static final String IGNORE = "//ignore";
    private CharsetDecoder fromEncoding;
    private CharsetEncoder toEncoding;
    private int count;
    private String endian = "";
    private static final ObjectAllocator ICONV_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyIconv(runtime, klass);
        }
    };

    public RubyIconv(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static void createIconv(Ruby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject(), ICONV_ALLOCATOR);
        iconvClass.defineAnnotatedMethods(RubyIconv.class);
        RubyModule failure = iconvClass.defineModuleUnder("Failure");
        RubyClass argumentError = runtime.getArgumentError();
        String[] iconvErrors = new String[]{"IllegalSequence", "InvalidCharacter", "InvalidEncoding", "OutOfRange", "BrokenLibrary"};
        for (int i2 = 0; i2 < iconvErrors.length; ++i2) {
            RubyClass subClass = iconvClass.defineClassUnder(iconvErrors[i2], argumentError, RubyFailure.ICONV_FAILURE_ALLOCATOR);
            subClass.defineAnnotatedMethods(RubyFailure.class);
            subClass.includeModule(failure);
        }
    }

    private static String getCharset(String encoding2) {
        int index2 = encoding2.indexOf("//");
        if (index2 == -1) {
            return encoding2;
        }
        return encoding2.substring(0, index2);
    }

    private static boolean isIgnore(String encoding2) {
        return encoding2.toLowerCase().indexOf(IGNORE) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=2, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject to, IRubyObject from, Block block) {
        Ruby runtime = context.runtime;
        RubyIconv iconv2 = RubyIconv.newIconv(context, recv2, to, from);
        if (!block.isGiven()) {
            return iconv2;
        }
        IRubyObject result2 = runtime.getNil();
        try {
            result2 = block.yield(context, iconv2);
        }
        finally {
            iconv2.close();
        }
        return result2;
    }

    private static RubyIconv newIconv(ThreadContext context, IRubyObject recv2, IRubyObject to, IRubyObject from) {
        RubyClass klazz = (RubyClass)recv2;
        return (RubyIconv)klazz.newInstance(context, new IRubyObject[]{to, from}, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject initialize(IRubyObject arg1, IRubyObject arg2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        if (!arg1.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg1.getMetaClass() + " into String");
        }
        if (!arg2.respondsTo("to_str")) {
            throw runtime.newTypeError("can't convert " + arg2.getMetaClass() + " into String");
        }
        String to = arg1.convertToString().toString();
        String from = arg2.convertToString().toString();
        try {
            this.fromEncoding = Charset.forName(RubyIconv.getCharset(from)).newDecoder();
            this.toEncoding = Charset.forName(RubyIconv.getCharset(to)).newEncoder();
            this.count = 0;
            if (RubyIconv.isIgnore(to)) {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.IGNORE);
                this.fromEncoding.onMalformedInput(CodingErrorAction.IGNORE);
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.IGNORE);
                this.toEncoding.onMalformedInput(CodingErrorAction.IGNORE);
            } else {
                this.fromEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
                this.fromEncoding.onMalformedInput(CodingErrorAction.REPORT);
                this.toEncoding.onUnmappableCharacter(CodingErrorAction.REPORT);
                this.toEncoding.onMalformedInput(CodingErrorAction.REPORT);
            }
        }
        catch (IllegalCharsetNameException e) {
            throw runtime.newInvalidEncoding("invalid encoding");
        }
        catch (UnsupportedCharsetException e) {
            throw runtime.newInvalidEncoding("invalid encoding");
        }
        catch (Exception e) {
            throw runtime.newSystemCallError(e.toString());
        }
        return this;
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() {
        if (this.toEncoding == null && this.fromEncoding == null) {
            return this.getRuntime().getNil();
        }
        this.toEncoding = null;
        this.fromEncoding = null;
        return RubyString.newEmptyString(this.getRuntime());
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str) {
        return this.iconv(str, 0, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str, IRubyObject startArg) {
        int start2 = 0;
        if (!startArg.isNil()) {
            start2 = RubyNumeric.fix2int(startArg);
        }
        return this.iconv(str, start2, -1);
    }

    @JRubyMethod
    public IRubyObject iconv(IRubyObject str, IRubyObject startArg, IRubyObject endArg) {
        int start2 = 0;
        int end2 = -1;
        if (!startArg.isNil()) {
            start2 = RubyNumeric.fix2int(startArg);
        }
        if (!endArg.isNil()) {
            end2 = RubyNumeric.fix2int(endArg);
        }
        return this.iconv(str, start2, end2);
    }

    private IRubyObject iconv(IRubyObject str, int start2, int end2) {
        if (str.isNil()) {
            this.fromEncoding.reset();
            this.toEncoding.reset();
            return RubyString.newEmptyString(this.getRuntime());
        }
        return this._iconv(str.convertToString(), start2, end2);
    }

    public IRubyObject iconv(IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return this.iconv(args2[0]);
            }
            case 2: {
                return this.iconv(args2[0], args2[1]);
            }
            case 3: {
                return this.iconv(args2[0], args2[1], args2[2]);
            }
        }
        Arity.raiseArgumentError(this.getRuntime(), args2.length, 1, 2);
        return null;
    }

    private IRubyObject _iconv(RubyString str, int start2, int length2) {
        if (this.fromEncoding == null) {
            throw this.getRuntime().newArgumentError("closed iconv");
        }
        ByteList bytes2 = str.getByteList();
        if (start2 < 0) {
            start2 += bytes2.length();
        }
        if (start2 < 0 || start2 > bytes2.length()) {
            return RubyString.newEmptyString(this.getRuntime());
        }
        if (length2 < 0 || length2 > bytes2.length() - start2) {
            length2 = bytes2.length() - start2;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes2.getUnsafeBytes(), bytes2.begin() + start2, length2);
        try {
            CharBuffer cbuf = this.fromEncoding.decode(buf);
            buf = this.toEncoding.encode(cbuf);
        }
        catch (MalformedInputException e) {
            throw this.getRuntime().newIllegalSequence(str.toString());
        }
        catch (UnmappableCharacterException e) {
            throw this.getRuntime().newIllegalSequence(str.toString());
        }
        catch (CharacterCodingException e) {
            throw this.getRuntime().newInvalidEncoding("invalid sequence");
        }
        catch (IllegalStateException e) {
            throw this.getRuntime().newIllegalSequence(str.toString());
        }
        byte[] arr = buf.array();
        start2 = 0;
        String displayName = this.toEncoding.charset().displayName();
        if (arr.length >= 2) {
            if (displayName.toLowerCase().startsWith("utf-16")) {
                if (arr[0] == -2 && arr[1] == -1) {
                    if (this.count > 0) {
                        start2 = 2;
                    }
                    this.endian = "BE";
                } else if (arr[0] == -1 && arr[1] == -2) {
                    if (this.count > 0) {
                        start2 = 2;
                    }
                    this.endian = "LE";
                }
            } else if (displayName.toLowerCase().startsWith("utf-32") && arr.length >= 4) {
                if (arr[0] == 0 && arr[1] == 0 && arr[2] == -2 && arr[3] == -1) {
                    if (this.count > 0) {
                        start2 = 4;
                    }
                    this.endian = "BE";
                } else if (arr[0] == -1 && arr[1] == -2 && arr[2] == 0 && arr[3] == 0) {
                    if (this.count > 0) {
                        start2 = 4;
                    }
                    this.endian = "LE";
                }
            }
        }
        ++this.count;
        if (displayName.equalsIgnoreCase("utf-16") || displayName.equalsIgnoreCase("utf-32")) {
            displayName = displayName + this.endian;
        }
        ByteList r = new ByteList(arr, start2, buf.limit() - start2);
        EncodingDB.Entry entry = (EncodingDB.Entry)EncodingDB.getEncodings().get(displayName.getBytes());
        if (entry != null) {
            Encoding charset = entry.getEncoding();
            r.setEncoding(charset);
        }
        return this.getRuntime().newString(r);
    }

    @JRubyMethod(name={"iconv"}, required=2, rest=true, meta=true)
    public static IRubyObject iconv(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyIconv.convertWithArgs(context, recv2, args2, "iconv");
    }

    @JRubyMethod(name={"conv"}, required=3, rest=true, meta=true)
    public static IRubyObject conv(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyIconv.convertWithArgs(context, recv2, args2, "conv").join(context, RubyString.newEmptyString(recv2.getRuntime()));
    }

    @JRubyMethod(name={"charset_map"}, meta=true)
    public static IRubyObject charset_map_get(IRubyObject recv2) {
        return recv2.getRuntime().getCharsetMap();
    }

    private static String mapCharset(ThreadContext context, IRubyObject val) {
        RubyString key2;
        IRubyObject tryVal;
        RubyHash charset = val.getRuntime().getCharsetMap();
        if (charset.size() > 0 && (tryVal = charset.fastARef(key2 = val.callMethod(context, "downcase").convertToString())) != null) {
            val = tryVal;
        }
        return val.convertToString().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyArray convertWithArgs(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, String function) {
        assert (args2.length >= 2);
        RubyArray array = context.runtime.newArray(args2.length - 2);
        RubyIconv iconv2 = RubyIconv.newIconv(context, recv2, args2[0], args2[1]);
        try {
            for (int i2 = 2; i2 < args2.length; ++i2) {
                array.append(iconv2.iconv(args2[i2]));
            }
        }
        finally {
            iconv2.close();
        }
        return array;
    }

    public static class RubyFailure
    extends RubyException {
        private IRubyObject success;
        private IRubyObject failed;
        protected static final ObjectAllocator ICONV_FAILURE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RubyFailure(runtime, klass);
            }
        };

        public static RubyFailure newInstance(Ruby runtime, RubyClass excptnClass, String msg) {
            return new RubyFailure(runtime, excptnClass, msg);
        }

        protected RubyFailure(Ruby runtime, RubyClass rubyClass) {
            this(runtime, rubyClass, null);
        }

        public RubyFailure(Ruby runtime, RubyClass rubyClass, String message2) {
            super(runtime, rubyClass, message2);
        }

        @Override
        @JRubyMethod(required=1, optional=2)
        public IRubyObject initialize(IRubyObject[] args2, Block block) {
            super.initialize(args2, block);
            this.success = args2.length >= 2 ? args2[1] : this.getRuntime().getNil();
            this.failed = args2.length == 3 ? args2[2] : this.getRuntime().getNil();
            return this;
        }

        @JRubyMethod(name={"success"})
        public IRubyObject success() {
            return this.success;
        }

        @JRubyMethod(name={"failed"})
        public IRubyObject failed() {
            return this.failed;
        }

        @Override
        @JRubyMethod(name={"inspect"})
        public IRubyObject inspect() {
            RubyClass rubyClass = this.getMetaClass();
            StringBuilder buffer = new StringBuilder("#<");
            buffer.append(rubyClass.getName()).append(": ").append(this.success.inspect().toString());
            buffer.append(", ").append(this.failed.inspect().toString()).append(">");
            return this.getRuntime().newString(buffer.toString());
        }
    }

    @JRubyClass(name={"Iconv::BrokenLibrary"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class BrokenLibrary {
    }

    @JRubyClass(name={"Iconv::OutOfRange"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class OutOfRange {
    }

    @JRubyClass(name={"Iconv::InvalidEncoding"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidEncoding {
    }

    @JRubyClass(name={"Iconv::InvalidCharacter"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class InvalidCharacter {
    }

    @JRubyClass(name={"Iconv::IllegalSequence"}, parent="ArgumentError", include={"Iconv::Failure"})
    public static class IllegalSequence {
    }

    @JRubyModule(name={"Iconv::Failure"})
    public static class Failure {
    }
}

