/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosureManager;
import java.util.Map;
import java.util.WeakHashMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.jffi.CallbackMemoryIO;
import org.jruby.ext.ffi.jffi.NativeCallbackFactory;
import org.jruby.ext.ffi.jffi.NativeCallbackPointer;
import org.jruby.ext.ffi.jffi.NativeClosureProxy;
import org.jruby.ext.ffi.jffi.NativeFunctionInfo;
import org.jruby.runtime.ObjectAllocator;

public class CallbackManager
extends org.jruby.ext.ffi.CallbackManager {
    private final Map<CallbackInfo, NativeCallbackFactory> factories = new WeakHashMap<CallbackInfo, NativeCallbackFactory>();

    public static final CallbackManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static RubyClass createCallbackClass(Ruby runtime, RubyModule module) {
        RubyClass cbClass = module.defineClassUnder("Callback", module.getClass("Pointer"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        cbClass.defineAnnotatedMethods(NativeCallbackPointer.class);
        cbClass.defineAnnotatedConstants(NativeCallbackPointer.class);
        return cbClass;
    }

    @Override
    public final Pointer getCallback(Ruby runtime, CallbackInfo cbInfo, Object proc2) {
        return proc2 instanceof RubyObject ? this.getCallbackFactory(runtime, cbInfo).getCallback((RubyObject)proc2) : this.getCallbackFactory(runtime, cbInfo).newCallback(proc2);
    }

    public final synchronized NativeCallbackFactory getCallbackFactory(Ruby runtime, CallbackInfo cbInfo) {
        NativeCallbackFactory factory = this.factories.get(cbInfo);
        if (factory == null) {
            factory = new NativeCallbackFactory(runtime, cbInfo);
            this.factories.put(cbInfo, factory);
        }
        return factory;
    }

    final CallbackMemoryIO newClosure(Ruby runtime, Type returnType, Type[] parameterTypes, Object proc2, CallingConvention convention) {
        NativeFunctionInfo info = new NativeFunctionInfo(runtime, returnType, parameterTypes, convention);
        NativeClosureProxy cbProxy = new NativeClosureProxy(runtime, info, proc2);
        Closure.Handle handle = ClosureManager.getInstance().newClosure((Closure)cbProxy, info.callContext);
        return new CallbackMemoryIO(runtime, handle, proc2);
    }

    private static final class SingletonHolder {
        static final CallbackManager INSTANCE = new CallbackManager();

        private SingletonHolder() {
        }
    }
}

