/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.RubyModule;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

public class StandardInvocationCompiler
implements InvocationCompiler {
    protected BaseBodyCompiler methodCompiler;
    protected SkinnyMethodAdapter method;

    public StandardInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        this.methodCompiler = methodCompiler;
        this.method = method2;
    }

    @Override
    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    @Override
    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    @Override
    public void invokeAttrAssignMasgn(String name2, CompilerCallback receiverCallback, final ArgumentsCallback argsCallback, boolean selfCall) {
        final int temp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(temp);
        ArgumentsCallback newArgumentsCallback = new ArgumentsCallback(){

            @Override
            public int getArity() {
                return argsCallback == null ? 1 : argsCallback.getArity() + 1;
            }

            @Override
            public void call(BodyCompiler context) {
                if (argsCallback != null) {
                    argsCallback.call(context);
                }
                StandardInvocationCompiler.this.methodCompiler.getVariableCompiler().getTempLocal(temp);
            }
        };
        this.invokeAttrAssign(name2, receiverCallback, newArgumentsCallback, selfCall, false);
    }

    @Override
    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, boolean isSelf, boolean expr) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, isSelf ? CallType.FUNCTIONAL : CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        argsCallback.call(this.methodCompiler);
        int tmp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                if (!expr) break;
                this.method.dup();
                this.methodCompiler.invokeUtilityMethod("lastElement", CodegenUtils.sig(IRubyObject.class, IRubyObject[].class));
                this.method.astore(tmp);
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", signature);
        this.method.pop();
        if (expr) {
            this.method.aload(tmp);
        }
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    @Override
    public void opElementAsgnWithOr(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifne(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    @Override
    public void opElementAsgnWithAnd(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifeq(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    @Override
    public void opElementAsgnWithMethod(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback, String operator) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operator, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
            }
        }
    }

    @Override
    public void invokeBinaryFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.ldc(fixnum);
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Long.TYPE));
        String callSiteMethod = "call";
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    @Override
    public void invokeBinaryBooleanFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        this.invokeBinaryFixnumRHS(name2, receiverCallback, fixnum);
        this.methodCompiler.isTrue();
    }

    @Override
    public void invokeBinaryFloatRHS(String name2, CompilerCallback receiverCallback, double flote) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.ldc(flote);
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Double.TYPE));
        String callSiteMethod = "call";
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    @Override
    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, callType);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (callType == CallType.SUPER && closureArg == null) {
            closureArg = new CompilerCallback(){

                @Override
                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.methodCompiler.loadBlock();
                }
            };
        }
        String callSiteMethod = "call";
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    @Override
    public void invokeDynamicVarargs(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        assert (argsCallback.getArity() == -1);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, callType);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (callType == CallType.SUPER && closureArg == null) {
            closureArg = new CompilerCallback(){

                @Override
                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.methodCompiler.loadBlock();
                }
            };
        }
        String callSiteMethod = "callVarargs";
        argsCallback.call(this.methodCompiler);
        if (closureArg == null) {
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        } else {
            if (iterator) {
                callSiteMethod = "callVarargsIter";
            }
            closureArg.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    @Override
    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne(isTrue);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isTrue);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    @Override
    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isFalse = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifeq(isFalse);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isFalse);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    @Override
    public void invokeOpAsgnWithMethod(String operatorName, String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    @Override
    public void yield(CompilerCallback argsCallback, boolean unwrap) {
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        } else {
            this.method.aconst_null();
        }
        if (unwrap) {
            this.method.aconst_null();
            this.method.aconst_null();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldArray", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class));
        } else {
            this.method.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
    }

    @Override
    public void yield19(CompilerCallback argsCallback, boolean unsplat) {
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadNil();
        }
        if (unsplat) {
            this.methodCompiler.loadBlock();
            this.methodCompiler.invokeUtilityMethod("unsplatValue19IfArityOne", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Block.class));
        }
        this.method.aconst_null();
        this.method.aconst_null();
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldArray", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class));
    }

    @Override
    public void yieldSpecific(ArgumentsCallback argsCallback) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class);
        } else {
            argsCallback.call(this.methodCompiler);
            switch (argsCallback.getArity()) {
                case 1: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                default: {
                    throw new NotCompilableException("Can't do specific-arity call for > 3 args yet");
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldSpecific", signature);
    }

    @Override
    public void invokeEqq(ArgumentsCallback receivers, CompilerCallback argument) {
        if (argument == null) {
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject[].class));
                    break;
                }
            }
        } else {
            this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "===", CallType.NORMAL);
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.loadSelf();
            argument.call(this.methodCompiler);
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                }
            }
        }
    }
}

