/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.UnsupportedAddressTypeException;
import jnr.constants.platform.AddressFamily;
import jnr.netdb.Service;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"UDPSocket"}, parent="IPSocket")
public class RubyUDPSocket
extends RubyIPSocket {
    public static final double RECV_BUFFER_COPY_SCALE = 1.5;
    private volatile Class<? extends InetAddress> explicitFamily;
    private volatile ProtocolFamily family;

    static void createUDPSocket(Ruby runtime2) {
        RubyClass rb_cUDPSocket = runtime2.defineClass("UDPSocket", runtime2.getClass("IPSocket"), RubyUDPSocket::new);
        rb_cUDPSocket.includeModule(runtime2.getClass("Socket").getConstant("Constants"));
        rb_cUDPSocket.defineAnnotatedMethods(RubyUDPSocket.class);
        runtime2.getObject().setConstant("UDPsocket", rb_cUDPSocket);
    }

    public RubyUDPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        return this.initialize(context, StandardProtocolFamily.INET);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject _family) {
        AddressFamily family2 = SocketUtils.addressFamilyFromArg(_family);
        if (family2 == AddressFamily.AF_INET) {
            this.explicitFamily = Inet4Address.class;
            return this.initialize(context, StandardProtocolFamily.INET);
        }
        if (family2 == AddressFamily.AF_INET6) {
            this.explicitFamily = Inet6Address.class;
            return this.initialize(context, StandardProtocolFamily.INET6);
        }
        throw context.runtime.newErrnoEAFNOSUPPORTError("invalid family for UDPSocket: " + _family);
    }

    public IRubyObject initialize(ThreadContext context, ProtocolFamily family2) {
        Ruby runtime2 = context.runtime;
        try {
            this.family = family2;
            DatagramChannel channel = DatagramChannel.open(family2);
            this.initSocket(RubyUDPSocket.newChannelFD(runtime2, channel));
        }
        catch (ConnectException e) {
            throw runtime2.newErrnoECONNREFUSEDError();
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "initialize: name or service not known");
        }
        catch (UnsupportedOperationException uoe) {
            if (uoe.getMessage().contains("IPv6 not available")) {
                throw runtime2.newErrnoEAFNOSUPPORTError("socket(2) - udp");
            }
            throw RubyUDPSocket.sockerr(runtime2, "UnsupportedOperationException: " + uoe.getLocalizedMessage(), uoe);
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(runtime2, "initialize: name or service not known", e);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject host, IRubyObject _port) {
        Ruby runtime2 = context.runtime;
        int port = SocketUtils.portToInt(_port);
        try {
            InetSocketAddress addr2;
            Channel channel = this.getChannel();
            if (host.isNil() || host instanceof RubyString && ((RubyString)host).isEmpty()) {
                addr2 = new InetSocketAddress(port);
            } else if (host instanceof RubyFixnum) {
                int intAddr;
                if (host instanceof RubyInteger) {
                    intAddr = RubyNumeric.fix2int(host);
                } else if (host instanceof RubyString) {
                    intAddr = ((RubyString)host).to_i().convertToInteger().getIntValue();
                } else {
                    throw runtime2.newTypeError(host, runtime2.getInteger());
                }
                RubyModule Socket2 = runtime2.getModule("Socket");
                if (intAddr == RubyNumeric.fix2int(Socket2.getConstant("INADDR_ANY"))) {
                    addr2 = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port);
                } else {
                    if (this.multicastStateManager == null) {
                        throw runtime2.newNotImplementedError("bind with host: " + intAddr);
                    }
                    addr2 = null;
                }
            } else {
                addr2 = new InetSocketAddress(InetAddress.getByName(host.convertToString().toString()), port);
            }
            if (this.multicastStateManager == null) {
                ((DatagramChannel)channel).bind(addr2);
            } else {
                this.multicastStateManager.rebindToPort(port);
            }
            return RubyFixnum.zero(runtime2);
        }
        catch (UnsupportedAddressTypeException e) {
            ProtocolFamily family2 = this.family == null ? StandardProtocolFamily.INET : this.family;
            throw SocketUtils.sockerr(runtime2, "bind: unsupported address " + host.inspect() + " for protocol family " + family2);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "bind: name or service not known");
        }
        catch (BindException e) {
            throw runtime2.newErrnoFromBindException(e, RubyUDPSocket.bindContextMessage(host, port));
        }
        catch (AlreadyBoundException e) {
            throw runtime2.newErrnoEINVALError(RubyUDPSocket.bindContextMessage(host, port));
        }
        catch (SocketException e) {
            String message2 = e.getMessage();
            if (message2 != null) {
                switch (message2) {
                    case "Permission denied": {
                        throw runtime2.newErrnoEACCESError(RubyUDPSocket.bindContextMessage(host, port));
                    }
                }
            }
            throw RubyUDPSocket.sockerr(runtime2, "bind: name or service not known", e);
        }
        catch (IOException e) {
            throw RubyUDPSocket.sockerr(runtime2, "bind: name or service not known", e);
        }
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject _host, IRubyObject port) {
        Ruby runtime2 = context.runtime;
        try {
            String host = _host.isNil() ? "localhost" : _host.convertToString().toString();
            InetAddress[] addrs = InetAddress.getAllByName(host);
            for (int i2 = 0; i2 < addrs.length; ++i2) {
                InetAddress a = addrs[i2];
                if (this.explicitFamily != null && !this.explicitFamily.isInstance(a)) continue;
                try {
                    InetSocketAddress addr2 = new InetSocketAddress(addrs[i2], SocketUtils.portToInt(port));
                    ((DatagramChannel)this.getChannel()).connect(addr2);
                    return RubyFixnum.zero(runtime2);
                }
                catch (NoRouteToHostException nrthe) {
                    if (i2 + 1 < addrs.length) continue;
                    throw nrthe;
                }
            }
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "connect: name or service not known");
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (IllegalArgumentException e) {
            throw SocketUtils.sockerr(runtime2, e.getLocalizedMessage());
        }
        return context.nil;
    }

    private DatagramChannel getDatagramChannel() {
        return (DatagramChannel)this.getChannel();
    }

    @JRubyMethod(required=1, optional=3)
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 4);
        return RubyUDPSocket.recvfrom_nonblock(this, context, args2);
    }

    public static IRubyObject recvfrom_nonblock(RubyBasicSocket socket2, ThreadContext context, IRubyObject[] args2) {
        IRubyObject str;
        int argc = args2.length;
        boolean exception2 = true;
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, args2);
        if (opts != context.nil) {
            --argc;
            exception2 = Helpers.extractExceptionOnlyArg(context, (RubyHash)opts);
        }
        IRubyObject flags2 = str = context.nil;
        IRubyObject length2 = str;
        switch (argc) {
            case 3: {
                str = args2[2];
            }
            case 2: {
                flags2 = args2[1];
            }
            case 1: {
                length2 = args2[0];
            }
        }
        return RubyUDPSocket.recvfrom_nonblock(socket2, context, length2, flags2, str, exception2);
    }

    private static IRubyObject recvfrom_nonblock(RubyBasicSocket socket2, ThreadContext context, IRubyObject length2, IRubyObject flags2, IRubyObject str, boolean exception2) {
        Ruby runtime2 = context.runtime;
        try {
            RubyBasicSocket.ReceiveTuple tuple = RubyUDPSocket.doReceiveNonblockTuple(socket2, runtime2, RubyNumeric.fix2int(length2));
            if (tuple == null) {
                if (!exception2) {
                    return context.runtime.newSymbol("wait_readable");
                }
                throw context.runtime.newErrnoEAGAINReadableError("recvfrom(2)");
            }
            if (str != null && !str.isNil()) {
                str = str.convertToString();
                ((RubyString)str).setValue(tuple.result.getByteList());
            } else {
                str = tuple.result;
            }
            IRubyObject addressArray = socket2.addrFor(context, tuple.sender, false);
            return runtime2.newArray(str, addressArray);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "recvfrom: name or service not known");
        }
        catch (PortUnreachableException e) {
            throw runtime2.newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw RubyUDPSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
    }

    @Override
    @JRubyMethod
    public IRubyObject send(ThreadContext context, IRubyObject _mesg, IRubyObject _flags) {
        Ruby runtime2 = context.runtime;
        try {
            RubyString data2 = _mesg.convertToString();
            ByteList dataBL = data2.getByteList();
            ByteBuffer buf = ByteBuffer.wrap(dataBL.unsafeBytes(), dataBL.begin(), dataBL.realSize());
            int written = ((DatagramChannel)this.getChannel()).write(buf);
            return runtime2.newFixnum(written);
        }
        catch (NotYetConnectedException e) {
            throw runtime2.newErrnoEDESTADDRREQError("send(2)");
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "send: name or service not known");
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw RubyUDPSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
    }

    @JRubyMethod(required=2, optional=2)
    public IRubyObject send(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 4);
        Ruby runtime2 = context.runtime;
        IRubyObject _mesg = args2[0];
        IRubyObject _flags = args2[1];
        try {
            int port;
            InetAddress[] addrs;
            if (argc == 2) {
                return this.send(context, _mesg, _flags);
            }
            if (argc == 3) {
                InetSocketAddress sockAddress;
                IRubyObject sockaddr = args2[2];
                if (sockaddr instanceof Addrinfo) {
                    sockAddress = ((Addrinfo)sockaddr).getInetSocketAddress();
                    if (sockAddress == null) {
                        throw SocketUtils.sockerr(runtime2, "need AF_INET or AF_INET6 address");
                    }
                } else {
                    sockAddress = Sockaddr.addressFromSockaddr_in(context, sockaddr);
                }
                addrs = new InetAddress[]{sockAddress.getAddress()};
                port = sockAddress.getPort();
            } else {
                Service service;
                IRubyObject _host = args2[2];
                IRubyObject _port = args2[3];
                RubyString nameStr = _host.convertToString();
                port = _port instanceof RubyString ? ((service = Service.getServiceByName((String)_port.asJavaString(), (String)"udp")) != null ? service.getPort() : (int)_port.convertToInteger("to_i").getLongValue()) : (int)_port.convertToInteger().getLongValue();
                addrs = SocketUtils.getRubyInetAddresses(nameStr.toString());
            }
            RubyString data2 = _mesg.convertToString();
            ByteBuffer buf = ByteBuffer.wrap(data2.getBytes());
            byte[] buf2 = data2.getBytes();
            for (int i2 = 0; i2 < addrs.length; ++i2) {
                InetAddress inetAddress = addrs[i2];
                InetSocketAddress addr2 = new InetSocketAddress(inetAddress, port);
                try {
                    int written;
                    if (this.multicastStateManager == null) {
                        written = ((DatagramChannel)this.getChannel()).send(buf, addr2);
                    } else {
                        DatagramPacket sendDP = new DatagramPacket(buf2, buf2.length, addr2);
                        this.multicastStateManager.rebindToPort(addr2.getPort());
                        MulticastSocket ms = this.multicastStateManager.getMulticastSocket();
                        ms.send(sendDP);
                        written = sendDP.getLength();
                    }
                    return runtime2.newFixnum(written);
                }
                catch (NoRouteToHostException nrthe) {
                    if (i2 + 1 < addrs.length) continue;
                    throw nrthe;
                }
            }
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "send: name or service not known");
        }
        catch (IOException e) {
            String message2 = e.getMessage();
            if (message2 != null) {
                switch (message2) {
                    case "Message too large": 
                    case "Message too long": {
                        throw runtime2.newErrnoEMSGSIZEError();
                    }
                }
            }
            throw runtime2.newIOErrorFromException(e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw RubyUDPSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyUDPSocket sock = (RubyUDPSocket)recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return sock;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, sock);
            return iRubyObject;
        }
        finally {
            if (sock.openFile.isOpen()) {
                sock.close();
            }
        }
    }

    @Override
    public IRubyObject recvfrom(ThreadContext context, IRubyObject length2) {
        return RubyUDPSocket.recvfrom(this, context, length2);
    }

    public static IRubyObject recvfrom(RubyBasicSocket socket2, ThreadContext context, IRubyObject length2) {
        Ruby runtime2 = context.runtime;
        try {
            RubyBasicSocket.ReceiveTuple tuple = RubyUDPSocket.doReceiveTuple(socket2, runtime2, false, RubyNumeric.fix2int(length2));
            IRubyObject addressArray = socket2.addrFor(context, tuple.sender, false);
            return runtime2.newArray((IRubyObject)tuple.result, addressArray);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "recvfrom: name or service not known");
        }
        catch (PortUnreachableException e) {
            throw runtime2.newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw RubyUDPSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @Override
    public IRubyObject recv(ThreadContext context, IRubyObject length2) {
        Ruby runtime2 = context.runtime;
        try {
            return RubyUDPSocket.doReceive(this, runtime2, false, RubyNumeric.fix2int(length2), null);
        }
        catch (PortUnreachableException e) {
            throw runtime2.newErrnoECONNREFUSEDError();
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            throw RubyUDPSocket.sockerr(runtime2, e.getLocalizedMessage(), e);
        }
    }

    private static RubyBasicSocket.ReceiveTuple doReceiveTuple(RubyBasicSocket socket2, Ruby runtime2, boolean non_block, int length2) throws IOException {
        RubyBasicSocket.ReceiveTuple tuple = new RubyBasicSocket.ReceiveTuple();
        IRubyObject result2 = socket2.multicastStateManager == null ? RubyUDPSocket.doReceive(socket2, runtime2, non_block, length2, tuple) : RubyUDPSocket.doReceiveMulticast(socket2, runtime2, non_block, length2, tuple);
        return result2 == null ? null : tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RubyBasicSocket.ReceiveTuple doReceiveNonblockTuple(RubyBasicSocket socket2, Ruby runtime2, int length2) throws IOException {
        DatagramChannel channel = (DatagramChannel)socket2.getChannel();
        Object object = channel.blockingLock();
        synchronized (object) {
            RubyBasicSocket.ReceiveTuple receiveTuple;
            boolean oldBlocking = channel.isBlocking();
            channel.configureBlocking(false);
            try {
                receiveTuple = RubyUDPSocket.doReceiveTuple(socket2, runtime2, true, length2);
            }
            catch (Throwable throwable) {
                channel.configureBlocking(oldBlocking);
                throw throwable;
            }
            channel.configureBlocking(oldBlocking);
            return receiveTuple;
        }
    }

    private static IRubyObject doReceive(RubyBasicSocket socket2, Ruby runtime2, boolean non_block, int length2) throws IOException {
        return RubyUDPSocket.doReceive(socket2, runtime2, non_block, length2, null);
    }

    protected static IRubyObject doReceive(RubyBasicSocket socket2, Ruby runtime2, boolean non_block, int length2, RubyBasicSocket.ReceiveTuple tuple) throws IOException {
        ByteBuffer buf;
        DatagramChannel channel = (DatagramChannel)socket2.getChannel();
        InetSocketAddress sender = (InetSocketAddress)channel.receive(buf = ByteBuffer.allocate(length2));
        if (sender == null) {
            if (non_block) {
                return null;
            }
            throw runtime2.newErrnoECONNRESETError();
        }
        ByteList bl = new ByteList(buf.array(), 0, buf.position(), (double)buf.limit() > (double)buf.position() * 1.5);
        RubyString result2 = runtime2.newString(bl);
        if (tuple != null) {
            tuple.result = result2;
            tuple.sender = sender;
        }
        return result2;
    }

    private static IRubyObject doReceiveMulticast(RubyBasicSocket socket2, Ruby runtime2, boolean non_block, int length2, RubyBasicSocket.ReceiveTuple tuple) throws IOException {
        DatagramPacket recv2 = new DatagramPacket(new byte[length2], length2);
        try {
            socket2.multicastStateManager.getMulticastSocket().receive(recv2);
        }
        catch (IllegalBlockingModeException e) {
            if (non_block) {
                return null;
            }
            throw runtime2.newErrnoEAGAINReadableError("multicast UDP does not support nonblocking");
        }
        InetSocketAddress sender = (InetSocketAddress)recv2.getSocketAddress();
        if (sender == null) {
            throw runtime2.newErrnoECONNRESETError();
        }
        RubyString result2 = runtime2.newString(new ByteList(recv2.getData(), recv2.getOffset(), recv2.getLength(), false));
        if (tuple != null) {
            tuple.result = result2;
            tuple.sender = sender;
        }
        return result2;
    }

    @Deprecated
    public IRubyObject bind(IRubyObject host, IRubyObject port) {
        return this.bind(this.getRuntime().getCurrentContext(), host, port);
    }

    @Deprecated
    public IRubyObject connect(IRubyObject host, IRubyObject port) {
        return this.connect(this.getRuntime().getCurrentContext(), host, port);
    }

    @Deprecated
    public IRubyObject recvfrom(IRubyObject[] args2) {
        return this.recvfrom(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public IRubyObject send(IRubyObject[] args2) {
        return this.send(this.getRuntime().getCurrentContext(), args2);
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyUDPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }
}

