/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import jnr.constants.Constant;
import jnr.constants.platform.AddressFamily;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyTCPSocket
extends RubyIPSocket {
    static void createTCPSocket(Ruby runtime2) {
        RubyClass rb_cTCPSocket = runtime2.defineClass("TCPSocket", runtime2.getClass("IPSocket"), RubyTCPSocket::new);
        rb_cTCPSocket.defineAnnotatedMethods(RubyTCPSocket.class);
        runtime2.getObject().setConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    private SocketChannel attemptConnect(ThreadContext context, IRubyObject host, String localHost, int localPort, String remoteHost, int remotePort, RubyHash opts) throws IOException {
        for (InetAddress address2 : InetAddress.getAllByName(remoteHost)) {
            SocketChannel channel = SocketChannel.open();
            this.openFile = null;
            this.initSocket(RubyTCPSocket.newChannelFD(context.runtime, channel));
            channel.configureBlocking(false);
            if (localHost != null) {
                channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                channel.bind(new InetSocketAddress(InetAddress.getByName(localHost), localPort));
            }
            try {
                IRubyObject timeoutObj;
                channel.connect(new InetSocketAddress(address2, remotePort));
                long timeout2 = -1L;
                if (opts != null && !(timeoutObj = ArgsUtil.extractKeywordArg(context, opts, "connect_timeout")).isNil()) {
                    timeout2 = (long)(timeoutObj.convertToFloat().getDoubleValue() * 1000.0);
                }
                if (context.getThread().select((Channel)channel, this, 8, timeout2)) {
                    while (!channel.finishConnect()) {
                        context.pollThreadEvents();
                    }
                    channel.configureBlocking(true);
                    return channel;
                }
                throw context.runtime.newErrnoETIMEDOUTError();
            }
            catch (ConnectException connectException) {
            }
        }
        throw context.runtime.newErrnoECONNREFUSEDError("connect(2) for " + host.inspect() + " port " + remotePort);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject host, IRubyObject port) {
        String remoteHost = host.isNil() ? "localhost" : host.convertToString().toString();
        int remotePort = SocketUtils.getPortFrom(context, port);
        return this.initialize(context, remoteHost, remotePort, host, null, 0, null);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject host, IRubyObject port, IRubyObject localOrOpts) {
        String remoteHost = host.isNil() ? "localhost" : host.convertToString().toString();
        int remotePort = SocketUtils.getPortFrom(context, port);
        IRubyObject opts = ArgsUtil.getOptionsArg(context.runtime, localOrOpts);
        if (!opts.isNil()) {
            return this.initialize(context, remoteHost, remotePort, host, null, 0, (RubyHash)opts);
        }
        String localHost = localOrOpts.isNil() ? null : localOrOpts.convertToString().toString();
        return this.initialize(context, remoteHost, remotePort, host, localHost, 0, null);
    }

    @JRubyMethod(required=2, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 5);
        String localHost = null;
        int localPort = 0;
        RubyHash opts = null;
        switch (argc) {
            case 2: {
                return this.initialize(context, args2[0], args2[1]);
            }
            case 3: {
                return this.initialize(context, args2[0], args2[1], args2[2]);
            }
        }
        IRubyObject host = args2[0];
        IRubyObject port = args2[1];
        String remoteHost = host.isNil() ? "localhost" : host.convertToString().toString();
        int remotePort = SocketUtils.getPortFrom(context, port);
        switch (argc) {
            case 4: {
                IRubyObject maybeOpts;
                if (!args2[2].isNil()) {
                    localHost = args2[2].convertToString().toString();
                }
                if (!(maybeOpts = ArgsUtil.getOptionsArg(context.runtime, args2[3])).isNil()) {
                    opts = (RubyHash)maybeOpts;
                    break;
                }
                if (args2[3].isNil()) break;
                localPort = SocketUtils.getPortFrom(context, args2[3]);
                break;
            }
            case 5: {
                if (args2[4].isNil()) break;
                opts = (RubyHash)ArgsUtil.getOptionsArg(context.runtime, args2[4], true);
            }
        }
        return this.initialize(context, remoteHost, remotePort, host, localHost, localPort, opts);
    }

    public IRubyObject initialize(ThreadContext context, String remoteHost, int remotePort, IRubyObject host, String localHost, int localPort, RubyHash opts) {
        Ruby runtime2 = context.runtime;
        boolean success = false;
        AbstractInterruptibleChannel channel = null;
        try {
            try {
                channel = this.attemptConnect(context, host, localHost, localPort, remoteHost, remotePort, opts);
                success = true;
            }
            catch (BindException e) {
                throw runtime2.newErrnoEADDRFromBindException(e, " to: " + remoteHost + ':' + remotePort);
            }
            catch (NoRouteToHostException e) {
                throw runtime2.newErrnoEHOSTUNREACHError("SocketChannel.connect");
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime2, "initialize: name or service not known");
            }
        }
        catch (ClosedChannelException e) {
            throw runtime2.newErrnoECONNREFUSEDError();
        }
        catch (BindException e) {
            throw runtime2.newErrnoEADDRFromBindException(e, " on: " + localHost + ':' + localPort);
        }
        catch (IOException e) {
            throw runtime2.newIOErrorFromException(e);
        }
        catch (IllegalArgumentException e) {
            throw RubyTCPSocket.sockerr(runtime2, e.getMessage(), e);
        }
        finally {
            if (!success && channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        Ruby runtime2 = context.runtime;
        String hostString = hostname.convertToString().toString();
        try {
            InetAddress addr2 = InetAddress.getByName(hostString);
            RubyString ret0 = runtime2.newString(RubyTCPSocket.do_not_reverse_lookup(context, recv2).isTrue() ? addr2.getHostAddress() : addr2.getCanonicalHostName());
            RubyArray ret1 = runtime2.newArray();
            RubyFixnum ret2 = addr2 instanceof Inet4Address ? runtime2.newFixnum((Constant)AddressFamily.AF_INET) : runtime2.newFixnum((Constant)AddressFamily.AF_INET6);
            RubyString ret3 = runtime2.newString(addr2.getHostAddress());
            return RubyArray.newArray(runtime2, ret0, ret1, ret2, ret3);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime2, "gethostbyname: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubyTCPSocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }
}

