package org.jresearch.gwt.time.apt.data.client;

import static org.jresearch.gwt.time.apt.base.Chrono.*;
import static org.jresearch.gwt.time.apt.data.client.PatternCoordinates.*;

import java.lang.String;
import java.util.HashMap;
import java.util.Map;

public class PatternInfoShort {
	public static final Map<String, PatternCoordinates[]> DATE_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_PATTERNS = new HashMap<>();

	static {
		DATE_PATTERNS.put("dd.MM.yy", new PatternCoordinates[] {
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "cs"),
				of(ISO, "de"),
				of(ISO, "et"),
				of(ISO, "fo"),
				of(ISO, "fr-CH"),
				of(ISO, "gsw"),
				of(ISO, "hy"),
				of(ISO, "it-CH"),
				of(ISO, "ka"),
				of(ISO, "kk"),
				of(ISO, "lb"),
				of(ISO, "lv"),
				of(ISO, "os"),
				of(ISO, "prg"),
				of(ISO, "uk"),
				});
		DATE_PATTERNS.put("M/d/yy", new PatternCoordinates[] {
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "cic"),
				of(ISO, "ee"),
				of(ISO, "en"),
				of(ISO, "fil"),
				of(ISO, "gaa"),
				of(ISO, "ks"),
				of(ISO, "lkt"),
				of(ISO, "mus"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "sd-Deva"),
				of(ISO, "xh"),
				of(ISO, "zu"),
				});
		DATE_PATTERNS.put("y-MM-dd", new PatternCoordinates[] {
				of(ISO, "af"),
				of(ISO, "bo"),
				of(ISO, "ckb"),
				of(ISO, "dz"),
				of(ISO, "en-CA"),
				of(ISO, "en-SE"),
				of(ISO, "fr-CA"),
				of(ISO, "ii"),
				of(ISO, "jgo"),
				of(ISO, "kl"),
				of(ISO, "lt"),
				of(ISO, "mg"),
				of(ISO, "mgo"),
				of(ISO, "mic"),
				of(ISO, "nso"),
				of(ISO, ""),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "sv"),
				of(ISO, "trv"),
				of(ISO, "ug"),
				of(ISO, "vo"),
				});
		DATE_PATTERNS.put("d-M-y", new PatternCoordinates[] {
				of(ISO, "as"),
				of(ISO, "ff-Adlm"),
				of(ISO, "mni-Mtei"),
				});
		DATE_PATTERNS.put("d M y G", new PatternCoordinates[] {
				of(ISO, "la"),
				});
		DATE_PATTERNS.put("d/MM/yy", new PatternCoordinates[] {
				of(ISO, "es-CO"),
				of(ISO, "es-GT"),
				of(ISO, "es-PE"),
				of(ISO, "fr-BE"),
				of(ISO, "ms"),
				of(ISO, "ms-Arab"),
				of(ISO, "oc"),
				of(ISO, "oc-ES"),
				});
		DATE_PATTERNS.put("d. M. yy", new PatternCoordinates[] {
				of(ISO, "sl"),
				});
		DATE_PATTERNS.put("yy/M/d", new PatternCoordinates[] {
				of(ISO, "eu"),
				of(ISO, "ne"),
				of(ISO, "sah"),
				});
		DATE_PATTERNS.put("dd-MM-y", new PatternCoordinates[] {
				of(ISO, "brx"),
				of(ISO, "ia"),
				of(ISO, "jv"),
				of(ISO, "mi"),
				of(ISO, "nl"),
				of(ISO, "pap"),
				of(ISO, "wo"),
				});
		DATE_PATTERNS.put("yy-MM-dd", new PatternCoordinates[] {
				of(ISO, "eo"),
				});
		DATE_PATTERNS.put("d/MM/y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ms-Arab"),
				of(JAPANESE, "ms-Arab"),
				});
		DATE_PATTERNS.put("M.d.y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "en-CH"),
				});
		DATE_PATTERNS.put("GGGGG y.MM.dd.", new PatternCoordinates[] {
				of(JAPANESE, "hu"),
				});
		DATE_PATTERNS.put("d-MM-y", new PatternCoordinates[] {
				of(ISO, "syr"),
				});
		DATE_PATTERNS.put("dd.MM.y", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(ISO, "cv"),
				of(ISO, "da"),
				of(ISO, "en-CH"),
				of(ISO, "ku"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "ro"),
				of(ISO, "ru"),
				of(ISO, "se-FI"),
				of(ISO, "szl"),
				of(ISO, "tk"),
				of(ISO, "tt"),
				});
		DATE_PATTERNS.put("d.M.y", new PatternCoordinates[] {
				of(ISO, "fi"),
				of(THAI_BUDDHIST, "gsw"),
				of(ISO, "he"),
				of(ISO, "is"),
				of(ISO, "smn"),
				});
		DATE_PATTERNS.put("d/M/y", new PatternCoordinates[] {
				of(ISO, "agq"),
				of(ISO, "bas"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(JAPANESE, "da"),
				of(ISO, "dje"),
				of(ISO, "dua"),
				of(ISO, "dyo"),
				of(ISO, "en-HK"),
				of(ISO, "en-ZW"),
				of(ISO, "es-US"),
				of(ISO, "ewo"),
				of(ISO, "ff"),
				of(ISO, "kab"),
				of(ISO, "khq"),
				of(ISO, "ksf"),
				of(ISO, "ln"),
				of(ISO, "lo"),
				of(ISO, "lu"),
				of(ISO, "mfe"),
				of(ISO, "mua"),
				of(ISO, "nmg"),
				of(ISO, "rn"),
				of(ISO, "seh"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "shi"),
				of(ISO, "shi-Latn"),
				of(ISO, "twq"),
				of(ISO, "yav"),
				of(ISO, "yo"),
				of(ISO, "zgh"),
				of(ISO, "zh-Hant-HK"),
				});
		DATE_PATTERNS.put("M/d/y", new PatternCoordinates[] {
				of(ISO, "blo"),
				});
		DATE_PATTERNS.put("dd-MM-yy GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				});
		DATE_PATTERNS.put("d.M.yy.", new PatternCoordinates[] {
				of(ISO, "bs-Cyrl"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				});
		DATE_PATTERNS.put("Gy-MM-dd", new PatternCoordinates[] {
				of(JAPANESE, "zh"),
				});
		DATE_PATTERNS.put("yy. M. d.", new PatternCoordinates[] {
				of(ISO, "ko"),
				});
		DATE_PATTERNS.put("d.MM.y", new PatternCoordinates[] {
				of(ISO, "pl"),
				of(ISO, "tr"),
				});
		DATE_PATTERNS.put("d-M-y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "ff-Adlm"),
				});
		DATE_PATTERNS.put("dd/MM/y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ca"),
				of(MINGUO, "ca"),
				});
		DATE_PATTERNS.put("d-M-yy", new PatternCoordinates[] {
				of(ISO, "dv"),
				of(ISO, "en-MV"),
				of(ISO, "kok"),
				});
		DATE_PATTERNS.put("Gyy/M/d", new PatternCoordinates[] {
				of(MINGUO, "yue-Hans"),
				});
		DATE_PATTERNS.put("d/M/yy", new PatternCoordinates[] {
				of(ISO, "an"),
				of(ISO, "ast"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bn"),
				of(ISO, "ca"),
				of(ISO, "ccp"),
				of(ISO, "doi"),
				of(ISO, "el"),
				of(JAPANESE, "el"),
				of(ISO, "en-AU"),
				of(ISO, "en-JM"),
				of(ISO, "en-SG"),
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "gu"),
				of(ISO, "ha"),
				of(ISO, "haw"),
				of(ISO, "hi"),
				of(ISO, "ig"),
				of(ISO, "km"),
				of(ISO, "kn"),
				of(ISO, "ks-Deva"),
				of(ISO, "kxv"),
				of(ISO, "ky"),
				of(ISO, "mai"),
				of(ISO, "ml"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "my"),
				of(ISO, "pa"),
				of(ISO, "qu"),
				of(ISO, "sa"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "su"),
				of(ISO, "ta"),
				of(THAI_BUDDHIST, "th"),
				of(ISO, "th"),
				of(ISO, "to"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "vi"),
				of(ISO, "xnr"),
				of(ISO, "zh-Hans-HK"),
				of(ISO, "zh-Hans-MO"),
				});
		DATE_PATTERNS.put("y/M/d", new PatternCoordinates[] {
				of(ISO, "fa"),
				of(ISO, "ps"),
				of(ISO, "uz-Arab"),
				of(ISO, "yue"),
				of(ISO, "yue-Hans"),
				of(ISO, "zh"),
				of(ISO, "zh-Hant"),
				});
		DATE_PATTERNS.put("y. MM. dd.", new PatternCoordinates[] {
				of(ISO, "hu"),
				});
		DATE_PATTERNS.put("dd/MM/y", new PatternCoordinates[] {
				of(ISO, "am"),
				of(ISO, "asa"),
				of(ISO, "bem"),
				of(ISO, "bez"),
				of(ISO, "br"),
				of(ISO, "cgg"),
				of(ISO, "co"),
				of(ISO, "dav"),
				of(ISO, "ebu"),
				of(ISO, "en-001"),
				of(ISO, "en-AE"),
				of(ISO, "en-GB"),
				of(ISO, "en-NZ"),
				of(ISO, "fr"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "guz"),
				of(ISO, "hi-Latn"),
				of(ISO, "jmc"),
				of(ISO, "kam"),
				of(ISO, "kde"),
				of(ISO, "kea"),
				of(ISO, "kgp"),
				of(ISO, "ki"),
				of(ISO, "kln"),
				of(ISO, "ksb"),
				of(ISO, "kw"),
				of(ISO, "lag"),
				of(ISO, "lg"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mgh"),
				of(ISO, "mt"),
				of(ISO, "naq"),
				of(ISO, "nd"),
				of(ISO, "nyn"),
				of(ISO, "pa-Arab"),
				of(ISO, "pcm"),
				of(ISO, "pt"),
				of(ISO, "rif"),
				of(ISO, "rof"),
				of(ISO, "rwk"),
				of(ISO, "saq"),
				of(ISO, "sbp"),
				of(ISO, "sc"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "teo"),
				of(ISO, "tzm"),
				of(ISO, "vai"),
				of(ISO, "vai-Latn"),
				of(ISO, "vun"),
				of(ISO, "xog"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				});
		DATE_PATTERNS.put("d.M y G", new PatternCoordinates[] {
				of(JAPANESE, "no"),
				});
		DATE_PATTERNS.put("dd. MM. y.", new PatternCoordinates[] {
				of(ISO, "hr"),
				});
		DATE_PATTERNS.put("d/M/yy G", new PatternCoordinates[] {
				of(JAPANESE, "th"),
				});
		DATE_PATTERNS.put("d. M. y. GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "hr"),
				});
		DATE_PATTERNS.put("d‏/M‏/y", new PatternCoordinates[] {
				of(ISO, "ar"),
				});
		DATE_PATTERNS.put("MM/dd/yy", new PatternCoordinates[] {
				of(ISO, "es-PA"),
				of(ISO, "es-PR"),
				});
		DATE_PATTERNS.put("d. M. y.", new PatternCoordinates[] {
				of(ISO, "bs"),
				});
		DATE_PATTERNS.put("Gy/M/d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "yue"),
				of(JAPANESE, "yue"),
				of(MINGUO, "yue"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				});
		DATE_PATTERNS.put("Gyy-MM-dd", new PatternCoordinates[] {
				of(JAPANESE, "yue-Hans"),
				});
		DATE_PATTERNS.put("dd/MM/yy GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "es"),
				of(JAPANESE, "kgp"),
				of(THAI_BUDDHIST, "ms-ID"),
				of(JAPANESE, "pt"),
				of(JAPANESE, "yrl"),
				});
		DATE_PATTERNS.put("d/M/y G", new PatternCoordinates[] {
				of(JAPANESE, "pt-PT"),
				of(MINGUO, "th"),
				});
		DATE_PATTERNS.put("d/M/y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "id"),
				of(JAPANESE, "id"),
				of(MINGUO, "id"),
				});
		DATE_PATTERNS.put("Gy/MM/dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ja"),
				of(MINGUO, "ja"),
				});
		DATE_PATTERNS.put("d/MM/y", new PatternCoordinates[] {
				of(ISO, "nl-BE"),
				of(ISO, "nus"),
				});
		DATE_PATTERNS.put("d.MM.yy 'г'.", new PatternCoordinates[] {
				of(ISO, "bg"),
				});
		DATE_PATTERNS.put("Gd/M/yy", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "zh-Hans-HK"),
				of(JAPANESE, "zh-Hans-HK"),
				of(MINGUO, "zh-Hans-HK"),
				of(MINGUO, "zh-Hans-MO"),
				of(THAI_BUDDHIST, "zh-Hans-SG"),
				of(JAPANESE, "zh-Hans-SG"),
				of(MINGUO, "zh-Hans-SG"),
				});
		DATE_PATTERNS.put("dd/MM/y G", new PatternCoordinates[] {
				of(JAPANESE, "vi"),
				});
		DATE_PATTERNS.put("Gy-M-d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "yue-Hans"),
				of(THAI_BUDDHIST, "zh"),
				});
		DATE_PATTERNS.put("d.MM.y G", new PatternCoordinates[] {
				of(JAPANESE, "tr"),
				});
		DATE_PATTERNS.put("MM/dd/y", new PatternCoordinates[] {
				of(ISO, "iu"),
				});
		DATE_PATTERNS.put("dd/MM/yy", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "bew"),
				of(ISO, "byn"),
				of(ISO, "cy"),
				of(ISO, "en-BE"),
				of(ISO, "en-BW"),
				of(ISO, "en-BZ"),
				of(ISO, "en-IN"),
				of(ISO, "es-MX"),
				of(ISO, "frr"),
				of(ISO, "fur"),
				of(ISO, "gez"),
				of(ISO, "gl"),
				of(ISO, "gv"),
				of(ISO, "id"),
				of(ISO, "it"),
				of(ISO, "lij"),
				of(ISO, "ms-ID"),
				of(ISO, "nnh"),
				of(ISO, "om"),
				of(ISO, "pt-PT"),
				of(ISO, "sid"),
				of(ISO, "so"),
				of(ISO, "ssy"),
				of(ISO, "tg"),
				of(ISO, "ti"),
				of(ISO, "tig"),
				of(ISO, "tpi"),
				of(ISO, "uz"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "vec"),
				of(ISO, "wal"),
				of(ISO, "yi"),
				of(ISO, "zh-Hans-SG"),
				});
		DATE_PATTERNS.put("y-MM-dd G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "sv"),
				});
		DATE_PATTERNS.put("y/MM/dd", new PatternCoordinates[] {
				of(ISO, "en-ZA"),
				of(ISO, "ja"),
				});
		DATE_PATTERNS.put("d. M. y", new PatternCoordinates[] {
				of(ISO, "ksh"),
				of(ISO, "sk"),
				});
		DATE_PATTERNS.put("GGGGG y-MM-dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				});
		DATE_PATTERNS.put("dd/MM y", new PatternCoordinates[] {
				of(ISO, "kkj"),
				});
		DATE_PATTERNS.put("M/d/yy G", new PatternCoordinates[] {
				of(JAPANESE, "bs-Cyrl"),
				of(JAPANESE, "sr"),
				of(JAPANESE, "sr-Latn"),
				});
		DATE_PATTERNS.put("y.MM.dd", new PatternCoordinates[] {
				of(ISO, "cu"),
				of(ISO, "mn"),
				of(ISO, "mn-Mong-MN"),
				});
		DATE_PATTERNS.put("dd.MM.yy GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "cs"),
				});
		DATE_PATTERNS.put("d.MM.yy", new PatternCoordinates[] {
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "nds"),
				});
		DATE_PATTERNS.put("dd-MM-GGGGG yy", new PatternCoordinates[] {
				of(JAPANESE, "ee"),
				});
		DATE_PATTERNS.put("GGGGGy/M/d", new PatternCoordinates[] {
				of(JAPANESE, "ja"),
				});
		DATE_PATTERNS.put("dd-MM-yy", new PatternCoordinates[] {
				of(ISO, "es-CL"),
				of(ISO, "fy"),
				of(ISO, "rm"),
				of(ISO, "te"),
				});
		DATE_PATTERNS.put("d. M. yy.", new PatternCoordinates[] {
				of(ISO, "hr-BA"),
				});
		DATE_PATTERNS.put("yy/MM/dd", new PatternCoordinates[] {
				of(ISO, "ak"),
				of(ISO, "cch"),
				of(ISO, "kaj"),
				of(ISO, "kcg"),
				});
		DATE_PATTERNS.put("dd-MM-GGGGG y", new PatternCoordinates[] {
				of(MINGUO, "ee"),
				});
		DATE_PATTERNS.put("d/M/yy GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ast"),
				});
		DATE_PATTERNS.put("d.M.yy", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "be"),
				of(ISO, "dsb"),
				of(ISO, "hsb"),
				of(ISO, "ie"),
				of(ISO, "mk"),
				of(ISO, "sq"),
				});
		DATE_PATTERNS.put("M/d/y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "en"),
				of(JAPANESE, "ug"),
				});
		DATE_PATTERNS.put("dd.M.y GGGGG", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "mk"),
				});
		DATE_TIME_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(THAI_BUDDHIST, "ast"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bg"),
				of(ISO, "blo"),
				of(ISO, "brx"),
				of(THAI_BUDDHIST, "ca"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "cv"),
				of(ISO, "de"),
				of(ISO, "doi"),
				of(ISO, "el"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-GB"),
				of(ISO, "en-IN"),
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "es-CO"),
				of(ISO, "es-MX"),
				of(ISO, "es-US"),
				of(ISO, "fil"),
				of(ISO, "fo"),
				of(ISO, "fr-ML"),
				of(ISO, "frr"),
				of(ISO, "gaa"),
				of(ISO, "gl"),
				of(ISO, "ha"),
				of(ISO, "he"),
				of(ISO, "hi"),
				of(ISO, "hy"),
				of(THAI_BUDDHIST, "id"),
				of(ISO, "ig"),
				of(ISO, "is"),
				of(ISO, "it"),
				of(ISO, "jv"),
				of(ISO, "ka"),
				of(ISO, "kab"),
				of(ISO, "kea"),
				of(ISO, "kk"),
				of(ISO, "km"),
				of(ISO, "ks"),
				of(ISO, "ks-Deva"),
				of(ISO, "kxv"),
				of(ISO, "la"),
				of(ISO, "lo"),
				of(ISO, "mai"),
				of(ISO, "mk"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "ms"),
				of(ISO, "nds"),
				of(ISO, "ne"),
				of(ISO, "nl"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "nso"),
				of(ISO, "oc"),
				of(ISO, "oc-ES"),
				of(ISO, "or"),
				of(ISO, "os"),
				of(THAI_BUDDHIST, "pa"),
				of(ISO, "pa"),
				of(ISO, "pl"),
				of(ISO, "pt-PT"),
				of(ISO, "rif"),
				of(ISO, "ro"),
				of(ISO, "ru"),
				of(ISO, "sa"),
				of(ISO, "sc"),
				of(ISO, "sd-Deva"),
				of(ISO, "sl"),
				of(ISO, "sq"),
				of(ISO, "su"),
				of(ISO, "szl"),
				of(ISO, "ta"),
				of(ISO, "tn"),
				of(ISO, "tt"),
				of(ISO, "uk"),
				of(ISO, "uz"),
				of(ISO, "vec"),
				of(ISO, "xnr"),
				});
		DATE_TIME_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, "af"),
				of(ISO, "am"),
				of(ISO, "an"),
				of(ISO, "as"),
				of(ISO, "ast"),
				of(ISO, "az"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bew"),
				of(ISO, "bn"),
				of(ISO, "br"),
				of(ISO, "bs"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "ca"),
				of(ISO, "ccp"),
				of(ISO, "ckb"),
				of(ISO, "co"),
				of(ISO, "cs"),
				of(JAPANESE, "cs"),
				of(ISO, "cu"),
				of(ISO, "cy"),
				of(ISO, "da"),
				of(ISO, "dsb"),
				of(ISO, "dz"),
				of(ISO, "en-MV"),
				of(ISO, "eo"),
				of(ISO, "et"),
				of(ISO, "ff-Adlm"),
				of(JAPANESE, "ff-Adlm"),
				of(ISO, "fi"),
				of(ISO, "fr"),
				of(ISO, "fr-CA"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gu"),
				of(ISO, "haw"),
				of(ISO, "hi-Latn"),
				of(ISO, "hr"),
				of(JAPANESE, "hr"),
				of(ISO, "hsb"),
				of(ISO, "hu"),
				of(ISO, "ia"),
				of(ISO, "id"),
				of(ISO, "ie"),
				of(ISO, "ii"),
				of(ISO, "ja"),
				of(JAPANESE, "ja"),
				of(ISO, "jgo"),
				of(ISO, "kgp"),
				of(ISO, "kkj"),
				of(ISO, "kl"),
				of(ISO, "kn"),
				of(ISO, "ko"),
				of(ISO, "kok"),
				of(ISO, "ku"),
				of(ISO, "ky"),
				of(ISO, "lb"),
				of(ISO, "lij"),
				of(ISO, "lt"),
				of(ISO, "lv"),
				of(ISO, "mg"),
				of(ISO, "mgo"),
				of(ISO, "mi"),
				of(THAI_BUDDHIST, "mk"),
				of(ISO, "ml"),
				of(ISO, "mn"),
				of(ISO, "ms-Arab"),
				of(ISO, "mt"),
				of(ISO, "my"),
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				of(JAPANESE, "no"),
				of(ISO, "om"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "prg"),
				of(ISO, "ps"),
				of(ISO, "pt"),
				of(ISO, "qu"),
				of(ISO, "rm"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "sah"),
				of(ISO, "sat"),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "sk"),
				of(ISO, "smn"),
				of(ISO, "so"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(THAI_BUDDHIST, "sv"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "te"),
				of(ISO, "tg"),
				of(ISO, "th"),
				of(JAPANESE, "th"),
				of(ISO, "ti"),
				of(ISO, "tk"),
				of(ISO, "to"),
				of(ISO, "tr"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "xh"),
				of(ISO, "yi"),
				of(ISO, "yo"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				of(ISO, "yue"),
				of(JAPANESE, "yue"),
				of(ISO, "yue-Hans"),
				of(JAPANESE, "yue-Hans"),
				of(ISO, "zgh"),
				of(THAI_BUDDHIST, "zh"),
				of(ISO, "zh"),
				of(JAPANESE, "zh"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(ISO, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				of(ISO, "zh-Hant-HK"),
				of(ISO, "zu"),
				});
		DATE_TIME_PATTERNS.put("{1}،‏ {0}", new PatternCoordinates[] {
				of(ISO, "fa"),
				});
		DATE_TIME_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, "ee"),
				of(ISO, "vi"),
				});
		DATE_TIME_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(ISO, "wo"),
				});
		DATE_TIME_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, "ar"),
				of(ISO, "syr"),
				of(ISO, "ug"),
				});
		DATE_TIME_PATTERNS.put("{1} ({0})", new PatternCoordinates[] {
				of(ISO, "eu"),
				});
		TIME_PATTERNS.put("HH:mm", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(ISO, "af"),
				of(ISO, "agq"),
				of(ISO, "ar-KM"),
				of(ISO, "ar-MA"),
				of(ISO, "asa"),
				of(ISO, "ast"),
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "bas"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bez"),
				of(ISO, "blo"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(ISO, "bo"),
				of(ISO, "br"),
				of(ISO, "bs"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "cch"),
				of(ISO, "cgg"),
				of(ISO, "ckb-IR"),
				of(ISO, "co"),
				of(ISO, "cu"),
				of(ISO, "cv"),
				of(ISO, "cy"),
				of(ISO, "dav"),
				of(ISO, "de"),
				of(ISO, "dje"),
				of(ISO, "dua"),
				of(ISO, "dv"),
				of(ISO, "dyo"),
				of(ISO, "ebu"),
				of(ISO, "ee-TG"),
				of(ISO, "en-150"),
				of(ISO, "en-AI"),
				of(ISO, "en-BI"),
				of(ISO, "en-BW"),
				of(ISO, "en-BZ"),
				of(ISO, "en-CC"),
				of(ISO, "en-CK"),
				of(ISO, "en-CM"),
				of(ISO, "en-CX"),
				of(ISO, "en-DG"),
				of(ISO, "en-FK"),
				of(ISO, "en-GB"),
				of(ISO, "en-GG"),
				of(ISO, "en-GI"),
				of(ISO, "en-IE"),
				of(ISO, "en-IM"),
				of(ISO, "en-IO"),
				of(ISO, "en-JE"),
				of(ISO, "en-KE"),
				of(ISO, "en-MG"),
				of(ISO, "en-MS"),
				of(ISO, "en-MT"),
				of(ISO, "en-MU"),
				of(ISO, "en-MV"),
				of(ISO, "en-NF"),
				of(ISO, "en-NG"),
				of(ISO, "en-NR"),
				of(ISO, "en-NU"),
				of(ISO, "en-PN"),
				of(ISO, "en-RW"),
				of(ISO, "en-SC"),
				of(ISO, "en-SH"),
				of(ISO, "en-SX"),
				of(ISO, "en-TK"),
				of(ISO, "en-TV"),
				of(ISO, "en-TZ"),
				of(ISO, "en-UG"),
				of(ISO, "en-ZA"),
				of(ISO, "en-ZW"),
				of(ISO, "eo"),
				of(ISO, "es-BR"),
				of(ISO, "es-BZ"),
				of(ISO, "et"),
				of(ISO, "eu"),
				of(ISO, "ewo"),
				of(ISO, "ff"),
				of(ISO, "ff-Adlm"),
				of(ISO, "fo"),
				of(ISO, "fr"),
				of(ISO, "frr"),
				of(ISO, "fur"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gl"),
				of(ISO, "gsw"),
				of(ISO, "guz"),
				of(ISO, "gv"),
				of(ISO, "ha"),
				of(ISO, "hr"),
				of(ISO, "hy"),
				of(ISO, "ia"),
				of(ISO, "ie"),
				of(ISO, "ig"),
				of(ISO, "ii"),
				of(ISO, "is"),
				of(ISO, "it"),
				of(ISO, "jgo"),
				of(ISO, "jmc"),
				of(ISO, "jv"),
				of(ISO, "ka"),
				of(ISO, "kaj"),
				of(ISO, "kam"),
				of(ISO, "kcg"),
				of(ISO, "kde"),
				of(ISO, "kea"),
				of(ISO, "kgp"),
				of(ISO, "khq"),
				of(ISO, "ki"),
				of(ISO, "kk"),
				of(ISO, "kkj"),
				of(ISO, "kln"),
				of(ISO, "ko-CN"),
				of(ISO, "kpe-GN"),
				of(ISO, "ksb"),
				of(ISO, "ksf"),
				of(ISO, "ksh"),
				of(ISO, "ku"),
				of(ISO, "kw"),
				of(ISO, "ky"),
				of(ISO, "la"),
				of(ISO, "lag"),
				of(ISO, "lb"),
				of(ISO, "lg"),
				of(ISO, "lij"),
				of(ISO, "ln"),
				of(ISO, "lt"),
				of(ISO, "lu"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "lv"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mfe"),
				of(ISO, "mg"),
				of(ISO, "mgh"),
				of(ISO, "mgo"),
				of(ISO, "mk"),
				of(ISO, "mn"),
				of(ISO, "mt"),
				of(ISO, "mua"),
				of(ISO, "nd"),
				of(ISO, "ne"),
				of(ISO, "nl"),
				of(ISO, "nmg"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "nso"),
				of(ISO, "nyn"),
				of(ISO, "om-KE"),
				of(ISO, "os"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "pl"),
				of(ISO, "prg"),
				of(ISO, "pt"),
				of(ISO, "pt-PT"),
				of(ISO, "rif"),
				of(ISO, "rm"),
				of(ISO, "rn"),
				of(ISO, "ro"),
				of(ISO, "rof"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "ru"),
				of(ISO, "rwk"),
				of(ISO, "sah"),
				of(ISO, "saq"),
				of(ISO, "sbp"),
				of(ISO, "sc"),
				of(ISO, "seh"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "sl"),
				of(ISO, "so-KE"),
				of(ISO, "sq-MK"),
				of(ISO, "sq-XK"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "szl"),
				of(ISO, "ta-LK"),
				of(ISO, "teo"),
				of(ISO, "tg"),
				of(ISO, "th"),
				of(ISO, "tk"),
				of(ISO, "tn"),
				of(ISO, "tr"),
				of(ISO, "twq"),
				of(ISO, "ug"),
				of(ISO, "uk"),
				of(ISO, "uz"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "vec"),
				of(ISO, "vi"),
				of(ISO, "vo"),
				of(ISO, "vun"),
				of(ISO, "wo"),
				of(ISO, "xh"),
				of(ISO, "xog"),
				of(ISO, "yav"),
				of(ISO, "yi"),
				of(ISO, "yrl"),
				of(ISO, "yue-Hans"),
				of(ISO, "zgh"),
				of(ISO, "zh"),
				of(ISO, "zu"),
				});
		TIME_PATTERNS.put("h:mm a", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "af-NA"),
				of(ISO, "ak"),
				of(ISO, "bem"),
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "cic"),
				of(ISO, "el"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-IN"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-PH"),
				of(ISO, "es-US"),
				of(ISO, "ff-Latn-GH"),
				of(ISO, "ff-Latn-GM"),
				of(ISO, "ff-Latn-LR"),
				of(ISO, "ff-Latn-MR"),
				of(ISO, "ff-Latn-SL"),
				of(ISO, "fil"),
				of(ISO, "fr-DJ"),
				of(ISO, "fr-DZ"),
				of(ISO, "fr-MR"),
				of(ISO, "fr-SY"),
				of(ISO, "fr-TD"),
				of(ISO, "fr-TN"),
				of(ISO, "fr-VU"),
				of(ISO, "gaa"),
				of(ISO, "ha-GH"),
				of(ISO, "haw"),
				of(ISO, "hi-Latn"),
				of(ISO, "kab"),
				of(ISO, "kpe"),
				of(ISO, "kxv"),
				of(ISO, "lkt"),
				of(ISO, "mi"),
				of(ISO, "mic"),
				of(ISO, "moh"),
				of(ISO, "ms"),
				of(ISO, "mus"),
				of(ISO, "naq"),
				of(ISO, "nus"),
				of(ISO, "ny"),
				of(ISO, "om"),
				of(ISO, "pt-MO"),
				of(ISO, "qu"),
				of(ISO, "sid"),
				of(ISO, "so"),
				of(ISO, "sq"),
				of(ISO, "ss-SZ"),
				of(ISO, "ssy"),
				of(ISO, "st-LS"),
				of(ISO, "to"),
				of(ISO, "tr-CY"),
				of(ISO, "trv"),
				of(ISO, "vai-Latn"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				});
		TIME_PATTERNS.put("hh:mm a", new PatternCoordinates[] {
				of(ISO, "bal-Latn"),
				of(ISO, "tpi"),
				});
		TIME_PATTERNS.put("'Kl'. H.mm", new PatternCoordinates[] {
				of(ISO, "nds"),
				});
		TIME_PATTERNS.put("Bh:mm", new PatternCoordinates[] {
				of(ISO, "zh-Hant"),
				});
		TIME_PATTERNS.put("H.mm", new PatternCoordinates[] {
				of(ISO, "en-FI"),
				of(ISO, "fi"),
				of(ISO, "smn"),
				of(ISO, "su"),
				});
		TIME_PATTERNS.put("a नि h:mm", new PatternCoordinates[] {
				of(ISO, "brx"),
				});
		TIME_PATTERNS.put("a h:mm", new PatternCoordinates[] {
				of(ISO, "ko"),
				of(ISO, "ks-Deva"),
				});
		TIME_PATTERNS.put("H'h'mm", new PatternCoordinates[] {
				of(ISO, "oc"),
				});
		TIME_PATTERNS.put("HH 'h' mm", new PatternCoordinates[] {
				of(ISO, "fr-CA"),
				});
		TIME_PATTERNS.put("h:mm a", new PatternCoordinates[] {
				of(ISO, "am"),
				of(ISO, "ar"),
				of(ISO, "bgc"),
				of(ISO, "bho"),
				of(ISO, "bn"),
				of(ISO, "bo-IN"),
				of(ISO, "byn"),
				of(ISO, "ccp"),
				of(ISO, "chr"),
				of(ISO, "ckb"),
				of(ISO, "doi"),
				of(ISO, "ff-Adlm-GH"),
				of(ISO, "ff-Adlm-GM"),
				of(ISO, "ff-Adlm-LR"),
				of(ISO, "ff-Adlm-MR"),
				of(ISO, "ff-Adlm-SL"),
				of(ISO, "gez"),
				of(ISO, "hi"),
				of(ISO, "iu"),
				of(ISO, "km"),
				of(ISO, "kok"),
				of(ISO, "ks"),
				of(ISO, "lrc-IQ"),
				of(ISO, "mai"),
				of(ISO, "ml"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "ms-Arab"),
				of(ISO, "ne-IN"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "pa"),
				of(ISO, "pa-Arab"),
				of(ISO, "ps-PK"),
				of(ISO, "raj"),
				of(ISO, "rhg-Rohg-BD"),
				of(ISO, "sa"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "sd"),
				of(ISO, "sd-Deva"),
				of(ISO, "syr"),
				of(ISO, "ta"),
				of(ISO, "te"),
				of(ISO, "ti"),
				of(ISO, "tig"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "vai"),
				of(ISO, "wal"),
				of(ISO, "xnr"),
				});
		TIME_PATTERNS.put("h.mm. a", new PatternCoordinates[] {
				of(ISO, "mni-Mtei"),
				});
		TIME_PATTERNS.put("H:mm 'hodź'.", new PatternCoordinates[] {
				of(ISO, "hsb"),
				});
		TIME_PATTERNS.put("H:mm", new PatternCoordinates[] {
				of(ISO, "an"),
				of(ISO, "ar-IL"),
				of(ISO, "bg"),
				of(ISO, "ca"),
				of(ISO, "cs"),
				of(ISO, "dsb"),
				of(ISO, "en-IL"),
				of(ISO, "es"),
				of(ISO, "fa"),
				of(ISO, "he"),
				of(ISO, "hu"),
				of(ISO, "ja"),
				of(ISO, "lo"),
				of(ISO, "my"),
				of(ISO, "oc-ES"),
				of(ISO, "ps"),
				of(ISO, "rhg"),
				of(ISO, "sk"),
				of(ISO, "tt"),
				of(ISO, "uz-Arab"),
				});
		TIME_PATTERNS.put("ah:mm", new PatternCoordinates[] {
				of(ISO, "yue"),
				of(ISO, "zh-Hans-HK"),
				of(ISO, "zh-Hans-MO"),
				of(ISO, "zh-Hans-SG"),
				of(ISO, "zh-Hant-HK"),
				});
		TIME_PATTERNS.put("a 'ga' h:mm", new PatternCoordinates[] {
				of(ISO, "ee"),
				});
		TIME_PATTERNS.put("HH.mm", new PatternCoordinates[] {
				of(ISO, "bew"),
				of(ISO, "da"),
				of(ISO, "en-DK"),
				of(ISO, "en-ID"),
				of(ISO, "id"),
				of(ISO, "kl"),
				of(ISO, "ms-ID"),
				of(ISO, "si"),
				});
		TIME_PATTERNS.put("ཆུ་ཚོད་ h སྐར་མ་ mm a", new PatternCoordinates[] {
				of(ISO, "dz"),
				});
		TIME_PATTERNS.put("H:m", new PatternCoordinates[] {
				of(ISO, "yo"),
				});
		TIME_PATTERNS.put("a h.mm", new PatternCoordinates[] {
				of(ISO, "as"),
				});
		TIME_PATTERNS.put("hh:mm a", new PatternCoordinates[] {
				of(ISO, "bal"),
				of(ISO, "gu"),
				of(ISO, "kn"),
				});
	}
}
