package org.jresearch.gwt.time.apt.data.client;

import static org.jresearch.gwt.time.apt.base.Chrono.*;
import static org.jresearch.gwt.time.apt.data.client.PatternCoordinates.*;

import java.lang.String;
import java.util.HashMap;
import java.util.Map;

public class PatternInfoMedium {
	public static final Map<String, PatternCoordinates[]> DATE_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_PATTERNS = new HashMap<>();

	static {
		DATE_PATTERNS.put("d. MMM y.", new PatternCoordinates[] {
				of(ISO, "bs"),
				of(ISO, "hr"),
				});
		DATE_PATTERNS.put("d MMM, y G", new PatternCoordinates[] {
				of(JAPANESE, "el"),
				});
		DATE_PATTERNS.put("d MMM 'de' y", new PatternCoordinates[] {
				of(ISO, "es-BO"),
				});
		DATE_PATTERNS.put("d MMM, y 'ел'", new PatternCoordinates[] {
				of(ISO, "tt"),
				});
		DATE_PATTERNS.put("d. MMM y G", new PatternCoordinates[] {
				of(JAPANESE, "da"),
				of(THAI_BUDDHIST, "gsw"),
				of(JAPANESE, "no"),
				});
		DATE_PATTERNS.put("y MMM d", new PatternCoordinates[] {
				of(ISO, "ak"),
				of(ISO, "cch"),
				of(ISO, "ckb"),
				of(ISO, "cu"),
				of(ISO, "ii"),
				of(ISO, "jgo"),
				of(ISO, "kaj"),
				of(ISO, "kcg"),
				of(ISO, "mg"),
				of(ISO, "mgo"),
				of(ISO, "ne"),
				of(ISO, "nso"),
				of(ISO, "ps"),
				of(ISO, ""),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "trv"),
				});
		DATE_PATTERNS.put("y. M. d.", new PatternCoordinates[] {
				of(ISO, "ko"),
				});
		DATE_PATTERNS.put("y-MM-dd", new PatternCoordinates[] {
				of(ISO, "lt"),
				});
		DATE_PATTERNS.put("MMM dd, y", new PatternCoordinates[] {
				of(ISO, "gv"),
				});
		DATE_PATTERNS.put("dd-MM-y", new PatternCoordinates[] {
				of(ISO, "as"),
				of(ISO, "dv"),
				of(ISO, "en-MV"),
				of(ISO, "es-CL"),
				of(ISO, "mni-Mtei"),
				of(ISO, "rm"),
				});
		DATE_PATTERNS.put("d 'ne' MMM, y", new PatternCoordinates[] {
				of(ISO, "kgp"),
				});
		DATE_PATTERNS.put("y. MMM d.", new PatternCoordinates[] {
				of(ISO, "hu"),
				});
		DATE_PATTERNS.put("y年M月d日", new PatternCoordinates[] {
				of(ISO, "yue"),
				of(ISO, "yue-Hans"),
				of(ISO, "zh"),
				of(ISO, "zh-Hant"),
				of(ISO, "zh-Hant-HK"),
				});
		DATE_PATTERNS.put("MMM d, y G", new PatternCoordinates[] {
				of(JAPANESE, "bs-Cyrl"),
				of(JAPANESE, "en"),
				of(JAPANESE, "sr"),
				of(JAPANESE, "sr-Latn"),
				});
		DATE_PATTERNS.put("dd.MM.y", new PatternCoordinates[] {
				of(ISO, "de"),
				of(ISO, "fo"),
				of(ISO, "gsw"),
				});
		DATE_PATTERNS.put("d.M.y", new PatternCoordinates[] {
				of(ISO, "dsb"),
				of(ISO, "fi"),
				of(ISO, "hsb"),
				of(ISO, "mk"),
				});
		DATE_PATTERNS.put("d 'de' MMM 'de' y", new PatternCoordinates[] {
				of(ISO, "gl"),
				of(ISO, "pt"),
				of(ISO, "seh"),
				});
		DATE_PATTERNS.put("dטן MMM y", new PatternCoordinates[] {
				of(ISO, "yi"),
				});
		DATE_PATTERNS.put("G y MMM d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				});
		DATE_PATTERNS.put("d. MMM y", new PatternCoordinates[] {
				of(ISO, "da"),
				of(ISO, "et"),
				of(ISO, "frr"),
				of(ISO, "is"),
				of(ISO, "lb"),
				of(ISO, "nds"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "sl"),
				of(ISO, "wae"),
				});
		DATE_PATTERNS.put("d. M. y G", new PatternCoordinates[] {
				of(JAPANESE, "cs"),
				});
		DATE_PATTERNS.put("MMM d، y G", new PatternCoordinates[] {
				of(JAPANESE, "ug"),
				});
		DATE_PATTERNS.put("d.MM.y", new PatternCoordinates[] {
				of(ISO, "be-TARASK"),
				});
		DATE_PATTERNS.put("dd MMM, y թ.", new PatternCoordinates[] {
				of(ISO, "hy"),
				});
		DATE_PATTERNS.put("dd/MM/y GGGGG", new PatternCoordinates[] {
				of(JAPANESE, "es"),
				});
		DATE_PATTERNS.put("d-MMM-y", new PatternCoordinates[] {
				of(ISO, "kok"),
				});
		DATE_PATTERNS.put("d 'de' MMM y", new PatternCoordinates[] {
				of(ISO, "sc"),
				});
		DATE_PATTERNS.put("MMM d 'lia', G y", new PatternCoordinates[] {
				of(JAPANESE, "ee"),
				of(MINGUO, "ee"),
				});
		DATE_PATTERNS.put("d בMMM y", new PatternCoordinates[] {
				of(ISO, "he"),
				});
		DATE_PATTERNS.put("dd.MM.y.", new PatternCoordinates[] {
				of(ISO, "bs-Cyrl"),
				});
		DATE_PATTERNS.put("dd.MM 'st'. y", new PatternCoordinates[] {
				of(ISO, "prg"),
				});
		DATE_PATTERNS.put("dd/MM/y", new PatternCoordinates[] {
				of(ISO, "fur"),
				of(ISO, "ms-Arab"),
				of(ISO, "pt-PT"),
				});
		DATE_PATTERNS.put("MMM d y", new PatternCoordinates[] {
				of(ISO, "blo"),
				});
		DATE_PATTERNS.put("dd MMM y 'аз'", new PatternCoordinates[] {
				of(ISO, "os"),
				});
		DATE_PATTERNS.put("d MM y", new PatternCoordinates[] {
				of(ISO, "yo"),
				});
		DATE_PATTERNS.put("d. M. y.", new PatternCoordinates[] {
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				});
		DATE_PATTERNS.put("Gy年M月d日", new PatternCoordinates[] {
				of(JAPANESE, "ja"),
				of(THAI_BUDDHIST, "yue"),
				of(JAPANESE, "yue"),
				of(MINGUO, "yue"),
				of(THAI_BUDDHIST, "yue-Hans"),
				of(JAPANESE, "yue-Hans"),
				of(MINGUO, "yue-Hans"),
				of(THAI_BUDDHIST, "zh"),
				of(JAPANESE, "zh"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				});
		DATE_PATTERNS.put("dd-MM-y G", new PatternCoordinates[] {
				of(JAPANESE, "vi"),
				});
		DATE_PATTERNS.put("dd-MMM-y", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "byn"),
				of(ISO, "en-BZ"),
				of(ISO, "en-PK"),
				of(ISO, "gez"),
				of(ISO, "om"),
				of(ISO, "sid"),
				of(ISO, "so"),
				of(ISO, "ssy"),
				of(ISO, "tig"),
				of(ISO, "wal"),
				});
		DATE_PATTERNS.put("dd MMM y", new PatternCoordinates[] {
				of(ISO, "af"),
				of(ISO, "en-BE"),
				of(ISO, "en-BW"),
				of(ISO, "en-MT"),
				of(ISO, "en-ZA"),
				of(ISO, "kl"),
				of(ISO, "mt"),
				of(ISO, "rif"),
				of(ISO, "tg"),
				of(ISO, "tpi"),
				});
		DATE_PATTERNS.put("Gy/MM/dd", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ja"),
				of(MINGUO, "ja"),
				});
		DATE_PATTERNS.put("d/MM/y", new PatternCoordinates[] {
				of(ISO, "es-CO"),
				of(ISO, "es-GT"),
				});
		DATE_PATTERNS.put("d'ê' MMM'a' y'an'", new PatternCoordinates[] {
				of(ISO, "ku"),
				});
		DATE_PATTERNS.put("d MMM⹁ y G", new PatternCoordinates[] {
				of(JAPANESE, "ff-Adlm"),
				});
		DATE_PATTERNS.put("d MMM، y", new PatternCoordinates[] {
				of(ISO, "trw"),
				of(ISO, "ur"),
				});
		DATE_PATTERNS.put("y('e')'ko' MMM d('a')", new PatternCoordinates[] {
				of(ISO, "eu"),
				});
		DATE_PATTERNS.put("y-'ж'., d-MMM", new PatternCoordinates[] {
				of(ISO, "ky"),
				});
		DATE_PATTERNS.put("d MMM y 'р'.", new PatternCoordinates[] {
				of(ISO, "uk"),
				});
		DATE_PATTERNS.put("dd/MM/y G", new PatternCoordinates[] {
				of(MINGUO, "ca"),
				of(JAPANESE, "kgp"),
				of(THAI_BUDDHIST, "ms-Arab"),
				of(JAPANESE, "ms-Arab"),
				of(JAPANESE, "pt"),
				of(JAPANESE, "yrl"),
				});
		DATE_PATTERNS.put("MM/dd/y", new PatternCoordinates[] {
				of(ISO, "es-PA"),
				of(ISO, "es-PR"),
				});
		DATE_PATTERNS.put("y MMM. d", new PatternCoordinates[] {
				of(ISO, "vo"),
				});
		DATE_PATTERNS.put("y-MMM-dd", new PatternCoordinates[] {
				of(ISO, "eo"),
				});
		DATE_PATTERNS.put("y, MMM d", new PatternCoordinates[] {
				of(ISO, "ml"),
				of(ISO, "sah"),
				});
		DATE_PATTERNS.put("y ལོའི་MMMཚེས་d", new PatternCoordinates[] {
				of(ISO, "bo"),
				});
		DATE_PATTERNS.put("G y.MM.dd.", new PatternCoordinates[] {
				of(JAPANESE, "hu"),
				});
		DATE_PATTERNS.put("y/MM/dd", new PatternCoordinates[] {
				of(ISO, "ja"),
				});
		DATE_PATTERNS.put("d MMM y", new PatternCoordinates[] {
				of(ISO, "af-NA"),
				of(ISO, "am"),
				of(ISO, "an"),
				of(ISO, "asa"),
				of(ISO, "ast"),
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "bem"),
				of(ISO, "bew"),
				of(ISO, "bez"),
				of(ISO, "br"),
				of(ISO, "ca"),
				of(ISO, "cgg"),
				of(ISO, "co"),
				of(ISO, "cy"),
				of(ISO, "dav"),
				of(ISO, "dua"),
				of(ISO, "dyo"),
				of(ISO, "ebu"),
				of(ISO, "el"),
				of(ISO, "en-001"),
				of(ISO, "en-AE"),
				of(ISO, "en-AU"),
				of(ISO, "en-GB"),
				of(ISO, "en-HK"),
				of(ISO, "en-IN"),
				of(ISO, "en-NZ"),
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-US"),
				of(ISO, "ewo"),
				of(ISO, "fa"),
				of(ISO, "fr"),
				of(ISO, "fr-CA"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "guz"),
				of(ISO, "haw"),
				of(ISO, "hi"),
				of(ISO, "ia"),
				of(ISO, "id"),
				of(ISO, "ie"),
				of(ISO, "ig"),
				of(ISO, "it"),
				of(ISO, "jmc"),
				of(ISO, "jv"),
				of(ISO, "kam"),
				of(ISO, "kde"),
				of(ISO, "kea"),
				of(ISO, "ki"),
				of(ISO, "kkj"),
				of(ISO, "kln"),
				of(ISO, "km"),
				of(ISO, "ks-Deva"),
				of(ISO, "ksb"),
				of(ISO, "ksf"),
				of(ISO, "kw"),
				of(ISO, "kxv"),
				of(ISO, "lag"),
				of(ISO, "lg"),
				of(ISO, "ln"),
				of(ISO, "lo"),
				of(ISO, "lu"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "mai"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mgh"),
				of(ISO, "mi"),
				of(ISO, "ms"),
				of(ISO, "mua"),
				of(ISO, "naq"),
				of(ISO, "nd"),
				of(ISO, "nl"),
				of(ISO, "nmg"),
				of(ISO, "nus"),
				of(ISO, "nyn"),
				of(ISO, "oc"),
				of(ISO, "oc-ES"),
				of(ISO, "pa"),
				of(ISO, "pa-Arab"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "pl"),
				of(ISO, "qu"),
				of(ISO, "rn"),
				of(ISO, "ro"),
				of(ISO, "rof"),
				of(ISO, "rwk"),
				of(ISO, "sa"),
				of(ISO, "saq"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "sbp"),
				of(ISO, "se-FI"),
				of(ISO, "sq"),
				of(ISO, "su"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "szl"),
				of(ISO, "teo"),
				of(THAI_BUDDHIST, "th"),
				of(ISO, "th"),
				of(ISO, "ti"),
				of(ISO, "tk"),
				of(ISO, "to"),
				of(ISO, "tr"),
				of(ISO, "twq"),
				of(ISO, "tzm"),
				of(ISO, "uz-Arab"),
				of(ISO, "vai"),
				of(ISO, "vai-Latn"),
				of(ISO, "vec"),
				of(ISO, "vun"),
				of(ISO, "xnr"),
				of(ISO, "xog"),
				of(ISO, "yav"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				});
		DATE_PATTERNS.put("d MMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ast"),
				of(THAI_BUDDHIST, "be"),
				of(THAI_BUDDHIST, "ca"),
				of(THAI_BUDDHIST, "id"),
				of(JAPANESE, "id"),
				of(MINGUO, "id"),
				of(THAI_BUDDHIST, "ms-ID"),
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				of(THAI_BUDDHIST, "sv"),
				of(JAPANESE, "tr"),
				});
		DATE_PATTERNS.put("'die' d MMM y G", new PatternCoordinates[] {
				of(ISO, "la"),
				});
		DATE_PATTERNS.put("d MMM G y", new PatternCoordinates[] {
				of(JAPANESE, "th"),
				of(MINGUO, "th"),
				});
		DATE_PATTERNS.put("MMM d, y", new PatternCoordinates[] {
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "cic"),
				of(ISO, "en"),
				of(ISO, "en-CA"),
				of(ISO, "fil"),
				of(ISO, "gaa"),
				of(ISO, "iu"),
				of(ISO, "kn"),
				of(ISO, "ks"),
				of(ISO, "lkt"),
				of(ISO, "mic"),
				of(ISO, "mni"),
				of(ISO, "mus"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "sd-Deva"),
				of(ISO, "xh"),
				of(ISO, "zu"),
				});
		DATE_PATTERNS.put("d. M. y", new PatternCoordinates[] {
				of(ISO, "cs"),
				of(ISO, "sk"),
				});
		DATE_PATTERNS.put("d MMM⹁ y", new PatternCoordinates[] {
				of(ISO, "ff-Adlm"),
				});
		DATE_PATTERNS.put("dd MMM, y", new PatternCoordinates[] {
				of(ISO, "hi-Latn"),
				});
		DATE_PATTERNS.put("dd.M.y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "mk"),
				});
		DATE_PATTERNS.put("MMM d. y", new PatternCoordinates[] {
				of(ISO, "smn"),
				});
		DATE_PATTERNS.put("སྤྱི་ལོ་y ཟླ་MMM ཚེས་dd", new PatternCoordinates[] {
				of(ISO, "dz"),
				});
		DATE_PATTERNS.put("y.MM.dd", new PatternCoordinates[] {
				of(ISO, "mn-Mong-MN"),
				});
		DATE_PATTERNS.put("d-MMM، y", new PatternCoordinates[] {
				of(ISO, "ug"),
				});
		DATE_PATTERNS.put("y၊ MMM d", new PatternCoordinates[] {
				of(ISO, "my"),
				});
		DATE_PATTERNS.put("d, MMM y", new PatternCoordinates[] {
				of(ISO, "doi"),
				});
		DATE_PATTERNS.put("MMM d 'lia', y", new PatternCoordinates[] {
				of(ISO, "ee"),
				});
		DATE_PATTERNS.put("d. MMM. y", new PatternCoordinates[] {
				of(ISO, "ksh"),
				});
		DATE_PATTERNS.put("y 'ж'. dd MMM", new PatternCoordinates[] {
				of(ISO, "kk"),
				});
		DATE_PATTERNS.put("y 'оны' MMM'ын' d", new PatternCoordinates[] {
				of(ISO, "mn"),
				});
		DATE_PATTERNS.put("d ܒMMM y", new PatternCoordinates[] {
				of(ISO, "syr"),
				});
		DATE_PATTERNS.put("d-MMM, y", new PatternCoordinates[] {
				of(ISO, "uz"),
				});
		DATE_PATTERNS.put("d MMM y 'г'.", new PatternCoordinates[] {
				of(ISO, "be"),
				of(ISO, "ru"),
				});
		DATE_PATTERNS.put("d.MM.y 'г'.", new PatternCoordinates[] {
				of(ISO, "bg"),
				});
		DATE_PATTERNS.put("d MMM. y", new PatternCoordinates[] {
				of(ISO, "ka"),
				});
		DATE_PATTERNS.put("d MMM y 'ш'.", new PatternCoordinates[] {
				of(ISO, "ab"),
				});
		DATE_PATTERNS.put("d MMM, y", new PatternCoordinates[] {
				of(ISO, "agq"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bas"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(ISO, "bn"),
				of(ISO, "brx"),
				of(ISO, "ccp"),
				of(ISO, "dje"),
				of(ISO, "ff"),
				of(ISO, "gu"),
				of(ISO, "ha"),
				of(ISO, "kab"),
				of(ISO, "khq"),
				of(ISO, "mfe"),
				of(ISO, "mr"),
				of(ISO, "nnh"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "shi"),
				of(ISO, "shi-Latn"),
				of(ISO, "ta"),
				of(ISO, "te"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "vi"),
				of(ISO, "wo"),
				of(ISO, "zgh"),
				});
		DATE_PATTERNS.put("d MMM 'do' y", new PatternCoordinates[] {
				of(ISO, "lij"),
				});
		DATE_PATTERNS.put("dd MMM,y", new PatternCoordinates[] {
				of(ISO, "en-ZW"),
				});
		DATE_PATTERNS.put("dd‏/MM‏/y", new PatternCoordinates[] {
				of(ISO, "ar"),
				});
		DATE_PATTERNS.put("y. 'gada' d. MMM", new PatternCoordinates[] {
				of(ISO, "lv"),
				});
		DATE_PATTERNS.put("d MMM y 'ҫ'.", new PatternCoordinates[] {
				of(ISO, "cv"),
				});
		DATE_PATTERNS.put("d. M. y. G", new PatternCoordinates[] {
				of(JAPANESE, "hr"),
				});
		DATE_TIME_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(ISO, "an"),
				of(THAI_BUDDHIST, "ast"),
				of(ISO, "ast"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bg"),
				of(ISO, "blo"),
				of(ISO, "br"),
				of(ISO, "brx"),
				of(THAI_BUDDHIST, "ca"),
				of(ISO, "ca"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "cv"),
				of(ISO, "de"),
				of(ISO, "doi"),
				of(ISO, "el"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-GB"),
				of(ISO, "en-IN"),
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "es-CO"),
				of(ISO, "es-MX"),
				of(ISO, "es-US"),
				of(ISO, "fil"),
				of(ISO, "fo"),
				of(ISO, "fr"),
				of(ISO, "fr-CA"),
				of(ISO, "fr-ML"),
				of(ISO, "frr"),
				of(ISO, "gaa"),
				of(ISO, "gl"),
				of(ISO, "ha"),
				of(ISO, "he"),
				of(ISO, "hi"),
				of(ISO, "hy"),
				of(THAI_BUDDHIST, "id"),
				of(ISO, "ig"),
				of(ISO, "is"),
				of(ISO, "it"),
				of(ISO, "jv"),
				of(ISO, "ka"),
				of(ISO, "kab"),
				of(ISO, "kea"),
				of(ISO, "kk"),
				of(ISO, "km"),
				of(ISO, "ks"),
				of(ISO, "ks-Deva"),
				of(ISO, "kxv"),
				of(ISO, "la"),
				of(ISO, "lij"),
				of(ISO, "lo"),
				of(ISO, "mai"),
				of(ISO, "mk"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "ms"),
				of(ISO, "nds"),
				of(ISO, "ne"),
				of(ISO, "nl"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "nso"),
				of(ISO, "oc"),
				of(ISO, "oc-ES"),
				of(ISO, "or"),
				of(ISO, "os"),
				of(THAI_BUDDHIST, "pa"),
				of(ISO, "pa"),
				of(ISO, "pl"),
				of(ISO, "pt-PT"),
				of(ISO, "rif"),
				of(ISO, "ro"),
				of(ISO, "ru"),
				of(ISO, "sa"),
				of(ISO, "sc"),
				of(ISO, "sd-Deva"),
				of(ISO, "sk"),
				of(ISO, "sl"),
				of(ISO, "sq"),
				of(ISO, "su"),
				of(ISO, "szl"),
				of(ISO, "ta"),
				of(ISO, "tn"),
				of(ISO, "to"),
				of(ISO, "tt"),
				of(ISO, "uk"),
				of(ISO, "uz"),
				of(ISO, "vec"),
				of(ISO, "xnr"),
				of(ISO, "yi"),
				});
		DATE_TIME_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, "af"),
				of(ISO, "am"),
				of(ISO, "as"),
				of(ISO, "az"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bew"),
				of(ISO, "bn"),
				of(ISO, "bs"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "ccp"),
				of(ISO, "ckb"),
				of(ISO, "cs"),
				of(JAPANESE, "cs"),
				of(ISO, "cu"),
				of(ISO, "cy"),
				of(ISO, "da"),
				of(ISO, "dsb"),
				of(ISO, "dz"),
				of(ISO, "en-MV"),
				of(ISO, "eo"),
				of(ISO, "et"),
				of(ISO, "ff-Adlm"),
				of(ISO, "fi"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gu"),
				of(ISO, "haw"),
				of(ISO, "hi-Latn"),
				of(ISO, "hr"),
				of(JAPANESE, "hr"),
				of(ISO, "hsb"),
				of(ISO, "hu"),
				of(ISO, "ia"),
				of(ISO, "id"),
				of(ISO, "ie"),
				of(ISO, "ii"),
				of(ISO, "ja"),
				of(JAPANESE, "ja"),
				of(ISO, "jgo"),
				of(ISO, "kgp"),
				of(ISO, "kkj"),
				of(ISO, "kl"),
				of(ISO, "kn"),
				of(ISO, "ko"),
				of(ISO, "kok"),
				of(ISO, "ku"),
				of(ISO, "ky"),
				of(ISO, "lb"),
				of(ISO, "lt"),
				of(ISO, "lv"),
				of(ISO, "mg"),
				of(ISO, "mgo"),
				of(ISO, "mi"),
				of(THAI_BUDDHIST, "mk"),
				of(ISO, "ml"),
				of(ISO, "mn"),
				of(ISO, "ms-Arab"),
				of(ISO, "mt"),
				of(ISO, "my"),
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				of(JAPANESE, "no"),
				of(ISO, "om"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "prg"),
				of(ISO, "ps"),
				of(ISO, "pt"),
				of(ISO, "qu"),
				of(ISO, "rm"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "sah"),
				of(ISO, "sat"),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "smn"),
				of(ISO, "so"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(THAI_BUDDHIST, "sv"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "te"),
				of(ISO, "tg"),
				of(ISO, "th"),
				of(JAPANESE, "th"),
				of(ISO, "ti"),
				of(ISO, "tk"),
				of(ISO, "tr"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "xh"),
				of(ISO, "yo"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				of(ISO, "yue"),
				of(JAPANESE, "yue"),
				of(ISO, "yue-Hans"),
				of(JAPANESE, "yue-Hans"),
				of(ISO, "zgh"),
				of(THAI_BUDDHIST, "zh"),
				of(ISO, "zh"),
				of(JAPANESE, "zh"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(ISO, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				of(ISO, "zh-Hant-HK"),
				of(ISO, "zu"),
				});
		DATE_TIME_PATTERNS.put("{1}⹁ {0}", new PatternCoordinates[] {
				of(JAPANESE, "ff-Adlm"),
				});
		DATE_TIME_PATTERNS.put("{1}،‏ {0}", new PatternCoordinates[] {
				of(ISO, "fa"),
				});
		DATE_TIME_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, "ee"),
				of(ISO, "vi"),
				});
		DATE_TIME_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(ISO, "wo"),
				});
		DATE_TIME_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, "ar"),
				of(ISO, "syr"),
				of(ISO, "ug"),
				});
		DATE_TIME_PATTERNS.put("{1} 'à' {0}", new PatternCoordinates[] {
				of(ISO, "co"),
				});
		DATE_TIME_PATTERNS.put("{1} ({0})", new PatternCoordinates[] {
				of(ISO, "eu"),
				});
		TIME_PATTERNS.put("HH:mm:ss", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(ISO, "af"),
				of(ISO, "agq"),
				of(ISO, "ar-KM"),
				of(ISO, "ar-MA"),
				of(ISO, "asa"),
				of(ISO, "ast"),
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "bas"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bez"),
				of(ISO, "blo"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(ISO, "bo"),
				of(ISO, "br"),
				of(ISO, "bs"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "cch"),
				of(ISO, "cgg"),
				of(ISO, "ckb-IR"),
				of(ISO, "co"),
				of(ISO, "cu"),
				of(ISO, "cv"),
				of(ISO, "cy"),
				of(ISO, "dav"),
				of(ISO, "de"),
				of(ISO, "dje"),
				of(ISO, "dua"),
				of(ISO, "dv"),
				of(ISO, "dyo"),
				of(ISO, "ebu"),
				of(ISO, "ee-TG"),
				of(ISO, "en-150"),
				of(ISO, "en-AI"),
				of(ISO, "en-BI"),
				of(ISO, "en-BW"),
				of(ISO, "en-BZ"),
				of(ISO, "en-CC"),
				of(ISO, "en-CK"),
				of(ISO, "en-CM"),
				of(ISO, "en-CX"),
				of(ISO, "en-DG"),
				of(ISO, "en-FK"),
				of(ISO, "en-GB"),
				of(ISO, "en-GG"),
				of(ISO, "en-GI"),
				of(ISO, "en-IE"),
				of(ISO, "en-IM"),
				of(ISO, "en-IO"),
				of(ISO, "en-JE"),
				of(ISO, "en-KE"),
				of(ISO, "en-MG"),
				of(ISO, "en-MS"),
				of(ISO, "en-MT"),
				of(ISO, "en-MU"),
				of(ISO, "en-MV"),
				of(ISO, "en-NF"),
				of(ISO, "en-NG"),
				of(ISO, "en-NR"),
				of(ISO, "en-NU"),
				of(ISO, "en-PN"),
				of(ISO, "en-RW"),
				of(ISO, "en-SC"),
				of(ISO, "en-SH"),
				of(ISO, "en-SX"),
				of(ISO, "en-TK"),
				of(ISO, "en-TV"),
				of(ISO, "en-TZ"),
				of(ISO, "en-UG"),
				of(ISO, "en-ZA"),
				of(ISO, "en-ZW"),
				of(ISO, "eo"),
				of(ISO, "es-BR"),
				of(ISO, "es-BZ"),
				of(ISO, "et"),
				of(ISO, "eu"),
				of(ISO, "ewo"),
				of(ISO, "ff"),
				of(ISO, "ff-Adlm"),
				of(ISO, "fo"),
				of(ISO, "fr"),
				of(ISO, "frr"),
				of(ISO, "fur"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gl"),
				of(ISO, "gsw"),
				of(ISO, "guz"),
				of(ISO, "gv"),
				of(ISO, "ha"),
				of(ISO, "hr"),
				of(ISO, "hy"),
				of(ISO, "ia"),
				of(ISO, "ie"),
				of(ISO, "ig"),
				of(ISO, "ii"),
				of(ISO, "is"),
				of(ISO, "it"),
				of(ISO, "jgo"),
				of(ISO, "jmc"),
				of(ISO, "jv"),
				of(ISO, "ka"),
				of(ISO, "kaj"),
				of(ISO, "kam"),
				of(ISO, "kcg"),
				of(ISO, "kde"),
				of(ISO, "kea"),
				of(ISO, "kgp"),
				of(ISO, "khq"),
				of(ISO, "ki"),
				of(ISO, "kk"),
				of(ISO, "kkj"),
				of(ISO, "kln"),
				of(ISO, "ko-CN"),
				of(ISO, "kpe-GN"),
				of(ISO, "ksb"),
				of(ISO, "ksf"),
				of(ISO, "ksh"),
				of(ISO, "ku"),
				of(ISO, "kw"),
				of(ISO, "ky"),
				of(ISO, "la"),
				of(ISO, "lag"),
				of(ISO, "lb"),
				of(ISO, "lg"),
				of(ISO, "lij"),
				of(ISO, "ln"),
				of(ISO, "lt"),
				of(ISO, "lu"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "lv"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mfe"),
				of(ISO, "mg"),
				of(ISO, "mgh"),
				of(ISO, "mgo"),
				of(ISO, "mk"),
				of(ISO, "mn"),
				of(ISO, "mt"),
				of(ISO, "mua"),
				of(ISO, "nd"),
				of(ISO, "ne"),
				of(ISO, "nl"),
				of(ISO, "nmg"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "nso"),
				of(ISO, "nyn"),
				of(ISO, "om-KE"),
				of(ISO, "os"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "pl"),
				of(ISO, "prg"),
				of(ISO, "pt"),
				of(ISO, "pt-PT"),
				of(ISO, "rhg"),
				of(ISO, "rif"),
				of(ISO, "rm"),
				of(ISO, "rn"),
				of(ISO, "ro"),
				of(ISO, "rof"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "ru"),
				of(ISO, "rwk"),
				of(ISO, "sah"),
				of(ISO, "saq"),
				of(ISO, "sbp"),
				of(ISO, "sc"),
				of(ISO, "seh"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "sl"),
				of(ISO, "so-KE"),
				of(ISO, "sq-MK"),
				of(ISO, "sq-XK"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "szl"),
				of(ISO, "ta-LK"),
				of(ISO, "teo"),
				of(ISO, "tg"),
				of(ISO, "th"),
				of(ISO, "tk"),
				of(ISO, "tn"),
				of(ISO, "tr"),
				of(ISO, "twq"),
				of(ISO, "ug"),
				of(ISO, "uk"),
				of(ISO, "uz"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "vec"),
				of(ISO, "vi"),
				of(ISO, "vo"),
				of(ISO, "vun"),
				of(ISO, "wo"),
				of(ISO, "xh"),
				of(ISO, "xog"),
				of(ISO, "yav"),
				of(ISO, "yi"),
				of(ISO, "yrl"),
				of(ISO, "yue-Hans"),
				of(ISO, "zgh"),
				of(ISO, "zh"),
				of(ISO, "zu"),
				});
		TIME_PATTERNS.put("h.mm.ss a", new PatternCoordinates[] {
				of(ISO, "mni-Mtei"),
				});
		TIME_PATTERNS.put("ah:mm:ss", new PatternCoordinates[] {
				of(ISO, "yue"),
				of(ISO, "zh-Hans-HK"),
				of(ISO, "zh-Hans-MO"),
				of(ISO, "zh-Hans-SG"),
				of(ISO, "zh-Hant-HK"),
				});
		TIME_PATTERNS.put("H:mm:ss", new PatternCoordinates[] {
				of(ISO, "an"),
				of(ISO, "ar-IL"),
				of(ISO, "bg"),
				of(ISO, "ca"),
				of(ISO, "cs"),
				of(ISO, "dsb"),
				of(ISO, "en-IL"),
				of(ISO, "es"),
				of(ISO, "fa"),
				of(ISO, "he"),
				of(ISO, "hsb"),
				of(ISO, "hu"),
				of(ISO, "ja"),
				of(ISO, "lo"),
				of(ISO, "my"),
				of(ISO, "oc-ES"),
				of(ISO, "ps"),
				of(ISO, "sk"),
				of(ISO, "tt"),
				of(ISO, "uz-Arab"),
				});
		TIME_PATTERNS.put("a h.mm.ss", new PatternCoordinates[] {
				of(ISO, "as"),
				});
		TIME_PATTERNS.put("HH.mm.ss", new PatternCoordinates[] {
				of(ISO, "bew"),
				of(ISO, "da"),
				of(ISO, "en-DK"),
				of(ISO, "en-ID"),
				of(ISO, "id"),
				of(ISO, "kl"),
				of(ISO, "ms-ID"),
				of(ISO, "si"),
				});
		TIME_PATTERNS.put("H:m:s", new PatternCoordinates[] {
				of(ISO, "yo"),
				});
		TIME_PATTERNS.put("Bh:mm:ss", new PatternCoordinates[] {
				of(ISO, "zh-Hant"),
				});
		TIME_PATTERNS.put("H'h'mm:ss", new PatternCoordinates[] {
				of(ISO, "oc"),
				});
		TIME_PATTERNS.put("h:mm:ss a", new PatternCoordinates[] {
				of(ISO, "am"),
				of(ISO, "ar"),
				of(ISO, "bgc"),
				of(ISO, "bho"),
				of(ISO, "bn"),
				of(ISO, "bo-IN"),
				of(ISO, "byn"),
				of(ISO, "ccp"),
				of(ISO, "chr"),
				of(ISO, "ckb"),
				of(ISO, "doi"),
				of(ISO, "ff-Adlm-GH"),
				of(ISO, "ff-Adlm-GM"),
				of(ISO, "ff-Adlm-LR"),
				of(ISO, "ff-Adlm-MR"),
				of(ISO, "ff-Adlm-SL"),
				of(ISO, "gez"),
				of(ISO, "hi"),
				of(ISO, "iu"),
				of(ISO, "km"),
				of(ISO, "kok"),
				of(ISO, "ks"),
				of(ISO, "lrc-IQ"),
				of(ISO, "mai"),
				of(ISO, "ml"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "ms-Arab"),
				of(ISO, "ne-IN"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "pa"),
				of(ISO, "pa-Arab"),
				of(ISO, "ps-PK"),
				of(ISO, "raj"),
				of(ISO, "rhg-Rohg-BD"),
				of(ISO, "sa"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "sd"),
				of(ISO, "sd-Deva"),
				of(ISO, "syr"),
				of(ISO, "ta"),
				of(ISO, "te"),
				of(ISO, "ti"),
				of(ISO, "tig"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "vai"),
				of(ISO, "wal"),
				of(ISO, "xnr"),
				});
		TIME_PATTERNS.put("hh:mm:ss a", new PatternCoordinates[] {
				of(ISO, "bal-Latn"),
				of(ISO, "tpi"),
				});
		TIME_PATTERNS.put("a h:mm:ss", new PatternCoordinates[] {
				of(ISO, "brx"),
				of(ISO, "ko"),
				of(ISO, "ks-Deva"),
				});
		TIME_PATTERNS.put("'Klock' H.mm:ss", new PatternCoordinates[] {
				of(ISO, "nds"),
				});
		TIME_PATTERNS.put("hh:mm:ss a", new PatternCoordinates[] {
				of(ISO, "bal"),
				of(ISO, "gu"),
				of(ISO, "kn"),
				});
		TIME_PATTERNS.put("a 'ga' h:mm:ss", new PatternCoordinates[] {
				of(ISO, "ee"),
				});
		TIME_PATTERNS.put("h:mm:ss a", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "af-NA"),
				of(ISO, "ak"),
				of(ISO, "bem"),
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "cic"),
				of(ISO, "el"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-IN"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-PH"),
				of(ISO, "es-US"),
				of(ISO, "ff-Latn-GH"),
				of(ISO, "ff-Latn-GM"),
				of(ISO, "ff-Latn-LR"),
				of(ISO, "ff-Latn-MR"),
				of(ISO, "ff-Latn-SL"),
				of(ISO, "fil"),
				of(ISO, "fr-DJ"),
				of(ISO, "fr-DZ"),
				of(ISO, "fr-MR"),
				of(ISO, "fr-SY"),
				of(ISO, "fr-TD"),
				of(ISO, "fr-TN"),
				of(ISO, "fr-VU"),
				of(ISO, "gaa"),
				of(ISO, "ha-GH"),
				of(ISO, "haw"),
				of(ISO, "hi-Latn"),
				of(ISO, "kab"),
				of(ISO, "kpe"),
				of(ISO, "kxv"),
				of(ISO, "lkt"),
				of(ISO, "mi"),
				of(ISO, "mic"),
				of(ISO, "moh"),
				of(ISO, "ms"),
				of(ISO, "mus"),
				of(ISO, "naq"),
				of(ISO, "nus"),
				of(ISO, "ny"),
				of(ISO, "om"),
				of(ISO, "pt-MO"),
				of(ISO, "qu"),
				of(ISO, "sid"),
				of(ISO, "so"),
				of(ISO, "sq"),
				of(ISO, "ss-SZ"),
				of(ISO, "ssy"),
				of(ISO, "st-LS"),
				of(ISO, "to"),
				of(ISO, "tr-CY"),
				of(ISO, "trv"),
				of(ISO, "vai-Latn"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				});
		TIME_PATTERNS.put("H.mm.ss", new PatternCoordinates[] {
				of(ISO, "en-FI"),
				of(ISO, "fi"),
				of(ISO, "smn"),
				of(ISO, "su"),
				});
		TIME_PATTERNS.put("ཆུ་ཚོད་h:mm:ss a", new PatternCoordinates[] {
				of(ISO, "dz"),
				});
		TIME_PATTERNS.put("HH 'h' mm 'min' ss 's'", new PatternCoordinates[] {
				of(ISO, "fr-CA"),
				});
	}
}
