package org.jresearch.gwt.time.apt.data.client;

import static org.jresearch.gwt.time.apt.base.Chrono.*;
import static org.jresearch.gwt.time.apt.data.client.PatternCoordinates.*;

import java.lang.String;
import java.util.HashMap;
import java.util.Map;

public class PatternInfoLong {
	public static final Map<String, PatternCoordinates[]> DATE_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> DATE_TIME_PATTERNS = new HashMap<>();

	public static final Map<String, PatternCoordinates[]> TIME_PATTERNS = new HashMap<>();

	static {
		DATE_PATTERNS.put("'Ngày' dd 'tháng' M 'năm' y G", new PatternCoordinates[] {
				of(JAPANESE, "vi"),
				});
		DATE_PATTERNS.put("d نچی MMMM y", new PatternCoordinates[] {
				of(ISO, "uz-Arab"),
				});
		DATE_PATTERNS.put("d MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, "el"),
				});
		DATE_PATTERNS.put("y. 'gada' d. MMMM", new PatternCoordinates[] {
				of(ISO, "lv"),
				});
		DATE_PATTERNS.put("d MMMM, y 'ел'", new PatternCoordinates[] {
				of(ISO, "tt"),
				});
		DATE_PATTERNS.put("dd MMMM y", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "af"),
				of(ISO, "byn"),
				of(ISO, "en-BW"),
				of(ISO, "en-BZ"),
				of(ISO, "en-MT"),
				of(ISO, "en-ZA"),
				of(ISO, "en-ZW"),
				of(ISO, "gez"),
				of(ISO, "gv"),
				of(ISO, "kl"),
				of(ISO, "om"),
				of(ISO, "rif"),
				of(ISO, "sid"),
				of(ISO, "ssy"),
				of(ISO, "tg"),
				of(ISO, "tig"),
				of(ISO, "tpi"),
				of(ISO, "wal"),
				});
		DATE_PATTERNS.put("d-MMMM, y", new PatternCoordinates[] {
				of(ISO, "uz"),
				});
		DATE_PATTERNS.put("y년 MMMM d일", new PatternCoordinates[] {
				of(ISO, "ko"),
				});
		DATE_PATTERNS.put("d, MMMM y", new PatternCoordinates[] {
				of(ISO, "doi"),
				});
		DATE_PATTERNS.put("d. MMMM y", new PatternCoordinates[] {
				of(ISO, "cs"),
				of(ISO, "da"),
				of(ISO, "de"),
				of(ISO, "dsb"),
				of(ISO, "et"),
				of(ISO, "fi"),
				of(ISO, "fo"),
				of(ISO, "frr"),
				of(ISO, "gsw"),
				of(ISO, "hsb"),
				of(ISO, "is"),
				of(ISO, "ksh"),
				of(ISO, "lb"),
				of(ISO, "nds"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "sk"),
				of(ISO, "sl"),
				of(ISO, "wae"),
				});
		DATE_PATTERNS.put("y年M月d日", new PatternCoordinates[] {
				of(ISO, "ja"),
				of(ISO, "yue"),
				of(ISO, "yue-Hans"),
				of(ISO, "zh"),
				of(ISO, "zh-Hant"),
				of(ISO, "zh-Hant-HK"),
				});
		DATE_PATTERNS.put("d 'ta'’ MMMM y", new PatternCoordinates[] {
				of(ISO, "mt"),
				});
		DATE_PATTERNS.put("d 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-US"),
				of(ISO, "gl"),
				of(ISO, "oc-ES"),
				of(ISO, "pt"),
				of(ISO, "pt-PT"),
				of(ISO, "seh"),
				});
		DATE_PATTERNS.put("d MMMM، y", new PatternCoordinates[] {
				of(ISO, "trw"),
				of(ISO, "ur"),
				});
		DATE_PATTERNS.put("d 'de' MMMM y", new PatternCoordinates[] {
				of(ISO, "ia"),
				});
		DATE_PATTERNS.put("d ܒMMMM y", new PatternCoordinates[] {
				of(ISO, "syr"),
				});
		DATE_PATTERNS.put("d MMMM 'del' y", new PatternCoordinates[] {
				of(ISO, "ca"),
				});
		DATE_PATTERNS.put("dd MMMM, y թ.", new PatternCoordinates[] {
				of(ISO, "hy"),
				});
		DATE_PATTERNS.put("d MMMM 'de' y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ast"),
				of(MINGUO, "ca"),
				});
		DATE_PATTERNS.put("d'ê' MMMM'a' y'an'", new PatternCoordinates[] {
				of(ISO, "ku"),
				});
		DATE_PATTERNS.put("d 'de' MMMM 'de' y G", new PatternCoordinates[] {
				of(JAPANESE, "es"),
				of(JAPANESE, "pt"),
				});
		DATE_PATTERNS.put("d MMMM y 'ш'.", new PatternCoordinates[] {
				of(ISO, "ab"),
				});
		DATE_PATTERNS.put("y-MMMM-dd", new PatternCoordinates[] {
				of(ISO, "eo"),
				});
		DATE_PATTERNS.put("d בMMMM y", new PatternCoordinates[] {
				of(ISO, "he"),
				});
		DATE_PATTERNS.put("MMMM d، y G", new PatternCoordinates[] {
				of(JAPANESE, "ug"),
				});
		DATE_PATTERNS.put("G y MMMM d", new PatternCoordinates[] {
				of(THAI_BUDDHIST, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				});
		DATE_PATTERNS.put("d MMMM 'do' y", new PatternCoordinates[] {
				of(ISO, "lij"),
				});
		DATE_PATTERNS.put("d MMMM y 'г'.", new PatternCoordinates[] {
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bg"),
				of(ISO, "ru"),
				});
		DATE_PATTERNS.put("སྤྱི་ལོ་y MMMMའི་ཚེས་d", new PatternCoordinates[] {
				of(ISO, "bo"),
				});
		DATE_PATTERNS.put("y 'ж'. d MMMM", new PatternCoordinates[] {
				of(ISO, "kk"),
				});
		DATE_PATTERNS.put("d MMMM, y 'аз'", new PatternCoordinates[] {
				of(ISO, "os"),
				});
		DATE_PATTERNS.put("d MMMM y 'ҫ'.", new PatternCoordinates[] {
				of(ISO, "cv"),
				});
		DATE_PATTERNS.put("dی MMMMی y", new PatternCoordinates[] {
				of(ISO, "ckb"),
				});
		DATE_PATTERNS.put("GGGGy年M月d日", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "ja"),
				});
		DATE_PATTERNS.put("dd. MMMM y.", new PatternCoordinates[] {
				of(ISO, "bs-Cyrl"),
				});
		DATE_PATTERNS.put("MMMM d 'lia' y", new PatternCoordinates[] {
				of(ISO, "ee"),
				});
		DATE_PATTERNS.put("d 'ne' MMMM, y", new PatternCoordinates[] {
				of(ISO, "kgp"),
				});
		DATE_PATTERNS.put("Gy年M月d日", new PatternCoordinates[] {
				of(JAPANESE, "ja"),
				of(MINGUO, "ja"),
				of(THAI_BUDDHIST, "yue"),
				of(JAPANESE, "yue"),
				of(MINGUO, "yue"),
				of(THAI_BUDDHIST, "yue-Hans"),
				of(JAPANESE, "yue-Hans"),
				of(MINGUO, "yue-Hans"),
				of(THAI_BUDDHIST, "zh"),
				of(JAPANESE, "zh"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				});
		DATE_PATTERNS.put("སྤྱི་ལོ་y MMMM ཚེས་ dd", new PatternCoordinates[] {
				of(ISO, "dz"),
				});
		DATE_PATTERNS.put("dטן MMMM y", new PatternCoordinates[] {
				of(ISO, "yi"),
				});
		DATE_PATTERNS.put("y 'm'. MMMM d 'd'.", new PatternCoordinates[] {
				of(ISO, "lt"),
				});
		DATE_PATTERNS.put("dd MMMM y 'г'. G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "mk"),
				});
		DATE_PATTERNS.put("y-'ж'., d-MMMM", new PatternCoordinates[] {
				of(ISO, "ky"),
				});
		DATE_PATTERNS.put("MMMM d 'lia', G y", new PatternCoordinates[] {
				of(JAPANESE, "ee"),
				of(MINGUO, "ee"),
				});
		DATE_PATTERNS.put("y 'оны' MMMM'ын' d", new PatternCoordinates[] {
				of(ISO, "mn"),
				});
		DATE_PATTERNS.put("d MMMM⹁ y", new PatternCoordinates[] {
				of(ISO, "ff-Adlm"),
				});
		DATE_PATTERNS.put("G y. MMMM d.", new PatternCoordinates[] {
				of(JAPANESE, "hu"),
				});
		DATE_PATTERNS.put("d-MMMM، y", new PatternCoordinates[] {
				of(ISO, "ug"),
				});
		DATE_PATTERNS.put("d 'de' MMMM 'de' 'su' y", new PatternCoordinates[] {
				of(ISO, "sc"),
				});
		DATE_PATTERNS.put("d MMMM⹁ y G", new PatternCoordinates[] {
				of(JAPANESE, "ff-Adlm"),
				});
		DATE_PATTERNS.put("y 'mettas' d. MMMM", new PatternCoordinates[] {
				of(ISO, "prg"),
				});
		DATE_PATTERNS.put("d. MMMM y G", new PatternCoordinates[] {
				of(JAPANESE, "cs"),
				of(JAPANESE, "da"),
				of(THAI_BUDDHIST, "gsw"),
				of(JAPANESE, "no"),
				});
		DATE_PATTERNS.put("d MMMM y", new PatternCoordinates[] {
				of(ISO, "af-NA"),
				of(ISO, "agq"),
				of(ISO, "am"),
				of(ISO, "ar"),
				of(ISO, "asa"),
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "bas"),
				of(ISO, "bem"),
				of(ISO, "bew"),
				of(ISO, "bez"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(ISO, "br"),
				of(ISO, "cgg"),
				of(ISO, "cy"),
				of(ISO, "dav"),
				of(ISO, "dje"),
				of(ISO, "dua"),
				of(ISO, "dv"),
				of(ISO, "dyo"),
				of(ISO, "ebu"),
				of(ISO, "el"),
				of(ISO, "en-001"),
				of(ISO, "en-AE"),
				of(ISO, "en-AU"),
				of(ISO, "en-GB"),
				of(ISO, "en-HK"),
				of(ISO, "en-IN"),
				of(ISO, "en-MV"),
				of(ISO, "ewo"),
				of(ISO, "fa"),
				of(ISO, "ff"),
				of(ISO, "fr"),
				of(ISO, "fr-CA"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "guz"),
				of(ISO, "haw"),
				of(ISO, "hi"),
				of(ISO, "id"),
				of(ISO, "ie"),
				of(ISO, "ig"),
				of(ISO, "it"),
				of(ISO, "jmc"),
				of(ISO, "jv"),
				of(ISO, "kab"),
				of(ISO, "kam"),
				of(ISO, "kde"),
				of(ISO, "khq"),
				of(ISO, "ki"),
				of(ISO, "kkj"),
				of(ISO, "kln"),
				of(ISO, "km"),
				of(ISO, "kok"),
				of(ISO, "ks-Deva"),
				of(ISO, "ksb"),
				of(ISO, "ksf"),
				of(ISO, "kw"),
				of(ISO, "kxv"),
				of(ISO, "lag"),
				of(ISO, "lg"),
				of(ISO, "ln"),
				of(ISO, "lo"),
				of(ISO, "lu"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "mai"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mfe"),
				of(ISO, "mg"),
				of(ISO, "mgh"),
				of(ISO, "mi"),
				of(ISO, "mk"),
				of(ISO, "ms"),
				of(ISO, "ms-Arab"),
				of(ISO, "mua"),
				of(ISO, "naq"),
				of(ISO, "nd"),
				of(ISO, "nl"),
				of(ISO, "nmg"),
				of(ISO, "nus"),
				of(ISO, "nyn"),
				of(ISO, "pa"),
				of(ISO, "pa-Arab"),
				of(ISO, "pap"),
				of(ISO, "pcm"),
				of(ISO, "pl"),
				of(ISO, "qu"),
				of(ISO, "rm"),
				of(ISO, "rn"),
				of(ISO, "ro"),
				of(ISO, "rof"),
				of(ISO, "rwk"),
				of(ISO, "sa"),
				of(ISO, "saq"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "sbp"),
				of(ISO, "se-FI"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "shi"),
				of(ISO, "shi-Latn"),
				of(ISO, "sq"),
				of(ISO, "su"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "szl"),
				of(ISO, "teo"),
				of(THAI_BUDDHIST, "th"),
				of(ISO, "ti"),
				of(ISO, "tk"),
				of(ISO, "to"),
				of(ISO, "tr"),
				of(ISO, "twq"),
				of(ISO, "tzm"),
				of(ISO, "vai"),
				of(ISO, "vai-Latn"),
				of(ISO, "vec"),
				of(ISO, "vun"),
				of(ISO, "xnr"),
				of(ISO, "xog"),
				of(ISO, "yav"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				of(ISO, "zgh"),
				});
		DATE_PATTERNS.put("d MMMM y G", new PatternCoordinates[] {
				of(THAI_BUDDHIST, "be"),
				of(THAI_BUDDHIST, "ca"),
				of(THAI_BUDDHIST, "id"),
				of(JAPANESE, "id"),
				of(MINGUO, "id"),
				of(THAI_BUDDHIST, "ms-Arab"),
				of(JAPANESE, "ms-Arab"),
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				of(THAI_BUDDHIST, "sv"),
				of(JAPANESE, "tr"),
				of(JAPANESE, "yrl"),
				});
		DATE_PATTERNS.put("d MMMM G y", new PatternCoordinates[] {
				of(ISO, "th"),
				});
		DATE_PATTERNS.put("d MMMM 'di' 'u' y", new PatternCoordinates[] {
				of(ISO, "co"),
				});
		DATE_PATTERNS.put("y၊ MMMM d", new PatternCoordinates[] {
				of(ISO, "my"),
				});
		DATE_PATTERNS.put("d 'ne' MMMM, y G", new PatternCoordinates[] {
				of(JAPANESE, "kgp"),
				});
		DATE_PATTERNS.put("d. MMMM y. G", new PatternCoordinates[] {
				of(JAPANESE, "hr"),
				});
		DATE_PATTERNS.put("d MMM y", new PatternCoordinates[] {
				of(ISO, "yo"),
				});
		DATE_PATTERNS.put("dd 'de' MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, "es-HN"),
				});
		DATE_PATTERNS.put("MMMM d, y", new PatternCoordinates[] {
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "cic"),
				of(ISO, "en"),
				of(ISO, "en-CA"),
				of(ISO, "fil"),
				of(ISO, "gaa"),
				of(ISO, "iu"),
				of(ISO, "kn"),
				of(ISO, "ks"),
				of(ISO, "lkt"),
				of(ISO, "mic"),
				of(ISO, "mni"),
				of(ISO, "mus"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "sd-Deva"),
				of(ISO, "so"),
				of(ISO, "xh"),
				of(ISO, "zu"),
				});
		DATE_PATTERNS.put("y('e')'ko' MMMM'ren' d('a')", new PatternCoordinates[] {
				of(ISO, "eu"),
				});
		DATE_PATTERNS.put("MMMM d. y", new PatternCoordinates[] {
				of(ISO, "smn"),
				});
		DATE_PATTERNS.put("'die' d MMMM y G", new PatternCoordinates[] {
				of(ISO, "la"),
				});
		DATE_PATTERNS.put("d MMMM y 'р'.", new PatternCoordinates[] {
				of(ISO, "uk"),
				});
		DATE_PATTERNS.put("y, MMMM d", new PatternCoordinates[] {
				of(ISO, "ml"),
				of(ISO, "sah"),
				});
		DATE_PATTERNS.put("d MMMM 'de' y", new PatternCoordinates[] {
				of(ISO, "an"),
				of(ISO, "ast"),
				of(ISO, "oc"),
				});
		DATE_PATTERNS.put("'lyɛ'̌ʼ d 'na' MMMM, y", new PatternCoordinates[] {
				of(ISO, "nnh"),
				});
		DATE_PATTERNS.put("d MMMM, y", new PatternCoordinates[] {
				of(ISO, "as"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bn"),
				of(ISO, "brx"),
				of(ISO, "ccp"),
				of(ISO, "gu"),
				of(ISO, "ha"),
				of(ISO, "hi-Latn"),
				of(ISO, "ka"),
				of(ISO, "mni-Mtei"),
				of(ISO, "mr"),
				of(ISO, "ta"),
				of(ISO, "te"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "vi"),
				of(ISO, "wo"),
				});
		DATE_PATTERNS.put("y MMMM d", new PatternCoordinates[] {
				of(ISO, "ak"),
				of(ISO, "cch"),
				of(ISO, "cu"),
				of(ISO, "ii"),
				of(ISO, "jgo"),
				of(ISO, "kaj"),
				of(ISO, "kcg"),
				of(ISO, "mgo"),
				of(ISO, "ne"),
				of(ISO, "nso"),
				of(ISO, "ps"),
				of(ISO, ""),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "trv"),
				of(ISO, "vo"),
				});
		DATE_PATTERNS.put("MMMM d y", new PatternCoordinates[] {
				of(ISO, "blo"),
				});
		DATE_PATTERNS.put("MMMM d, y G", new PatternCoordinates[] {
				of(JAPANESE, "bs-Cyrl"),
				of(JAPANESE, "en"),
				of(JAPANESE, "sr"),
				of(JAPANESE, "sr-Latn"),
				});
		DATE_PATTERNS.put("y. MMMM d.", new PatternCoordinates[] {
				of(ISO, "hu"),
				});
		DATE_PATTERNS.put("d 'di' MMMM 'di' y", new PatternCoordinates[] {
				of(ISO, "kea"),
				});
		DATE_PATTERNS.put("d. MMMM y.", new PatternCoordinates[] {
				of(ISO, "bs"),
				of(ISO, "hr"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				});
		DATE_PATTERNS.put("d 'di' MMMM 'dal' y", new PatternCoordinates[] {
				of(ISO, "fur"),
				});
		DATE_PATTERNS.put("d'mh' MMMM y", new PatternCoordinates[] {
				of(ISO, "gd"),
				});
		DATE_PATTERNS.put("d MMMM ปีG y", new PatternCoordinates[] {
				of(JAPANESE, "th"),
				of(MINGUO, "th"),
				});
		DATE_PATTERNS.put("y ᠋ᠣᠨ ᠤMMMM᠎᠎ ᠤᠩ d", new PatternCoordinates[] {
				of(ISO, "mn-Mong-MN"),
				});
		DATE_TIME_PATTERNS.put("{1}, {0}", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(THAI_BUDDHIST, "ast"),
				of(ISO, "ast"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bg"),
				of(ISO, "blo"),
				of(ISO, "br"),
				of(ISO, "brx"),
				of(ISO, "bs"),
				of(THAI_BUDDHIST, "ca"),
				of(ISO, "ca"),
				of(ISO, "ceb"),
				of(ISO, "chr"),
				of(ISO, "co"),
				of(ISO, "cv"),
				of(ISO, "cy"),
				of(ISO, "de"),
				of(ISO, "doi"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-GB"),
				of(ISO, "en-IN"),
				of(ISO, "es"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-US"),
				of(ISO, "fil"),
				of(ISO, "fo"),
				of(ISO, "fr"),
				of(ISO, "fr-CA"),
				of(ISO, "frr"),
				of(ISO, "gl"),
				of(ISO, "ha"),
				of(ISO, "he"),
				of(ISO, "hi"),
				of(ISO, "hi-Latn"),
				of(ISO, "hy"),
				of(THAI_BUDDHIST, "id"),
				of(ISO, "ig"),
				of(ISO, "is"),
				of(ISO, "ka"),
				of(ISO, "kab"),
				of(ISO, "kea"),
				of(ISO, "kk"),
				of(ISO, "km"),
				of(ISO, "ks"),
				of(ISO, "ks-Deva"),
				of(ISO, "kxv"),
				of(ISO, "lij"),
				of(ISO, "lo"),
				of(ISO, "mai"),
				of(ISO, "mk"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "nds"),
				of(ISO, "nl"),
				of(ISO, "nnh"),
				of(ISO, "no"),
				of(ISO, "oc-ES"),
				of(ISO, "or"),
				of(ISO, "os"),
				of(THAI_BUDDHIST, "pa"),
				of(ISO, "pcm"),
				of(ISO, "pt-PT"),
				of(ISO, "rif"),
				of(ISO, "ro"),
				of(ISO, "ru"),
				of(ISO, "sa"),
				of(ISO, "sc"),
				of(ISO, "sd-Deva"),
				of(ISO, "sk"),
				of(ISO, "sq"),
				of(ISO, "su"),
				of(ISO, "ta"),
				of(ISO, "to"),
				of(ISO, "tt"),
				of(ISO, "uk"),
				of(ISO, "uz"),
				of(ISO, "vec"),
				});
		DATE_TIME_PATTERNS.put("{1} 'kl'. {0}", new PatternCoordinates[] {
				of(ISO, "nn"),
				});
		DATE_TIME_PATTERNS.put("{1} {0}", new PatternCoordinates[] {
				of(ISO, "af"),
				of(ISO, "am"),
				of(ISO, "as"),
				of(ISO, "az"),
				of(ISO, "bal"),
				of(ISO, "bal-Latn"),
				of(ISO, "bew"),
				of(ISO, "bn"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "ccp"),
				of(ISO, "ckb"),
				of(ISO, "cs"),
				of(JAPANESE, "cs"),
				of(ISO, "cu"),
				of(ISO, "da"),
				of(ISO, "dsb"),
				of(ISO, "dz"),
				of(ISO, "en-MV"),
				of(ISO, "eo"),
				of(ISO, "et"),
				of(ISO, "ff-Adlm"),
				of(ISO, "fi"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gu"),
				of(ISO, "haw"),
				of(ISO, "hr"),
				of(JAPANESE, "hr"),
				of(ISO, "hsb"),
				of(ISO, "hu"),
				of(ISO, "ia"),
				of(ISO, "id"),
				of(ISO, "ie"),
				of(ISO, "ii"),
				of(ISO, "it"),
				of(ISO, "ja"),
				of(JAPANESE, "ja"),
				of(ISO, "jgo"),
				of(ISO, "jv"),
				of(ISO, "kgp"),
				of(ISO, "kkj"),
				of(ISO, "kl"),
				of(ISO, "kn"),
				of(ISO, "ko"),
				of(ISO, "kok"),
				of(ISO, "ku"),
				of(ISO, "ky"),
				of(ISO, "lb"),
				of(ISO, "lt"),
				of(ISO, "lv"),
				of(ISO, "mg"),
				of(ISO, "mgo"),
				of(ISO, "mi"),
				of(THAI_BUDDHIST, "mk"),
				of(ISO, "ml"),
				of(ISO, "mn"),
				of(ISO, "ms"),
				of(ISO, "ms-Arab"),
				of(ISO, "mt"),
				of(ISO, "my"),
				of(ISO, "ne"),
				of(THAI_BUDDHIST, "nl"),
				of(JAPANESE, "nl"),
				of(MINGUO, "nl"),
				of(JAPANESE, "no"),
				of(ISO, "om"),
				of(ISO, "pa"),
				of(ISO, "pap"),
				of(ISO, "pl"),
				of(ISO, "prg"),
				of(ISO, "ps"),
				of(ISO, "pt"),
				of(ISO, "rm"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "sah"),
				of(ISO, "sat"),
				of(ISO, "sd"),
				of(ISO, "si"),
				of(ISO, "sl"),
				of(ISO, "smn"),
				of(ISO, "so"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(THAI_BUDDHIST, "sv"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "te"),
				of(ISO, "tg"),
				of(ISO, "th"),
				of(JAPANESE, "th"),
				of(ISO, "ti"),
				of(ISO, "tk"),
				of(ISO, "tr"),
				of(ISO, "trw"),
				of(ISO, "ug"),
				of(ISO, "ur"),
				of(ISO, "uz-Cyrl"),
				of(ISO, "xh"),
				of(ISO, "yi"),
				of(ISO, "yo"),
				of(ISO, "yrl"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				of(ISO, "yue"),
				of(JAPANESE, "yue"),
				of(ISO, "yue-Hans"),
				of(JAPANESE, "yue-Hans"),
				of(ISO, "zgh"),
				of(THAI_BUDDHIST, "zh"),
				of(ISO, "zh"),
				of(JAPANESE, "zh"),
				of(THAI_BUDDHIST, "zh-Hant"),
				of(ISO, "zh-Hant"),
				of(JAPANESE, "zh-Hant"),
				of(MINGUO, "zh-Hant"),
				of(ISO, "zh-Hant-HK"),
				of(ISO, "zu"),
				});
		DATE_TIME_PATTERNS.put("{1}، ساعت {0}", new PatternCoordinates[] {
				of(ISO, "fa"),
				});
		DATE_TIME_PATTERNS.put("{1} 'be' 'ni' 'atswa' {0}", new PatternCoordinates[] {
				of(ISO, "gaa"),
				});
		DATE_TIME_PATTERNS.put("{1} 'ka' {0}", new PatternCoordinates[] {
				of(ISO, "nso"),
				of(ISO, "tn"),
				});
		DATE_TIME_PATTERNS.put("{1} 'a' 'las' {0}", new PatternCoordinates[] {
				of(ISO, "an"),
				});
		DATE_TIME_PATTERNS.put("{1} 'ô' {0}", new PatternCoordinates[] {
				of(ISO, "szl"),
				});
		DATE_TIME_PATTERNS.put("{1}⹁ {0}", new PatternCoordinates[] {
				of(JAPANESE, "ff-Adlm"),
				});
		DATE_TIME_PATTERNS.put("{1} 'a' {0}", new PatternCoordinates[] {
				of(ISO, "oc"),
				});
		DATE_TIME_PATTERNS.put("{1} जो {0}", new PatternCoordinates[] {
				of(ISO, "xnr"),
				});
		DATE_TIME_PATTERNS.put("{0} {1}", new PatternCoordinates[] {
				of(ISO, "ee"),
				of(ISO, "qu"),
				of(ISO, "vi"),
				});
		DATE_TIME_PATTERNS.put("{1} - {0}", new PatternCoordinates[] {
				of(ISO, "el"),
				of(ISO, "wo"),
				});
		DATE_TIME_PATTERNS.put("{1} 'de' {0}", new PatternCoordinates[] {
				of(ISO, "la"),
				});
		DATE_TIME_PATTERNS.put("{1}، {0}", new PatternCoordinates[] {
				of(ISO, "ar"),
				of(ISO, "syr"),
				});
		DATE_TIME_PATTERNS.put("{1} ({0})", new PatternCoordinates[] {
				of(ISO, "eu"),
				});
		TIME_PATTERNS.put("HH:mm:ss z", new PatternCoordinates[] {
				of(ISO, "ab"),
				of(ISO, "af"),
				of(ISO, "agq"),
				of(ISO, "ar-KM"),
				of(ISO, "ar-MA"),
				of(ISO, "asa"),
				of(ISO, "ast"),
				of(ISO, "az"),
				of(ISO, "az-Cyrl"),
				of(ISO, "bas"),
				of(ISO, "be"),
				of(ISO, "be-TARASK"),
				of(ISO, "bez"),
				of(ISO, "blo"),
				of(ISO, "bm"),
				of(ISO, "bm-Nkoo"),
				of(ISO, "bo"),
				of(ISO, "br"),
				of(ISO, "bs"),
				of(ISO, "bs-Cyrl"),
				of(ISO, "cch"),
				of(ISO, "cgg"),
				of(ISO, "ckb-IR"),
				of(ISO, "co"),
				of(ISO, "cu"),
				of(ISO, "cv"),
				of(ISO, "cy"),
				of(ISO, "dav"),
				of(ISO, "de"),
				of(ISO, "dje"),
				of(ISO, "dua"),
				of(ISO, "dv"),
				of(ISO, "dyo"),
				of(ISO, "ebu"),
				of(ISO, "ee-TG"),
				of(ISO, "en-150"),
				of(ISO, "en-AI"),
				of(ISO, "en-BI"),
				of(ISO, "en-BW"),
				of(ISO, "en-BZ"),
				of(ISO, "en-CC"),
				of(ISO, "en-CK"),
				of(ISO, "en-CM"),
				of(ISO, "en-CX"),
				of(ISO, "en-DG"),
				of(ISO, "en-FK"),
				of(ISO, "en-GB"),
				of(ISO, "en-GG"),
				of(ISO, "en-GI"),
				of(ISO, "en-IE"),
				of(ISO, "en-IM"),
				of(ISO, "en-IO"),
				of(ISO, "en-JE"),
				of(ISO, "en-KE"),
				of(ISO, "en-MG"),
				of(ISO, "en-MS"),
				of(ISO, "en-MT"),
				of(ISO, "en-MU"),
				of(ISO, "en-MV"),
				of(ISO, "en-NF"),
				of(ISO, "en-NG"),
				of(ISO, "en-NR"),
				of(ISO, "en-NU"),
				of(ISO, "en-PN"),
				of(ISO, "en-RW"),
				of(ISO, "en-SC"),
				of(ISO, "en-SH"),
				of(ISO, "en-SX"),
				of(ISO, "en-TK"),
				of(ISO, "en-TV"),
				of(ISO, "en-TZ"),
				of(ISO, "en-UG"),
				of(ISO, "en-ZA"),
				of(ISO, "en-ZW"),
				of(ISO, "eo"),
				of(ISO, "es-BR"),
				of(ISO, "es-BZ"),
				of(ISO, "et"),
				of(ISO, "ewo"),
				of(ISO, "ff"),
				of(ISO, "ff-Adlm"),
				of(ISO, "fo"),
				of(ISO, "fr"),
				of(ISO, "frr"),
				of(ISO, "fur"),
				of(ISO, "fy"),
				of(ISO, "ga"),
				of(ISO, "gd"),
				of(ISO, "gl"),
				of(ISO, "gsw"),
				of(ISO, "guz"),
				of(ISO, "gv"),
				of(ISO, "ha"),
				of(ISO, "hr"),
				of(ISO, "hy"),
				of(ISO, "ia"),
				of(ISO, "ie"),
				of(ISO, "ig"),
				of(ISO, "ii"),
				of(ISO, "is"),
				of(ISO, "it"),
				of(ISO, "jgo"),
				of(ISO, "jmc"),
				of(ISO, "jv"),
				of(ISO, "ka"),
				of(ISO, "kaj"),
				of(ISO, "kam"),
				of(ISO, "kcg"),
				of(ISO, "kde"),
				of(ISO, "kea"),
				of(ISO, "kgp"),
				of(ISO, "khq"),
				of(ISO, "ki"),
				of(ISO, "kk"),
				of(ISO, "kln"),
				of(ISO, "kpe-GN"),
				of(ISO, "ksb"),
				of(ISO, "ksf"),
				of(ISO, "ksh"),
				of(ISO, "ku"),
				of(ISO, "kw"),
				of(ISO, "ky"),
				of(ISO, "la"),
				of(ISO, "lag"),
				of(ISO, "lb"),
				of(ISO, "lg"),
				of(ISO, "lij"),
				of(ISO, "ln"),
				of(ISO, "lt"),
				of(ISO, "lu"),
				of(ISO, "luo"),
				of(ISO, "luy"),
				of(ISO, "lv"),
				of(ISO, "mas"),
				of(ISO, "mer"),
				of(ISO, "mfe"),
				of(ISO, "mg"),
				of(ISO, "mgh"),
				of(ISO, "mgo"),
				of(ISO, "mk"),
				of(ISO, "mt"),
				of(ISO, "mua"),
				of(ISO, "nd"),
				of(ISO, "ne"),
				of(ISO, "nl"),
				of(ISO, "nmg"),
				of(ISO, "nn"),
				of(ISO, "no"),
				of(ISO, "nyn"),
				of(ISO, "om-KE"),
				of(ISO, "os"),
				of(ISO, "pap"),
				of(ISO, "pl"),
				of(ISO, "prg"),
				of(ISO, "pt"),
				of(ISO, "pt-PT"),
				of(ISO, "rhg"),
				of(ISO, "rif"),
				of(ISO, "rm"),
				of(ISO, "rn"),
				of(ISO, "ro"),
				of(ISO, "rof"),
				of(THAI_BUDDHIST, ""),
				of(ISO, ""),
				of(HIJRAH_UMALQURA, ""),
				of(JAPANESE, ""),
				of(MINGUO, ""),
				of(ISO, "ru"),
				of(ISO, "rwk"),
				of(ISO, "sah"),
				of(ISO, "saq"),
				of(ISO, "sbp"),
				of(ISO, "sc"),
				of(ISO, "seh"),
				of(ISO, "ses"),
				of(ISO, "sg"),
				of(ISO, "sl"),
				of(ISO, "so-KE"),
				of(ISO, "sq-MK"),
				of(ISO, "sq-XK"),
				of(ISO, "sr"),
				of(ISO, "sr-Latn"),
				of(ISO, "sv"),
				of(ISO, "sw"),
				of(ISO, "sw-KE"),
				of(ISO, "szl"),
				of(ISO, "ta-LK"),
				of(ISO, "teo"),
				of(ISO, "tg"),
				of(ISO, "tk"),
				of(ISO, "tn"),
				of(ISO, "tr"),
				of(ISO, "twq"),
				of(ISO, "ug"),
				of(ISO, "uk"),
				of(ISO, "vec"),
				of(ISO, "vi"),
				of(ISO, "vo"),
				of(ISO, "vun"),
				of(ISO, "wo"),
				of(ISO, "xh"),
				of(ISO, "xog"),
				of(ISO, "yav"),
				of(ISO, "yi"),
				of(ISO, "yrl"),
				of(ISO, "zgh"),
				of(ISO, "zu"),
				});
		TIME_PATTERNS.put("H ໂມງ m ນາທີ ss ວິນາທີ z", new PatternCoordinates[] {
				of(ISO, "lo"),
				});
		TIME_PATTERNS.put("h:mm:ss a, z", new PatternCoordinates[] {
				of(ISO, "sq"),
				});
		TIME_PATTERNS.put("hh:mm:ss a zzz", new PatternCoordinates[] {
				of(ISO, "bal"),
				});
		TIME_PATTERNS.put("HH:mm:ss (z)", new PatternCoordinates[] {
				of(ISO, "eu"),
				of(ISO, "mn"),
				of(ISO, "mn-Mong-MN"),
				of(ISO, "uz-Cyrl"),
				});
		TIME_PATTERNS.put("a 'ga' h:mm:ss z", new PatternCoordinates[] {
				of(ISO, "ee"),
				});
		TIME_PATTERNS.put("H:mm:ss z", new PatternCoordinates[] {
				of(ISO, "an"),
				of(ISO, "ar-IL"),
				of(ISO, "ca"),
				of(ISO, "cs"),
				of(ISO, "dsb"),
				of(ISO, "en-IL"),
				of(ISO, "es"),
				of(ISO, "he"),
				of(ISO, "hsb"),
				of(ISO, "hu"),
				of(ISO, "ja"),
				of(ISO, "oc-ES"),
				of(ISO, "pcm"),
				of(ISO, "sk"),
				of(ISO, "tt"),
				of(ISO, "yo"),
				});
		TIME_PATTERNS.put("H:mm:ss 'ч'. z", new PatternCoordinates[] {
				of(ISO, "bg"),
				});
		TIME_PATTERNS.put("hh:mm:ss a zzz", new PatternCoordinates[] {
				of(ISO, "bal-Latn"),
				of(ISO, "tpi"),
				});
		TIME_PATTERNS.put("a h:mm:ss z", new PatternCoordinates[] {
				of(ISO, "brx"),
				of(ISO, "ks-Deva"),
				});
		TIME_PATTERNS.put("H.mm.ss z", new PatternCoordinates[] {
				of(ISO, "en-FI"),
				of(ISO, "fi"),
				of(ISO, "smn"),
				of(ISO, "su"),
				});
		TIME_PATTERNS.put("h:mm:ss a z", new PatternCoordinates[] {
				of(ISO, "am"),
				of(ISO, "ar"),
				of(ISO, "bgc"),
				of(ISO, "bho"),
				of(ISO, "bn"),
				of(ISO, "bo-IN"),
				of(ISO, "byn"),
				of(ISO, "ccp"),
				of(ISO, "chr"),
				of(ISO, "ckb"),
				of(ISO, "doi"),
				of(ISO, "ff-Adlm-GH"),
				of(ISO, "ff-Adlm-GM"),
				of(ISO, "ff-Adlm-LR"),
				of(ISO, "ff-Adlm-MR"),
				of(ISO, "ff-Adlm-SL"),
				of(ISO, "gez"),
				of(ISO, "hi"),
				of(ISO, "iu"),
				of(ISO, "km"),
				of(ISO, "kok"),
				of(ISO, "ks"),
				of(ISO, "lrc-IQ"),
				of(ISO, "mai"),
				of(ISO, "ml"),
				of(ISO, "mni"),
				of(ISO, "mr"),
				of(ISO, "ms-Arab"),
				of(ISO, "ne-IN"),
				of(ISO, "or"),
				of(ISO, "osa"),
				of(ISO, "pa"),
				of(ISO, "pa-Arab"),
				of(ISO, "ps-PK"),
				of(ISO, "raj"),
				of(ISO, "rhg-Rohg-BD"),
				of(ISO, "sa"),
				of(ISO, "sat"),
				of(ISO, "sat-Deva"),
				of(ISO, "sd"),
				of(ISO, "sd-Deva"),
				of(ISO, "syr"),
				of(ISO, "ta"),
				of(ISO, "te"),
				of(ISO, "ti"),
				of(ISO, "tig"),
				of(ISO, "trw"),
				of(ISO, "ur"),
				of(ISO, "vai"),
				of(ISO, "wal"),
				of(ISO, "xnr"),
				});
		TIME_PATTERNS.put("a h.mm.ss z", new PatternCoordinates[] {
				of(ISO, "as"),
				});
		TIME_PATTERNS.put("hh:mm:ss a z", new PatternCoordinates[] {
				of(ISO, "gu"),
				of(ISO, "kn"),
				});
		TIME_PATTERNS.put("h.mm.ss a z", new PatternCoordinates[] {
				of(ISO, "mni-Mtei"),
				});
		TIME_PATTERNS.put("z ah:mm:ss", new PatternCoordinates[] {
				of(ISO, "zh-Hans-HK"),
				of(ISO, "zh-Hans-MO"),
				of(ISO, "zh-Hans-SG"),
				});
		TIME_PATTERNS.put("Bh:mm:ss [z]", new PatternCoordinates[] {
				of(ISO, "zh-Hant"),
				});
		TIME_PATTERNS.put("'Klock' H.mm:ss (z)", new PatternCoordinates[] {
				of(ISO, "nds"),
				});
		TIME_PATTERNS.put("z HH:mm:ss", new PatternCoordinates[] {
				of(ISO, "ko-CN"),
				of(ISO, "my"),
				of(ISO, "yue-Hans"),
				of(ISO, "zh"),
				});
		TIME_PATTERNS.put("HH 'h' mm 'min' ss 's' z", new PatternCoordinates[] {
				of(ISO, "fr-CA"),
				});
		TIME_PATTERNS.put("ah:mm:ss [z]", new PatternCoordinates[] {
				of(ISO, "yue"),
				of(ISO, "zh-Hant-HK"),
				});
		TIME_PATTERNS.put("H นาฬิกา mm นาที ss วินาที z", new PatternCoordinates[] {
				of(ISO, "th"),
				});
		TIME_PATTERNS.put("a h시 m분 s초 z", new PatternCoordinates[] {
				of(ISO, "ko"),
				});
		TIME_PATTERNS.put("HH.mm.ss z", new PatternCoordinates[] {
				of(ISO, "bew"),
				of(ISO, "da"),
				of(ISO, "en-DK"),
				of(ISO, "en-ID"),
				of(ISO, "id"),
				of(ISO, "kl"),
				of(ISO, "ms-ID"),
				of(ISO, "si"),
				});
		TIME_PATTERNS.put("h:mm:ss a z", new PatternCoordinates[] {
				of(ISO, "aa"),
				of(ISO, "af-NA"),
				of(ISO, "ak"),
				of(ISO, "bem"),
				of(ISO, "cad"),
				of(ISO, "ceb"),
				of(ISO, "cic"),
				of(ISO, "el"),
				of(ISO, "en"),
				of(ISO, "en-AU"),
				of(ISO, "en-CA"),
				of(ISO, "en-IN"),
				of(ISO, "es-419"),
				of(ISO, "es-MX"),
				of(ISO, "es-PH"),
				of(ISO, "es-US"),
				of(ISO, "ff-Latn-GH"),
				of(ISO, "ff-Latn-GM"),
				of(ISO, "ff-Latn-LR"),
				of(ISO, "ff-Latn-MR"),
				of(ISO, "ff-Latn-SL"),
				of(ISO, "fil"),
				of(ISO, "fr-DJ"),
				of(ISO, "fr-DZ"),
				of(ISO, "fr-MR"),
				of(ISO, "fr-SY"),
				of(ISO, "fr-TD"),
				of(ISO, "fr-TN"),
				of(ISO, "fr-VU"),
				of(ISO, "gaa"),
				of(ISO, "ha-GH"),
				of(ISO, "haw"),
				of(ISO, "hi-Latn"),
				of(ISO, "kab"),
				of(ISO, "kpe"),
				of(ISO, "kxv"),
				of(ISO, "lkt"),
				of(ISO, "mi"),
				of(ISO, "mic"),
				of(ISO, "moh"),
				of(ISO, "ms"),
				of(ISO, "mus"),
				of(ISO, "naq"),
				of(ISO, "ny"),
				of(ISO, "om"),
				of(ISO, "pt-MO"),
				of(ISO, "qu"),
				of(ISO, "sid"),
				of(ISO, "so"),
				of(ISO, "ss-SZ"),
				of(ISO, "ssy"),
				of(ISO, "st-LS"),
				of(ISO, "to"),
				of(ISO, "tr-CY"),
				of(ISO, "trv"),
				of(ISO, "vai-Latn"),
				of(ISO, "yrl-CO"),
				of(ISO, "yrl-VE"),
				});
		TIME_PATTERNS.put("ཆུ་ཚོད་ h སྐར་མ་ mm:ss a z", new PatternCoordinates[] {
				of(ISO, "dz"),
				});
		TIME_PATTERNS.put("H'h'mm:ss z", new PatternCoordinates[] {
				of(ISO, "oc"),
				});
		TIME_PATTERNS.put("z h:mm:ss a", new PatternCoordinates[] {
				of(ISO, "nus"),
				});
		TIME_PATTERNS.put("H:mm:ss (z)", new PatternCoordinates[] {
				of(ISO, "fa"),
				of(ISO, "ps"),
				of(ISO, "uz"),
				of(ISO, "uz-Arab"),
				});
	}
}
